// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an instance's Capacity Reservation targeting option. You can specify only one option at a time. Use the
 * CapacityReservationPreference parameter to configure the instance to run in On-Demand capacity or
 * to run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).
 * Use the CapacityReservationTarget parameter to explicitly target a specific Capacity Reservation or
 * a Capacity Reservation group.
 */
class LaunchTemplateCapacityReservationSpecificationRequest private constructor(builder: BuilderImpl) {
    /**
     * Indicates the instance's Capacity Reservation preferences. Possible preferences include:
     * open - The instance can run in any open Capacity Reservation that has matching attributes
     * (instance type, platform, Availability Zone).
     * none - The instance avoids running in a Capacity Reservation even if one is available. The instance
     * runs in On-Demand capacity.
     */
    val capacityReservationPreference: CapacityReservationPreference? = builder.capacityReservationPreference
    /**
     * Information about the target Capacity Reservation or Capacity Reservation group.
     */
    val capacityReservationTarget: CapacityReservationTarget? = builder.capacityReservationTarget

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LaunchTemplateCapacityReservationSpecificationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchTemplateCapacityReservationSpecificationRequest(")
        append("capacityReservationPreference=$capacityReservationPreference,")
        append("capacityReservationTarget=$capacityReservationTarget)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityReservationPreference?.hashCode() ?: 0
        result = 31 * result + (capacityReservationTarget?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LaunchTemplateCapacityReservationSpecificationRequest

        if (capacityReservationPreference != other.capacityReservationPreference) return false
        if (capacityReservationTarget != other.capacityReservationTarget) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LaunchTemplateCapacityReservationSpecificationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LaunchTemplateCapacityReservationSpecificationRequest
        /**
         * Indicates the instance's Capacity Reservation preferences. Possible preferences include:
         * open - The instance can run in any open Capacity Reservation that has matching attributes
         * (instance type, platform, Availability Zone).
         * none - The instance avoids running in a Capacity Reservation even if one is available. The instance
         * runs in On-Demand capacity.
         */
        fun capacityReservationPreference(capacityReservationPreference: CapacityReservationPreference): FluentBuilder
        /**
         * Information about the target Capacity Reservation or Capacity Reservation group.
         */
        fun capacityReservationTarget(capacityReservationTarget: CapacityReservationTarget): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates the instance's Capacity Reservation preferences. Possible preferences include:
         * open - The instance can run in any open Capacity Reservation that has matching attributes
         * (instance type, platform, Availability Zone).
         * none - The instance avoids running in a Capacity Reservation even if one is available. The instance
         * runs in On-Demand capacity.
         */
        var capacityReservationPreference: CapacityReservationPreference?
        /**
         * Information about the target Capacity Reservation or Capacity Reservation group.
         */
        var capacityReservationTarget: CapacityReservationTarget?

        fun build(): LaunchTemplateCapacityReservationSpecificationRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.CapacityReservationTarget] inside the given [block]
         */
        fun capacityReservationTarget(block: CapacityReservationTarget.DslBuilder.() -> kotlin.Unit) {
            this.capacityReservationTarget = CapacityReservationTarget.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var capacityReservationPreference: CapacityReservationPreference? = null
        override var capacityReservationTarget: CapacityReservationTarget? = null

        constructor(x: LaunchTemplateCapacityReservationSpecificationRequest) : this() {
            this.capacityReservationPreference = x.capacityReservationPreference
            this.capacityReservationTarget = x.capacityReservationTarget
        }

        override fun build(): LaunchTemplateCapacityReservationSpecificationRequest = LaunchTemplateCapacityReservationSpecificationRequest(this)
        override fun capacityReservationPreference(capacityReservationPreference: CapacityReservationPreference): FluentBuilder = apply { this.capacityReservationPreference = capacityReservationPreference }
        override fun capacityReservationTarget(capacityReservationTarget: CapacityReservationTarget): FluentBuilder = apply { this.capacityReservationTarget = capacityReservationTarget }
    }
}
