// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * The CPU options for the instance. Both the core count and threads per core
 * must be specified in the request.
 */
class LaunchTemplateCpuOptionsRequest private constructor(builder: BuilderImpl) {
    /**
     * The number of CPU cores for the instance.
     */
    val coreCount: Int? = builder.coreCount
    /**
     * The number of threads per CPU core. To disable multithreading
     * for the instance, specify a value of 1. Otherwise, specify the default value of 2.
     */
    val threadsPerCore: Int? = builder.threadsPerCore

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LaunchTemplateCpuOptionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchTemplateCpuOptionsRequest(")
        append("coreCount=$coreCount,")
        append("threadsPerCore=$threadsPerCore)")
    }

    override fun hashCode(): kotlin.Int {
        var result = coreCount ?: 0
        result = 31 * result + (threadsPerCore ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LaunchTemplateCpuOptionsRequest

        if (coreCount != other.coreCount) return false
        if (threadsPerCore != other.threadsPerCore) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LaunchTemplateCpuOptionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LaunchTemplateCpuOptionsRequest
        /**
         * The number of CPU cores for the instance.
         */
        fun coreCount(coreCount: Int): FluentBuilder
        /**
         * The number of threads per CPU core. To disable multithreading
         * for the instance, specify a value of 1. Otherwise, specify the default value of 2.
         */
        fun threadsPerCore(threadsPerCore: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of CPU cores for the instance.
         */
        var coreCount: Int?
        /**
         * The number of threads per CPU core. To disable multithreading
         * for the instance, specify a value of 1. Otherwise, specify the default value of 2.
         */
        var threadsPerCore: Int?

        fun build(): LaunchTemplateCpuOptionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var coreCount: Int? = null
        override var threadsPerCore: Int? = null

        constructor(x: LaunchTemplateCpuOptionsRequest) : this() {
            this.coreCount = x.coreCount
            this.threadsPerCore = x.threadsPerCore
        }

        override fun build(): LaunchTemplateCpuOptionsRequest = LaunchTemplateCpuOptionsRequest(this)
        override fun coreCount(coreCount: Int): FluentBuilder = apply { this.coreCount = coreCount }
        override fun threadsPerCore(threadsPerCore: Int): FluentBuilder = apply { this.threadsPerCore = threadsPerCore }
    }
}
