// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a block device for an EBS volume.
 */
class LaunchTemplateEbsBlockDevice private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether the EBS volume is deleted on instance termination.
     */
    val deleteOnTermination: Boolean? = builder.deleteOnTermination
    /**
     * Indicates whether the EBS volume is encrypted.
     */
    val encrypted: Boolean? = builder.encrypted
    /**
     * The number of I/O operations per second (IOPS) that the volume supports.
     */
    val iops: Int? = builder.iops
    /**
     * The ARN of the Key Management Service (KMS) CMK used for encryption.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The ID of the snapshot.
     */
    val snapshotId: String? = builder.snapshotId
    /**
     * The throughput that the volume supports, in MiB/s.
     */
    val throughput: Int? = builder.throughput
    /**
     * The size of the volume, in GiB.
     */
    val volumeSize: Int? = builder.volumeSize
    /**
     * The volume type.
     */
    val volumeType: VolumeType? = builder.volumeType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LaunchTemplateEbsBlockDevice = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchTemplateEbsBlockDevice(")
        append("deleteOnTermination=$deleteOnTermination,")
        append("encrypted=$encrypted,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("snapshotId=$snapshotId,")
        append("throughput=$throughput,")
        append("volumeSize=$volumeSize,")
        append("volumeType=$volumeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteOnTermination?.hashCode() ?: 0
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (throughput ?: 0)
        result = 31 * result + (volumeSize ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LaunchTemplateEbsBlockDevice

        if (deleteOnTermination != other.deleteOnTermination) return false
        if (encrypted != other.encrypted) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (snapshotId != other.snapshotId) return false
        if (throughput != other.throughput) return false
        if (volumeSize != other.volumeSize) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LaunchTemplateEbsBlockDevice = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LaunchTemplateEbsBlockDevice
        /**
         * Indicates whether the EBS volume is deleted on instance termination.
         */
        fun deleteOnTermination(deleteOnTermination: Boolean): FluentBuilder
        /**
         * Indicates whether the EBS volume is encrypted.
         */
        fun encrypted(encrypted: Boolean): FluentBuilder
        /**
         * The number of I/O operations per second (IOPS) that the volume supports.
         */
        fun iops(iops: Int): FluentBuilder
        /**
         * The ARN of the Key Management Service (KMS) CMK used for encryption.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The ID of the snapshot.
         */
        fun snapshotId(snapshotId: String): FluentBuilder
        /**
         * The throughput that the volume supports, in MiB/s.
         */
        fun throughput(throughput: Int): FluentBuilder
        /**
         * The size of the volume, in GiB.
         */
        fun volumeSize(volumeSize: Int): FluentBuilder
        /**
         * The volume type.
         */
        fun volumeType(volumeType: VolumeType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether the EBS volume is deleted on instance termination.
         */
        var deleteOnTermination: Boolean?
        /**
         * Indicates whether the EBS volume is encrypted.
         */
        var encrypted: Boolean?
        /**
         * The number of I/O operations per second (IOPS) that the volume supports.
         */
        var iops: Int?
        /**
         * The ARN of the Key Management Service (KMS) CMK used for encryption.
         */
        var kmsKeyId: String?
        /**
         * The ID of the snapshot.
         */
        var snapshotId: String?
        /**
         * The throughput that the volume supports, in MiB/s.
         */
        var throughput: Int?
        /**
         * The size of the volume, in GiB.
         */
        var volumeSize: Int?
        /**
         * The volume type.
         */
        var volumeType: VolumeType?

        fun build(): LaunchTemplateEbsBlockDevice
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deleteOnTermination: Boolean? = null
        override var encrypted: Boolean? = null
        override var iops: Int? = null
        override var kmsKeyId: String? = null
        override var snapshotId: String? = null
        override var throughput: Int? = null
        override var volumeSize: Int? = null
        override var volumeType: VolumeType? = null

        constructor(x: LaunchTemplateEbsBlockDevice) : this() {
            this.deleteOnTermination = x.deleteOnTermination
            this.encrypted = x.encrypted
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.snapshotId = x.snapshotId
            this.throughput = x.throughput
            this.volumeSize = x.volumeSize
            this.volumeType = x.volumeType
        }

        override fun build(): LaunchTemplateEbsBlockDevice = LaunchTemplateEbsBlockDevice(this)
        override fun deleteOnTermination(deleteOnTermination: Boolean): FluentBuilder = apply { this.deleteOnTermination = deleteOnTermination }
        override fun encrypted(encrypted: Boolean): FluentBuilder = apply { this.encrypted = encrypted }
        override fun iops(iops: Int): FluentBuilder = apply { this.iops = iops }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun snapshotId(snapshotId: String): FluentBuilder = apply { this.snapshotId = snapshotId }
        override fun throughput(throughput: Int): FluentBuilder = apply { this.throughput = throughput }
        override fun volumeSize(volumeSize: Int): FluentBuilder = apply { this.volumeSize = volumeSize }
        override fun volumeType(volumeType: VolumeType): FluentBuilder = apply { this.volumeType = volumeType }
    }
}
