// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * The parameters for a block device for an EBS volume.
 */
class LaunchTemplateEbsBlockDeviceRequest private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether the EBS volume is deleted on instance termination.
     */
    val deleteOnTermination: Boolean? = builder.deleteOnTermination
    /**
     * Indicates whether the EBS volume is encrypted. Encrypted volumes can only be attached to instances that support Amazon EBS encryption.
     * If you are creating a volume from a snapshot, you can't specify an encryption value.
     */
    val encrypted: Boolean? = builder.encrypted
    /**
     * The number of I/O operations per second (IOPS). For gp3, io1, and io2
     * volumes, this represents the number of IOPS that are provisioned for the volume. For gp2 volumes,
     * this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits
     * for bursting.
     * The following are the supported values for each volume type:
     * gp3: 3,000-16,000 IOPS
     * io1: 100-64,000 IOPS
     * io2: 100-64,000 IOPS
     * For io1 and io2 volumes, we guarantee 64,000 IOPS
     * only for <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System. Other instance families guarantee performance up
     * to 32,000 IOPS.
     * This parameter is supported for io1, io2, and gp3 volumes only. This parameter is not supported for
     * gp2, st1, sc1, or standard volumes.
     */
    val iops: Int? = builder.iops
    /**
     * The ARN of the symmetric Key Management Service (KMS) CMK used for
     * encryption.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The ID of the snapshot.
     */
    val snapshotId: String? = builder.snapshotId
    /**
     * The throughput to provision for a gp3 volume, with a maximum of 1,000 MiB/s.
     * Valid Range: Minimum value of 125. Maximum value of 1000.
     */
    val throughput: Int? = builder.throughput
    /**
     * The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. The following
     * are the supported volumes sizes for each volume type:
     * gp2 and gp3: 1-16,384
     * io1 and io2: 4-16,384
     * st1 and sc1: 125-16,384
     * standard: 1-1,024
     */
    val volumeSize: Int? = builder.volumeSize
    /**
     * The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    val volumeType: VolumeType? = builder.volumeType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LaunchTemplateEbsBlockDeviceRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchTemplateEbsBlockDeviceRequest(")
        append("deleteOnTermination=$deleteOnTermination,")
        append("encrypted=$encrypted,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("snapshotId=$snapshotId,")
        append("throughput=$throughput,")
        append("volumeSize=$volumeSize,")
        append("volumeType=$volumeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteOnTermination?.hashCode() ?: 0
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (throughput ?: 0)
        result = 31 * result + (volumeSize ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LaunchTemplateEbsBlockDeviceRequest

        if (deleteOnTermination != other.deleteOnTermination) return false
        if (encrypted != other.encrypted) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (snapshotId != other.snapshotId) return false
        if (throughput != other.throughput) return false
        if (volumeSize != other.volumeSize) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LaunchTemplateEbsBlockDeviceRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LaunchTemplateEbsBlockDeviceRequest
        /**
         * Indicates whether the EBS volume is deleted on instance termination.
         */
        fun deleteOnTermination(deleteOnTermination: Boolean): FluentBuilder
        /**
         * Indicates whether the EBS volume is encrypted. Encrypted volumes can only be attached to instances that support Amazon EBS encryption.
         * If you are creating a volume from a snapshot, you can't specify an encryption value.
         */
        fun encrypted(encrypted: Boolean): FluentBuilder
        /**
         * The number of I/O operations per second (IOPS). For gp3, io1, and io2
         * volumes, this represents the number of IOPS that are provisioned for the volume. For gp2 volumes,
         * this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits
         * for bursting.
         * The following are the supported values for each volume type:
         * gp3: 3,000-16,000 IOPS
         * io1: 100-64,000 IOPS
         * io2: 100-64,000 IOPS
         * For io1 and io2 volumes, we guarantee 64,000 IOPS
         * only for <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System. Other instance families guarantee performance up
         * to 32,000 IOPS.
         * This parameter is supported for io1, io2, and gp3 volumes only. This parameter is not supported for
         * gp2, st1, sc1, or standard volumes.
         */
        fun iops(iops: Int): FluentBuilder
        /**
         * The ARN of the symmetric Key Management Service (KMS) CMK used for
         * encryption.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The ID of the snapshot.
         */
        fun snapshotId(snapshotId: String): FluentBuilder
        /**
         * The throughput to provision for a gp3 volume, with a maximum of 1,000 MiB/s.
         * Valid Range: Minimum value of 125. Maximum value of 1000.
         */
        fun throughput(throughput: Int): FluentBuilder
        /**
         * The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. The following
         * are the supported volumes sizes for each volume type:
         * gp2 and gp3: 1-16,384
         * io1 and io2: 4-16,384
         * st1 and sc1: 125-16,384
         * standard: 1-1,024
         */
        fun volumeSize(volumeSize: Int): FluentBuilder
        /**
         * The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        fun volumeType(volumeType: VolumeType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether the EBS volume is deleted on instance termination.
         */
        var deleteOnTermination: Boolean?
        /**
         * Indicates whether the EBS volume is encrypted. Encrypted volumes can only be attached to instances that support Amazon EBS encryption.
         * If you are creating a volume from a snapshot, you can't specify an encryption value.
         */
        var encrypted: Boolean?
        /**
         * The number of I/O operations per second (IOPS). For gp3, io1, and io2
         * volumes, this represents the number of IOPS that are provisioned for the volume. For gp2 volumes,
         * this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits
         * for bursting.
         * The following are the supported values for each volume type:
         * gp3: 3,000-16,000 IOPS
         * io1: 100-64,000 IOPS
         * io2: 100-64,000 IOPS
         * For io1 and io2 volumes, we guarantee 64,000 IOPS
         * only for <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System. Other instance families guarantee performance up
         * to 32,000 IOPS.
         * This parameter is supported for io1, io2, and gp3 volumes only. This parameter is not supported for
         * gp2, st1, sc1, or standard volumes.
         */
        var iops: Int?
        /**
         * The ARN of the symmetric Key Management Service (KMS) CMK used for
         * encryption.
         */
        var kmsKeyId: String?
        /**
         * The ID of the snapshot.
         */
        var snapshotId: String?
        /**
         * The throughput to provision for a gp3 volume, with a maximum of 1,000 MiB/s.
         * Valid Range: Minimum value of 125. Maximum value of 1000.
         */
        var throughput: Int?
        /**
         * The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. The following
         * are the supported volumes sizes for each volume type:
         * gp2 and gp3: 1-16,384
         * io1 and io2: 4-16,384
         * st1 and sc1: 125-16,384
         * standard: 1-1,024
         */
        var volumeSize: Int?
        /**
         * The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        var volumeType: VolumeType?

        fun build(): LaunchTemplateEbsBlockDeviceRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deleteOnTermination: Boolean? = null
        override var encrypted: Boolean? = null
        override var iops: Int? = null
        override var kmsKeyId: String? = null
        override var snapshotId: String? = null
        override var throughput: Int? = null
        override var volumeSize: Int? = null
        override var volumeType: VolumeType? = null

        constructor(x: LaunchTemplateEbsBlockDeviceRequest) : this() {
            this.deleteOnTermination = x.deleteOnTermination
            this.encrypted = x.encrypted
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.snapshotId = x.snapshotId
            this.throughput = x.throughput
            this.volumeSize = x.volumeSize
            this.volumeType = x.volumeType
        }

        override fun build(): LaunchTemplateEbsBlockDeviceRequest = LaunchTemplateEbsBlockDeviceRequest(this)
        override fun deleteOnTermination(deleteOnTermination: Boolean): FluentBuilder = apply { this.deleteOnTermination = deleteOnTermination }
        override fun encrypted(encrypted: Boolean): FluentBuilder = apply { this.encrypted = encrypted }
        override fun iops(iops: Int): FluentBuilder = apply { this.iops = iops }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun snapshotId(snapshotId: String): FluentBuilder = apply { this.snapshotId = snapshotId }
        override fun throughput(throughput: Int): FluentBuilder = apply { this.throughput = throughput }
        override fun volumeSize(volumeSize: Int): FluentBuilder = apply { this.volumeSize = volumeSize }
        override fun volumeType(volumeType: VolumeType): FluentBuilder = apply { this.volumeType = volumeType }
    }
}
