// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a network interface.
 */
class LaunchTemplateInstanceNetworkInterfaceSpecification private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether to associate a Carrier IP address with eth0 for a new network interface.
     * Use this option when you launch an instance in a Wavelength Zone and want to associate
     * a Carrier IP address with the network interface. For more information about Carrier IP
     * addresses, see <a href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip">Carrier IP addresses in the Wavelength Developer
     * Guide.
     */
    val associateCarrierIpAddress: Boolean? = builder.associateCarrierIpAddress
    /**
     * Indicates whether to associate a public IPv4 address with eth0 for a new network interface.
     */
    val associatePublicIpAddress: Boolean? = builder.associatePublicIpAddress
    /**
     * Indicates whether the network interface is deleted when the instance is terminated.
     */
    val deleteOnTermination: Boolean? = builder.deleteOnTermination
    /**
     * A description for the network interface.
     */
    val description: String? = builder.description
    /**
     * The device index for the network interface attachment.
     */
    val deviceIndex: Int? = builder.deviceIndex
    /**
     * The IDs of one or more security groups.
     */
    val groups: List<String>? = builder.groups
    /**
     * The type of network interface.
     */
    val interfaceType: String? = builder.interfaceType
    /**
     * The number of IPv4 prefixes that Amazon Web Services automatically assigned to the
     * network interface.
     */
    val ipv4PrefixCount: Int? = builder.ipv4PrefixCount
    /**
     * One or more IPv4 prefixes assigned to the network interface.
     */
    val ipv4Prefixes: List<Ipv4PrefixSpecificationResponse>? = builder.ipv4Prefixes
    /**
     * The number of IPv6 addresses for the network interface.
     */
    val ipv6AddressCount: Int? = builder.ipv6AddressCount
    /**
     * The IPv6 addresses for the network interface.
     */
    val ipv6Addresses: List<InstanceIpv6Address>? = builder.ipv6Addresses
    /**
     * The number of IPv6 prefixes that Amazon Web Services automatically assigned to the network
     * interface.
     */
    val ipv6PrefixCount: Int? = builder.ipv6PrefixCount
    /**
     * One or more IPv6 prefixes assigned to the network interface.
     */
    val ipv6Prefixes: List<Ipv6PrefixSpecificationResponse>? = builder.ipv6Prefixes
    /**
     * The index of the network card.
     */
    val networkCardIndex: Int? = builder.networkCardIndex
    /**
     * The ID of the network interface.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * The primary private IPv4 address of the network interface.
     */
    val privateIpAddress: String? = builder.privateIpAddress
    /**
     * One or more private IPv4 addresses.
     */
    val privateIpAddresses: List<PrivateIpAddressSpecification>? = builder.privateIpAddresses
    /**
     * The number of secondary private IPv4 addresses for the network interface.
     */
    val secondaryPrivateIpAddressCount: Int? = builder.secondaryPrivateIpAddressCount
    /**
     * The ID of the subnet for the network interface.
     */
    val subnetId: String? = builder.subnetId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LaunchTemplateInstanceNetworkInterfaceSpecification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchTemplateInstanceNetworkInterfaceSpecification(")
        append("associateCarrierIpAddress=$associateCarrierIpAddress,")
        append("associatePublicIpAddress=$associatePublicIpAddress,")
        append("deleteOnTermination=$deleteOnTermination,")
        append("description=$description,")
        append("deviceIndex=$deviceIndex,")
        append("groups=$groups,")
        append("interfaceType=$interfaceType,")
        append("ipv4PrefixCount=$ipv4PrefixCount,")
        append("ipv4Prefixes=$ipv4Prefixes,")
        append("ipv6AddressCount=$ipv6AddressCount,")
        append("ipv6Addresses=$ipv6Addresses,")
        append("ipv6PrefixCount=$ipv6PrefixCount,")
        append("ipv6Prefixes=$ipv6Prefixes,")
        append("networkCardIndex=$networkCardIndex,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("privateIpAddress=$privateIpAddress,")
        append("privateIpAddresses=$privateIpAddresses,")
        append("secondaryPrivateIpAddressCount=$secondaryPrivateIpAddressCount,")
        append("subnetId=$subnetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associateCarrierIpAddress?.hashCode() ?: 0
        result = 31 * result + (associatePublicIpAddress?.hashCode() ?: 0)
        result = 31 * result + (deleteOnTermination?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (deviceIndex ?: 0)
        result = 31 * result + (groups?.hashCode() ?: 0)
        result = 31 * result + (interfaceType?.hashCode() ?: 0)
        result = 31 * result + (ipv4PrefixCount ?: 0)
        result = 31 * result + (ipv4Prefixes?.hashCode() ?: 0)
        result = 31 * result + (ipv6AddressCount ?: 0)
        result = 31 * result + (ipv6Addresses?.hashCode() ?: 0)
        result = 31 * result + (ipv6PrefixCount ?: 0)
        result = 31 * result + (ipv6Prefixes?.hashCode() ?: 0)
        result = 31 * result + (networkCardIndex ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddresses?.hashCode() ?: 0)
        result = 31 * result + (secondaryPrivateIpAddressCount ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LaunchTemplateInstanceNetworkInterfaceSpecification

        if (associateCarrierIpAddress != other.associateCarrierIpAddress) return false
        if (associatePublicIpAddress != other.associatePublicIpAddress) return false
        if (deleteOnTermination != other.deleteOnTermination) return false
        if (description != other.description) return false
        if (deviceIndex != other.deviceIndex) return false
        if (groups != other.groups) return false
        if (interfaceType != other.interfaceType) return false
        if (ipv4PrefixCount != other.ipv4PrefixCount) return false
        if (ipv4Prefixes != other.ipv4Prefixes) return false
        if (ipv6AddressCount != other.ipv6AddressCount) return false
        if (ipv6Addresses != other.ipv6Addresses) return false
        if (ipv6PrefixCount != other.ipv6PrefixCount) return false
        if (ipv6Prefixes != other.ipv6Prefixes) return false
        if (networkCardIndex != other.networkCardIndex) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (privateIpAddresses != other.privateIpAddresses) return false
        if (secondaryPrivateIpAddressCount != other.secondaryPrivateIpAddressCount) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LaunchTemplateInstanceNetworkInterfaceSpecification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LaunchTemplateInstanceNetworkInterfaceSpecification
        /**
         * Indicates whether to associate a Carrier IP address with eth0 for a new network interface.
         * Use this option when you launch an instance in a Wavelength Zone and want to associate
         * a Carrier IP address with the network interface. For more information about Carrier IP
         * addresses, see <a href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip">Carrier IP addresses in the Wavelength Developer
         * Guide.
         */
        fun associateCarrierIpAddress(associateCarrierIpAddress: Boolean): FluentBuilder
        /**
         * Indicates whether to associate a public IPv4 address with eth0 for a new network interface.
         */
        fun associatePublicIpAddress(associatePublicIpAddress: Boolean): FluentBuilder
        /**
         * Indicates whether the network interface is deleted when the instance is terminated.
         */
        fun deleteOnTermination(deleteOnTermination: Boolean): FluentBuilder
        /**
         * A description for the network interface.
         */
        fun description(description: String): FluentBuilder
        /**
         * The device index for the network interface attachment.
         */
        fun deviceIndex(deviceIndex: Int): FluentBuilder
        /**
         * The IDs of one or more security groups.
         */
        fun groups(groups: List<String>): FluentBuilder
        /**
         * The type of network interface.
         */
        fun interfaceType(interfaceType: String): FluentBuilder
        /**
         * The number of IPv4 prefixes that Amazon Web Services automatically assigned to the
         * network interface.
         */
        fun ipv4PrefixCount(ipv4PrefixCount: Int): FluentBuilder
        /**
         * One or more IPv4 prefixes assigned to the network interface.
         */
        fun ipv4Prefixes(ipv4Prefixes: List<Ipv4PrefixSpecificationResponse>): FluentBuilder
        /**
         * The number of IPv6 addresses for the network interface.
         */
        fun ipv6AddressCount(ipv6AddressCount: Int): FluentBuilder
        /**
         * The IPv6 addresses for the network interface.
         */
        fun ipv6Addresses(ipv6Addresses: List<InstanceIpv6Address>): FluentBuilder
        /**
         * The number of IPv6 prefixes that Amazon Web Services automatically assigned to the network
         * interface.
         */
        fun ipv6PrefixCount(ipv6PrefixCount: Int): FluentBuilder
        /**
         * One or more IPv6 prefixes assigned to the network interface.
         */
        fun ipv6Prefixes(ipv6Prefixes: List<Ipv6PrefixSpecificationResponse>): FluentBuilder
        /**
         * The index of the network card.
         */
        fun networkCardIndex(networkCardIndex: Int): FluentBuilder
        /**
         * The ID of the network interface.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * The primary private IPv4 address of the network interface.
         */
        fun privateIpAddress(privateIpAddress: String): FluentBuilder
        /**
         * One or more private IPv4 addresses.
         */
        fun privateIpAddresses(privateIpAddresses: List<PrivateIpAddressSpecification>): FluentBuilder
        /**
         * The number of secondary private IPv4 addresses for the network interface.
         */
        fun secondaryPrivateIpAddressCount(secondaryPrivateIpAddressCount: Int): FluentBuilder
        /**
         * The ID of the subnet for the network interface.
         */
        fun subnetId(subnetId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether to associate a Carrier IP address with eth0 for a new network interface.
         * Use this option when you launch an instance in a Wavelength Zone and want to associate
         * a Carrier IP address with the network interface. For more information about Carrier IP
         * addresses, see <a href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip">Carrier IP addresses in the Wavelength Developer
         * Guide.
         */
        var associateCarrierIpAddress: Boolean?
        /**
         * Indicates whether to associate a public IPv4 address with eth0 for a new network interface.
         */
        var associatePublicIpAddress: Boolean?
        /**
         * Indicates whether the network interface is deleted when the instance is terminated.
         */
        var deleteOnTermination: Boolean?
        /**
         * A description for the network interface.
         */
        var description: String?
        /**
         * The device index for the network interface attachment.
         */
        var deviceIndex: Int?
        /**
         * The IDs of one or more security groups.
         */
        var groups: List<String>?
        /**
         * The type of network interface.
         */
        var interfaceType: String?
        /**
         * The number of IPv4 prefixes that Amazon Web Services automatically assigned to the
         * network interface.
         */
        var ipv4PrefixCount: Int?
        /**
         * One or more IPv4 prefixes assigned to the network interface.
         */
        var ipv4Prefixes: List<Ipv4PrefixSpecificationResponse>?
        /**
         * The number of IPv6 addresses for the network interface.
         */
        var ipv6AddressCount: Int?
        /**
         * The IPv6 addresses for the network interface.
         */
        var ipv6Addresses: List<InstanceIpv6Address>?
        /**
         * The number of IPv6 prefixes that Amazon Web Services automatically assigned to the network
         * interface.
         */
        var ipv6PrefixCount: Int?
        /**
         * One or more IPv6 prefixes assigned to the network interface.
         */
        var ipv6Prefixes: List<Ipv6PrefixSpecificationResponse>?
        /**
         * The index of the network card.
         */
        var networkCardIndex: Int?
        /**
         * The ID of the network interface.
         */
        var networkInterfaceId: String?
        /**
         * The primary private IPv4 address of the network interface.
         */
        var privateIpAddress: String?
        /**
         * One or more private IPv4 addresses.
         */
        var privateIpAddresses: List<PrivateIpAddressSpecification>?
        /**
         * The number of secondary private IPv4 addresses for the network interface.
         */
        var secondaryPrivateIpAddressCount: Int?
        /**
         * The ID of the subnet for the network interface.
         */
        var subnetId: String?

        fun build(): LaunchTemplateInstanceNetworkInterfaceSpecification
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associateCarrierIpAddress: Boolean? = null
        override var associatePublicIpAddress: Boolean? = null
        override var deleteOnTermination: Boolean? = null
        override var description: String? = null
        override var deviceIndex: Int? = null
        override var groups: List<String>? = null
        override var interfaceType: String? = null
        override var ipv4PrefixCount: Int? = null
        override var ipv4Prefixes: List<Ipv4PrefixSpecificationResponse>? = null
        override var ipv6AddressCount: Int? = null
        override var ipv6Addresses: List<InstanceIpv6Address>? = null
        override var ipv6PrefixCount: Int? = null
        override var ipv6Prefixes: List<Ipv6PrefixSpecificationResponse>? = null
        override var networkCardIndex: Int? = null
        override var networkInterfaceId: String? = null
        override var privateIpAddress: String? = null
        override var privateIpAddresses: List<PrivateIpAddressSpecification>? = null
        override var secondaryPrivateIpAddressCount: Int? = null
        override var subnetId: String? = null

        constructor(x: LaunchTemplateInstanceNetworkInterfaceSpecification) : this() {
            this.associateCarrierIpAddress = x.associateCarrierIpAddress
            this.associatePublicIpAddress = x.associatePublicIpAddress
            this.deleteOnTermination = x.deleteOnTermination
            this.description = x.description
            this.deviceIndex = x.deviceIndex
            this.groups = x.groups
            this.interfaceType = x.interfaceType
            this.ipv4PrefixCount = x.ipv4PrefixCount
            this.ipv4Prefixes = x.ipv4Prefixes
            this.ipv6AddressCount = x.ipv6AddressCount
            this.ipv6Addresses = x.ipv6Addresses
            this.ipv6PrefixCount = x.ipv6PrefixCount
            this.ipv6Prefixes = x.ipv6Prefixes
            this.networkCardIndex = x.networkCardIndex
            this.networkInterfaceId = x.networkInterfaceId
            this.privateIpAddress = x.privateIpAddress
            this.privateIpAddresses = x.privateIpAddresses
            this.secondaryPrivateIpAddressCount = x.secondaryPrivateIpAddressCount
            this.subnetId = x.subnetId
        }

        override fun build(): LaunchTemplateInstanceNetworkInterfaceSpecification = LaunchTemplateInstanceNetworkInterfaceSpecification(this)
        override fun associateCarrierIpAddress(associateCarrierIpAddress: Boolean): FluentBuilder = apply { this.associateCarrierIpAddress = associateCarrierIpAddress }
        override fun associatePublicIpAddress(associatePublicIpAddress: Boolean): FluentBuilder = apply { this.associatePublicIpAddress = associatePublicIpAddress }
        override fun deleteOnTermination(deleteOnTermination: Boolean): FluentBuilder = apply { this.deleteOnTermination = deleteOnTermination }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun deviceIndex(deviceIndex: Int): FluentBuilder = apply { this.deviceIndex = deviceIndex }
        override fun groups(groups: List<String>): FluentBuilder = apply { this.groups = groups }
        override fun interfaceType(interfaceType: String): FluentBuilder = apply { this.interfaceType = interfaceType }
        override fun ipv4PrefixCount(ipv4PrefixCount: Int): FluentBuilder = apply { this.ipv4PrefixCount = ipv4PrefixCount }
        override fun ipv4Prefixes(ipv4Prefixes: List<Ipv4PrefixSpecificationResponse>): FluentBuilder = apply { this.ipv4Prefixes = ipv4Prefixes }
        override fun ipv6AddressCount(ipv6AddressCount: Int): FluentBuilder = apply { this.ipv6AddressCount = ipv6AddressCount }
        override fun ipv6Addresses(ipv6Addresses: List<InstanceIpv6Address>): FluentBuilder = apply { this.ipv6Addresses = ipv6Addresses }
        override fun ipv6PrefixCount(ipv6PrefixCount: Int): FluentBuilder = apply { this.ipv6PrefixCount = ipv6PrefixCount }
        override fun ipv6Prefixes(ipv6Prefixes: List<Ipv6PrefixSpecificationResponse>): FluentBuilder = apply { this.ipv6Prefixes = ipv6Prefixes }
        override fun networkCardIndex(networkCardIndex: Int): FluentBuilder = apply { this.networkCardIndex = networkCardIndex }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun privateIpAddress(privateIpAddress: String): FluentBuilder = apply { this.privateIpAddress = privateIpAddress }
        override fun privateIpAddresses(privateIpAddresses: List<PrivateIpAddressSpecification>): FluentBuilder = apply { this.privateIpAddresses = privateIpAddresses }
        override fun secondaryPrivateIpAddressCount(secondaryPrivateIpAddressCount: Int): FluentBuilder = apply { this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
    }
}
