// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The options for Spot Instances.
 */
class LaunchTemplateSpotMarketOptionsRequest private constructor(builder: BuilderImpl) {
    /**
     * The required duration for the Spot Instances (also known as Spot blocks), in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300, or 360).
     */
    val blockDurationMinutes: Int? = builder.blockDurationMinutes
    /**
     * The behavior when a Spot Instance is interrupted. The default is terminate.
     */
    val instanceInterruptionBehavior: InstanceInterruptionBehavior? = builder.instanceInterruptionBehavior
    /**
     * The maximum hourly price you're willing to pay for the Spot Instances.
     */
    val maxPrice: String? = builder.maxPrice
    /**
     * The Spot Instance request type.
     */
    val spotInstanceType: SpotInstanceType? = builder.spotInstanceType
    /**
     * The end date of the request.
     * For a one-time request, the request remains active until all instances launch, the request is canceled, or this date is reached.
     * If the request is persistent, it remains active until it is canceled or this date and time is reached.
     * The default end date is 7 days from the current date.
     */
    val validUntil: Instant? = builder.validUntil

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LaunchTemplateSpotMarketOptionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchTemplateSpotMarketOptionsRequest(")
        append("blockDurationMinutes=$blockDurationMinutes,")
        append("instanceInterruptionBehavior=$instanceInterruptionBehavior,")
        append("maxPrice=$maxPrice,")
        append("spotInstanceType=$spotInstanceType,")
        append("validUntil=$validUntil)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockDurationMinutes ?: 0
        result = 31 * result + (instanceInterruptionBehavior?.hashCode() ?: 0)
        result = 31 * result + (maxPrice?.hashCode() ?: 0)
        result = 31 * result + (spotInstanceType?.hashCode() ?: 0)
        result = 31 * result + (validUntil?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LaunchTemplateSpotMarketOptionsRequest

        if (blockDurationMinutes != other.blockDurationMinutes) return false
        if (instanceInterruptionBehavior != other.instanceInterruptionBehavior) return false
        if (maxPrice != other.maxPrice) return false
        if (spotInstanceType != other.spotInstanceType) return false
        if (validUntil != other.validUntil) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LaunchTemplateSpotMarketOptionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LaunchTemplateSpotMarketOptionsRequest
        /**
         * The required duration for the Spot Instances (also known as Spot blocks), in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300, or 360).
         */
        fun blockDurationMinutes(blockDurationMinutes: Int): FluentBuilder
        /**
         * The behavior when a Spot Instance is interrupted. The default is terminate.
         */
        fun instanceInterruptionBehavior(instanceInterruptionBehavior: InstanceInterruptionBehavior): FluentBuilder
        /**
         * The maximum hourly price you're willing to pay for the Spot Instances.
         */
        fun maxPrice(maxPrice: String): FluentBuilder
        /**
         * The Spot Instance request type.
         */
        fun spotInstanceType(spotInstanceType: SpotInstanceType): FluentBuilder
        /**
         * The end date of the request.
         * For a one-time request, the request remains active until all instances launch, the request is canceled, or this date is reached.
         * If the request is persistent, it remains active until it is canceled or this date and time is reached.
         * The default end date is 7 days from the current date.
         */
        fun validUntil(validUntil: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The required duration for the Spot Instances (also known as Spot blocks), in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300, or 360).
         */
        var blockDurationMinutes: Int?
        /**
         * The behavior when a Spot Instance is interrupted. The default is terminate.
         */
        var instanceInterruptionBehavior: InstanceInterruptionBehavior?
        /**
         * The maximum hourly price you're willing to pay for the Spot Instances.
         */
        var maxPrice: String?
        /**
         * The Spot Instance request type.
         */
        var spotInstanceType: SpotInstanceType?
        /**
         * The end date of the request.
         * For a one-time request, the request remains active until all instances launch, the request is canceled, or this date is reached.
         * If the request is persistent, it remains active until it is canceled or this date and time is reached.
         * The default end date is 7 days from the current date.
         */
        var validUntil: Instant?

        fun build(): LaunchTemplateSpotMarketOptionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var blockDurationMinutes: Int? = null
        override var instanceInterruptionBehavior: InstanceInterruptionBehavior? = null
        override var maxPrice: String? = null
        override var spotInstanceType: SpotInstanceType? = null
        override var validUntil: Instant? = null

        constructor(x: LaunchTemplateSpotMarketOptionsRequest) : this() {
            this.blockDurationMinutes = x.blockDurationMinutes
            this.instanceInterruptionBehavior = x.instanceInterruptionBehavior
            this.maxPrice = x.maxPrice
            this.spotInstanceType = x.spotInstanceType
            this.validUntil = x.validUntil
        }

        override fun build(): LaunchTemplateSpotMarketOptionsRequest = LaunchTemplateSpotMarketOptionsRequest(this)
        override fun blockDurationMinutes(blockDurationMinutes: Int): FluentBuilder = apply { this.blockDurationMinutes = blockDurationMinutes }
        override fun instanceInterruptionBehavior(instanceInterruptionBehavior: InstanceInterruptionBehavior): FluentBuilder = apply { this.instanceInterruptionBehavior = instanceInterruptionBehavior }
        override fun maxPrice(maxPrice: String): FluentBuilder = apply { this.maxPrice = maxPrice }
        override fun spotInstanceType(spotInstanceType: SpotInstanceType): FluentBuilder = apply { this.spotInstanceType = spotInstanceType }
        override fun validUntil(validUntil: Instant): FluentBuilder = apply { this.validUntil = validUntil }
    }
}
