// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * The tags specification for the launch template.
 */
class LaunchTemplateTagSpecificationRequest private constructor(builder: BuilderImpl) {
    /**
     * The type of resource to tag. Currently, the resource types that support tagging on
     * creation are instance and volume. To tag a resource after it
     * has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags.
     */
    val resourceType: ResourceType? = builder.resourceType
    /**
     * The tags to apply to the resource.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LaunchTemplateTagSpecificationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchTemplateTagSpecificationRequest(")
        append("resourceType=$resourceType,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceType?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LaunchTemplateTagSpecificationRequest

        if (resourceType != other.resourceType) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LaunchTemplateTagSpecificationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LaunchTemplateTagSpecificationRequest
        /**
         * The type of resource to tag. Currently, the resource types that support tagging on
         * creation are instance and volume. To tag a resource after it
         * has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags.
         */
        fun resourceType(resourceType: ResourceType): FluentBuilder
        /**
         * The tags to apply to the resource.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The type of resource to tag. Currently, the resource types that support tagging on
         * creation are instance and volume. To tag a resource after it
         * has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags.
         */
        var resourceType: ResourceType?
        /**
         * The tags to apply to the resource.
         */
        var tags: List<Tag>?

        fun build(): LaunchTemplateTagSpecificationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var resourceType: ResourceType? = null
        override var tags: List<Tag>? = null

        constructor(x: LaunchTemplateTagSpecificationRequest) : this() {
            this.resourceType = x.resourceType
            this.tags = x.tags
        }

        override fun build(): LaunchTemplateTagSpecificationRequest = LaunchTemplateTagSpecificationRequest(this)
        override fun resourceType(resourceType: ResourceType): FluentBuilder = apply { this.resourceType = resourceType }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
