// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a launch template version.
 */
class LaunchTemplateVersion private constructor(builder: BuilderImpl) {
    /**
     * The time the version was created.
     */
    val createTime: Instant? = builder.createTime
    /**
     * The principal that created the version.
     */
    val createdBy: String? = builder.createdBy
    /**
     * Indicates whether the version is the default version.
     */
    val defaultVersion: Boolean? = builder.defaultVersion
    /**
     * Information about the launch template.
     */
    val launchTemplateData: ResponseLaunchTemplateData? = builder.launchTemplateData
    /**
     * The ID of the launch template.
     */
    val launchTemplateId: String? = builder.launchTemplateId
    /**
     * The name of the launch template.
     */
    val launchTemplateName: String? = builder.launchTemplateName
    /**
     * The description for the version.
     */
    val versionDescription: String? = builder.versionDescription
    /**
     * The version number.
     */
    val versionNumber: Long? = builder.versionNumber

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LaunchTemplateVersion = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchTemplateVersion(")
        append("createTime=$createTime,")
        append("createdBy=$createdBy,")
        append("defaultVersion=$defaultVersion,")
        append("launchTemplateData=$launchTemplateData,")
        append("launchTemplateId=$launchTemplateId,")
        append("launchTemplateName=$launchTemplateName,")
        append("versionDescription=$versionDescription,")
        append("versionNumber=$versionNumber)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime?.hashCode() ?: 0
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (defaultVersion?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateData?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateId?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateName?.hashCode() ?: 0)
        result = 31 * result + (versionDescription?.hashCode() ?: 0)
        result = 31 * result + (versionNumber?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LaunchTemplateVersion

        if (createTime != other.createTime) return false
        if (createdBy != other.createdBy) return false
        if (defaultVersion != other.defaultVersion) return false
        if (launchTemplateData != other.launchTemplateData) return false
        if (launchTemplateId != other.launchTemplateId) return false
        if (launchTemplateName != other.launchTemplateName) return false
        if (versionDescription != other.versionDescription) return false
        if (versionNumber != other.versionNumber) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LaunchTemplateVersion = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LaunchTemplateVersion
        /**
         * The time the version was created.
         */
        fun createTime(createTime: Instant): FluentBuilder
        /**
         * The principal that created the version.
         */
        fun createdBy(createdBy: String): FluentBuilder
        /**
         * Indicates whether the version is the default version.
         */
        fun defaultVersion(defaultVersion: Boolean): FluentBuilder
        /**
         * Information about the launch template.
         */
        fun launchTemplateData(launchTemplateData: ResponseLaunchTemplateData): FluentBuilder
        /**
         * The ID of the launch template.
         */
        fun launchTemplateId(launchTemplateId: String): FluentBuilder
        /**
         * The name of the launch template.
         */
        fun launchTemplateName(launchTemplateName: String): FluentBuilder
        /**
         * The description for the version.
         */
        fun versionDescription(versionDescription: String): FluentBuilder
        /**
         * The version number.
         */
        fun versionNumber(versionNumber: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The time the version was created.
         */
        var createTime: Instant?
        /**
         * The principal that created the version.
         */
        var createdBy: String?
        /**
         * Indicates whether the version is the default version.
         */
        var defaultVersion: Boolean?
        /**
         * Information about the launch template.
         */
        var launchTemplateData: ResponseLaunchTemplateData?
        /**
         * The ID of the launch template.
         */
        var launchTemplateId: String?
        /**
         * The name of the launch template.
         */
        var launchTemplateName: String?
        /**
         * The description for the version.
         */
        var versionDescription: String?
        /**
         * The version number.
         */
        var versionNumber: Long?

        fun build(): LaunchTemplateVersion
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ResponseLaunchTemplateData] inside the given [block]
         */
        fun launchTemplateData(block: ResponseLaunchTemplateData.DslBuilder.() -> kotlin.Unit) {
            this.launchTemplateData = ResponseLaunchTemplateData.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var createTime: Instant? = null
        override var createdBy: String? = null
        override var defaultVersion: Boolean? = null
        override var launchTemplateData: ResponseLaunchTemplateData? = null
        override var launchTemplateId: String? = null
        override var launchTemplateName: String? = null
        override var versionDescription: String? = null
        override var versionNumber: Long? = null

        constructor(x: LaunchTemplateVersion) : this() {
            this.createTime = x.createTime
            this.createdBy = x.createdBy
            this.defaultVersion = x.defaultVersion
            this.launchTemplateData = x.launchTemplateData
            this.launchTemplateId = x.launchTemplateId
            this.launchTemplateName = x.launchTemplateName
            this.versionDescription = x.versionDescription
            this.versionNumber = x.versionNumber
        }

        override fun build(): LaunchTemplateVersion = LaunchTemplateVersion(this)
        override fun createTime(createTime: Instant): FluentBuilder = apply { this.createTime = createTime }
        override fun createdBy(createdBy: String): FluentBuilder = apply { this.createdBy = createdBy }
        override fun defaultVersion(defaultVersion: Boolean): FluentBuilder = apply { this.defaultVersion = defaultVersion }
        override fun launchTemplateData(launchTemplateData: ResponseLaunchTemplateData): FluentBuilder = apply { this.launchTemplateData = launchTemplateData }
        override fun launchTemplateId(launchTemplateId: String): FluentBuilder = apply { this.launchTemplateId = launchTemplateId }
        override fun launchTemplateName(launchTemplateName: String): FluentBuilder = apply { this.launchTemplateName = launchTemplateName }
        override fun versionDescription(versionDescription: String): FluentBuilder = apply { this.versionDescription = versionDescription }
        override fun versionNumber(versionNumber: Long): FluentBuilder = apply { this.versionNumber = versionNumber }
    }
}
