// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a route for a local gateway route table.
 */
class LocalGatewayRoute private constructor(builder: BuilderImpl) {
    /**
     * The CIDR block used for destination matches.
     */
    val destinationCidrBlock: String? = builder.destinationCidrBlock
    /**
     * The Amazon Resource Name (ARN) of the local gateway route table.
     */
    val localGatewayRouteTableArn: String? = builder.localGatewayRouteTableArn
    /**
     * The ID of the local gateway route table.
     */
    val localGatewayRouteTableId: String? = builder.localGatewayRouteTableId
    /**
     * The ID of the virtual interface group.
     */
    val localGatewayVirtualInterfaceGroupId: String? = builder.localGatewayVirtualInterfaceGroupId
    /**
     * The ID of the Amazon Web Services account that owns the local gateway route.
     */
    val ownerId: String? = builder.ownerId
    /**
     * The state of the route.
     */
    val state: LocalGatewayRouteState? = builder.state
    /**
     * The route type.
     */
    val type: LocalGatewayRouteType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LocalGatewayRoute = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LocalGatewayRoute(")
        append("destinationCidrBlock=$destinationCidrBlock,")
        append("localGatewayRouteTableArn=$localGatewayRouteTableArn,")
        append("localGatewayRouteTableId=$localGatewayRouteTableId,")
        append("localGatewayVirtualInterfaceGroupId=$localGatewayVirtualInterfaceGroupId,")
        append("ownerId=$ownerId,")
        append("state=$state,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationCidrBlock?.hashCode() ?: 0
        result = 31 * result + (localGatewayRouteTableArn?.hashCode() ?: 0)
        result = 31 * result + (localGatewayRouteTableId?.hashCode() ?: 0)
        result = 31 * result + (localGatewayVirtualInterfaceGroupId?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LocalGatewayRoute

        if (destinationCidrBlock != other.destinationCidrBlock) return false
        if (localGatewayRouteTableArn != other.localGatewayRouteTableArn) return false
        if (localGatewayRouteTableId != other.localGatewayRouteTableId) return false
        if (localGatewayVirtualInterfaceGroupId != other.localGatewayVirtualInterfaceGroupId) return false
        if (ownerId != other.ownerId) return false
        if (state != other.state) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LocalGatewayRoute = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LocalGatewayRoute
        /**
         * The CIDR block used for destination matches.
         */
        fun destinationCidrBlock(destinationCidrBlock: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the local gateway route table.
         */
        fun localGatewayRouteTableArn(localGatewayRouteTableArn: String): FluentBuilder
        /**
         * The ID of the local gateway route table.
         */
        fun localGatewayRouteTableId(localGatewayRouteTableId: String): FluentBuilder
        /**
         * The ID of the virtual interface group.
         */
        fun localGatewayVirtualInterfaceGroupId(localGatewayVirtualInterfaceGroupId: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the local gateway route.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * The state of the route.
         */
        fun state(state: LocalGatewayRouteState): FluentBuilder
        /**
         * The route type.
         */
        fun type(type: LocalGatewayRouteType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The CIDR block used for destination matches.
         */
        var destinationCidrBlock: String?
        /**
         * The Amazon Resource Name (ARN) of the local gateway route table.
         */
        var localGatewayRouteTableArn: String?
        /**
         * The ID of the local gateway route table.
         */
        var localGatewayRouteTableId: String?
        /**
         * The ID of the virtual interface group.
         */
        var localGatewayVirtualInterfaceGroupId: String?
        /**
         * The ID of the Amazon Web Services account that owns the local gateway route.
         */
        var ownerId: String?
        /**
         * The state of the route.
         */
        var state: LocalGatewayRouteState?
        /**
         * The route type.
         */
        var type: LocalGatewayRouteType?

        fun build(): LocalGatewayRoute
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var destinationCidrBlock: String? = null
        override var localGatewayRouteTableArn: String? = null
        override var localGatewayRouteTableId: String? = null
        override var localGatewayVirtualInterfaceGroupId: String? = null
        override var ownerId: String? = null
        override var state: LocalGatewayRouteState? = null
        override var type: LocalGatewayRouteType? = null

        constructor(x: LocalGatewayRoute) : this() {
            this.destinationCidrBlock = x.destinationCidrBlock
            this.localGatewayRouteTableArn = x.localGatewayRouteTableArn
            this.localGatewayRouteTableId = x.localGatewayRouteTableId
            this.localGatewayVirtualInterfaceGroupId = x.localGatewayVirtualInterfaceGroupId
            this.ownerId = x.ownerId
            this.state = x.state
            this.type = x.type
        }

        override fun build(): LocalGatewayRoute = LocalGatewayRoute(this)
        override fun destinationCidrBlock(destinationCidrBlock: String): FluentBuilder = apply { this.destinationCidrBlock = destinationCidrBlock }
        override fun localGatewayRouteTableArn(localGatewayRouteTableArn: String): FluentBuilder = apply { this.localGatewayRouteTableArn = localGatewayRouteTableArn }
        override fun localGatewayRouteTableId(localGatewayRouteTableId: String): FluentBuilder = apply { this.localGatewayRouteTableId = localGatewayRouteTableId }
        override fun localGatewayVirtualInterfaceGroupId(localGatewayVirtualInterfaceGroupId: String): FluentBuilder = apply { this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun state(state: LocalGatewayRouteState): FluentBuilder = apply { this.state = state }
        override fun type(type: LocalGatewayRouteType): FluentBuilder = apply { this.type = type }
    }
}
