// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an association between a local gateway route table and a virtual interface group.
 */
class LocalGatewayRouteTableVirtualInterfaceGroupAssociation private constructor(builder: BuilderImpl) {
    /**
     * The ID of the local gateway.
     */
    val localGatewayId: String? = builder.localGatewayId
    /**
     * The Amazon Resource Name (ARN) of the local gateway route table for the virtual interface group.
     */
    val localGatewayRouteTableArn: String? = builder.localGatewayRouteTableArn
    /**
     * The ID of the local gateway route table.
     */
    val localGatewayRouteTableId: String? = builder.localGatewayRouteTableId
    /**
     * The ID of the association.
     */
    val localGatewayRouteTableVirtualInterfaceGroupAssociationId: String? = builder.localGatewayRouteTableVirtualInterfaceGroupAssociationId
    /**
     * The ID of the virtual interface group.
     */
    val localGatewayVirtualInterfaceGroupId: String? = builder.localGatewayVirtualInterfaceGroupId
    /**
     * The ID of the Amazon Web Services account that owns the local gateway virtual interface group association.
     */
    val ownerId: String? = builder.ownerId
    /**
     * The state of the association.
     */
    val state: String? = builder.state
    /**
     * The tags assigned to the association.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LocalGatewayRouteTableVirtualInterfaceGroupAssociation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LocalGatewayRouteTableVirtualInterfaceGroupAssociation(")
        append("localGatewayId=$localGatewayId,")
        append("localGatewayRouteTableArn=$localGatewayRouteTableArn,")
        append("localGatewayRouteTableId=$localGatewayRouteTableId,")
        append("localGatewayRouteTableVirtualInterfaceGroupAssociationId=$localGatewayRouteTableVirtualInterfaceGroupAssociationId,")
        append("localGatewayVirtualInterfaceGroupId=$localGatewayVirtualInterfaceGroupId,")
        append("ownerId=$ownerId,")
        append("state=$state,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = localGatewayId?.hashCode() ?: 0
        result = 31 * result + (localGatewayRouteTableArn?.hashCode() ?: 0)
        result = 31 * result + (localGatewayRouteTableId?.hashCode() ?: 0)
        result = 31 * result + (localGatewayRouteTableVirtualInterfaceGroupAssociationId?.hashCode() ?: 0)
        result = 31 * result + (localGatewayVirtualInterfaceGroupId?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LocalGatewayRouteTableVirtualInterfaceGroupAssociation

        if (localGatewayId != other.localGatewayId) return false
        if (localGatewayRouteTableArn != other.localGatewayRouteTableArn) return false
        if (localGatewayRouteTableId != other.localGatewayRouteTableId) return false
        if (localGatewayRouteTableVirtualInterfaceGroupAssociationId != other.localGatewayRouteTableVirtualInterfaceGroupAssociationId) return false
        if (localGatewayVirtualInterfaceGroupId != other.localGatewayVirtualInterfaceGroupId) return false
        if (ownerId != other.ownerId) return false
        if (state != other.state) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LocalGatewayRouteTableVirtualInterfaceGroupAssociation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LocalGatewayRouteTableVirtualInterfaceGroupAssociation
        /**
         * The ID of the local gateway.
         */
        fun localGatewayId(localGatewayId: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the local gateway route table for the virtual interface group.
         */
        fun localGatewayRouteTableArn(localGatewayRouteTableArn: String): FluentBuilder
        /**
         * The ID of the local gateway route table.
         */
        fun localGatewayRouteTableId(localGatewayRouteTableId: String): FluentBuilder
        /**
         * The ID of the association.
         */
        fun localGatewayRouteTableVirtualInterfaceGroupAssociationId(localGatewayRouteTableVirtualInterfaceGroupAssociationId: String): FluentBuilder
        /**
         * The ID of the virtual interface group.
         */
        fun localGatewayVirtualInterfaceGroupId(localGatewayVirtualInterfaceGroupId: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the local gateway virtual interface group association.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * The state of the association.
         */
        fun state(state: String): FluentBuilder
        /**
         * The tags assigned to the association.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the local gateway.
         */
        var localGatewayId: String?
        /**
         * The Amazon Resource Name (ARN) of the local gateway route table for the virtual interface group.
         */
        var localGatewayRouteTableArn: String?
        /**
         * The ID of the local gateway route table.
         */
        var localGatewayRouteTableId: String?
        /**
         * The ID of the association.
         */
        var localGatewayRouteTableVirtualInterfaceGroupAssociationId: String?
        /**
         * The ID of the virtual interface group.
         */
        var localGatewayVirtualInterfaceGroupId: String?
        /**
         * The ID of the Amazon Web Services account that owns the local gateway virtual interface group association.
         */
        var ownerId: String?
        /**
         * The state of the association.
         */
        var state: String?
        /**
         * The tags assigned to the association.
         */
        var tags: List<Tag>?

        fun build(): LocalGatewayRouteTableVirtualInterfaceGroupAssociation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var localGatewayId: String? = null
        override var localGatewayRouteTableArn: String? = null
        override var localGatewayRouteTableId: String? = null
        override var localGatewayRouteTableVirtualInterfaceGroupAssociationId: String? = null
        override var localGatewayVirtualInterfaceGroupId: String? = null
        override var ownerId: String? = null
        override var state: String? = null
        override var tags: List<Tag>? = null

        constructor(x: LocalGatewayRouteTableVirtualInterfaceGroupAssociation) : this() {
            this.localGatewayId = x.localGatewayId
            this.localGatewayRouteTableArn = x.localGatewayRouteTableArn
            this.localGatewayRouteTableId = x.localGatewayRouteTableId
            this.localGatewayRouteTableVirtualInterfaceGroupAssociationId = x.localGatewayRouteTableVirtualInterfaceGroupAssociationId
            this.localGatewayVirtualInterfaceGroupId = x.localGatewayVirtualInterfaceGroupId
            this.ownerId = x.ownerId
            this.state = x.state
            this.tags = x.tags
        }

        override fun build(): LocalGatewayRouteTableVirtualInterfaceGroupAssociation = LocalGatewayRouteTableVirtualInterfaceGroupAssociation(this)
        override fun localGatewayId(localGatewayId: String): FluentBuilder = apply { this.localGatewayId = localGatewayId }
        override fun localGatewayRouteTableArn(localGatewayRouteTableArn: String): FluentBuilder = apply { this.localGatewayRouteTableArn = localGatewayRouteTableArn }
        override fun localGatewayRouteTableId(localGatewayRouteTableId: String): FluentBuilder = apply { this.localGatewayRouteTableId = localGatewayRouteTableId }
        override fun localGatewayRouteTableVirtualInterfaceGroupAssociationId(localGatewayRouteTableVirtualInterfaceGroupAssociationId: String): FluentBuilder = apply { this.localGatewayRouteTableVirtualInterfaceGroupAssociationId = localGatewayRouteTableVirtualInterfaceGroupAssociationId }
        override fun localGatewayVirtualInterfaceGroupId(localGatewayVirtualInterfaceGroupId: String): FluentBuilder = apply { this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun state(state: String): FluentBuilder = apply { this.state = state }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
