// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an association between a local gateway route table and a VPC.
 */
class LocalGatewayRouteTableVpcAssociation private constructor(builder: BuilderImpl) {
    /**
     * The ID of the local gateway.
     */
    val localGatewayId: String? = builder.localGatewayId
    /**
     * The Amazon Resource Name (ARN) of the local gateway route table for the association.
     */
    val localGatewayRouteTableArn: String? = builder.localGatewayRouteTableArn
    /**
     * The ID of the local gateway route table.
     */
    val localGatewayRouteTableId: String? = builder.localGatewayRouteTableId
    /**
     * The ID of the association.
     */
    val localGatewayRouteTableVpcAssociationId: String? = builder.localGatewayRouteTableVpcAssociationId
    /**
     * The ID of the Amazon Web Services account that owns the local gateway route table for the association.
     */
    val ownerId: String? = builder.ownerId
    /**
     * The state of the association.
     */
    val state: String? = builder.state
    /**
     * The tags assigned to the association.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the VPC.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LocalGatewayRouteTableVpcAssociation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LocalGatewayRouteTableVpcAssociation(")
        append("localGatewayId=$localGatewayId,")
        append("localGatewayRouteTableArn=$localGatewayRouteTableArn,")
        append("localGatewayRouteTableId=$localGatewayRouteTableId,")
        append("localGatewayRouteTableVpcAssociationId=$localGatewayRouteTableVpcAssociationId,")
        append("ownerId=$ownerId,")
        append("state=$state,")
        append("tags=$tags,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = localGatewayId?.hashCode() ?: 0
        result = 31 * result + (localGatewayRouteTableArn?.hashCode() ?: 0)
        result = 31 * result + (localGatewayRouteTableId?.hashCode() ?: 0)
        result = 31 * result + (localGatewayRouteTableVpcAssociationId?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LocalGatewayRouteTableVpcAssociation

        if (localGatewayId != other.localGatewayId) return false
        if (localGatewayRouteTableArn != other.localGatewayRouteTableArn) return false
        if (localGatewayRouteTableId != other.localGatewayRouteTableId) return false
        if (localGatewayRouteTableVpcAssociationId != other.localGatewayRouteTableVpcAssociationId) return false
        if (ownerId != other.ownerId) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LocalGatewayRouteTableVpcAssociation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LocalGatewayRouteTableVpcAssociation
        /**
         * The ID of the local gateway.
         */
        fun localGatewayId(localGatewayId: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the local gateway route table for the association.
         */
        fun localGatewayRouteTableArn(localGatewayRouteTableArn: String): FluentBuilder
        /**
         * The ID of the local gateway route table.
         */
        fun localGatewayRouteTableId(localGatewayRouteTableId: String): FluentBuilder
        /**
         * The ID of the association.
         */
        fun localGatewayRouteTableVpcAssociationId(localGatewayRouteTableVpcAssociationId: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the local gateway route table for the association.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * The state of the association.
         */
        fun state(state: String): FluentBuilder
        /**
         * The tags assigned to the association.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The ID of the VPC.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the local gateway.
         */
        var localGatewayId: String?
        /**
         * The Amazon Resource Name (ARN) of the local gateway route table for the association.
         */
        var localGatewayRouteTableArn: String?
        /**
         * The ID of the local gateway route table.
         */
        var localGatewayRouteTableId: String?
        /**
         * The ID of the association.
         */
        var localGatewayRouteTableVpcAssociationId: String?
        /**
         * The ID of the Amazon Web Services account that owns the local gateway route table for the association.
         */
        var ownerId: String?
        /**
         * The state of the association.
         */
        var state: String?
        /**
         * The tags assigned to the association.
         */
        var tags: List<Tag>?
        /**
         * The ID of the VPC.
         */
        var vpcId: String?

        fun build(): LocalGatewayRouteTableVpcAssociation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var localGatewayId: String? = null
        override var localGatewayRouteTableArn: String? = null
        override var localGatewayRouteTableId: String? = null
        override var localGatewayRouteTableVpcAssociationId: String? = null
        override var ownerId: String? = null
        override var state: String? = null
        override var tags: List<Tag>? = null
        override var vpcId: String? = null

        constructor(x: LocalGatewayRouteTableVpcAssociation) : this() {
            this.localGatewayId = x.localGatewayId
            this.localGatewayRouteTableArn = x.localGatewayRouteTableArn
            this.localGatewayRouteTableId = x.localGatewayRouteTableId
            this.localGatewayRouteTableVpcAssociationId = x.localGatewayRouteTableVpcAssociationId
            this.ownerId = x.ownerId
            this.state = x.state
            this.tags = x.tags
            this.vpcId = x.vpcId
        }

        override fun build(): LocalGatewayRouteTableVpcAssociation = LocalGatewayRouteTableVpcAssociation(this)
        override fun localGatewayId(localGatewayId: String): FluentBuilder = apply { this.localGatewayId = localGatewayId }
        override fun localGatewayRouteTableArn(localGatewayRouteTableArn: String): FluentBuilder = apply { this.localGatewayRouteTableArn = localGatewayRouteTableArn }
        override fun localGatewayRouteTableId(localGatewayRouteTableId: String): FluentBuilder = apply { this.localGatewayRouteTableId = localGatewayRouteTableId }
        override fun localGatewayRouteTableVpcAssociationId(localGatewayRouteTableVpcAssociationId: String): FluentBuilder = apply { this.localGatewayRouteTableVpcAssociationId = localGatewayRouteTableVpcAssociationId }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun state(state: String): FluentBuilder = apply { this.state = state }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
