// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a local gateway virtual interface.
 */
class LocalGatewayVirtualInterface private constructor(builder: BuilderImpl) {
    /**
     * The local address.
     */
    val localAddress: String? = builder.localAddress
    /**
     * The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.
     */
    val localBgpAsn: Int? = builder.localBgpAsn
    /**
     * The ID of the local gateway.
     */
    val localGatewayId: String? = builder.localGatewayId
    /**
     * The ID of the virtual interface.
     */
    val localGatewayVirtualInterfaceId: String? = builder.localGatewayVirtualInterfaceId
    /**
     * The ID of the Amazon Web Services account that owns the local gateway virtual interface.
     */
    val ownerId: String? = builder.ownerId
    /**
     * The peer address.
     */
    val peerAddress: String? = builder.peerAddress
    /**
     * The peer BGP ASN.
     */
    val peerBgpAsn: Int? = builder.peerBgpAsn
    /**
     * The tags assigned to the virtual interface.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the VLAN.
     */
    val vlan: Int? = builder.vlan

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LocalGatewayVirtualInterface = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LocalGatewayVirtualInterface(")
        append("localAddress=$localAddress,")
        append("localBgpAsn=$localBgpAsn,")
        append("localGatewayId=$localGatewayId,")
        append("localGatewayVirtualInterfaceId=$localGatewayVirtualInterfaceId,")
        append("ownerId=$ownerId,")
        append("peerAddress=$peerAddress,")
        append("peerBgpAsn=$peerBgpAsn,")
        append("tags=$tags,")
        append("vlan=$vlan)")
    }

    override fun hashCode(): kotlin.Int {
        var result = localAddress?.hashCode() ?: 0
        result = 31 * result + (localBgpAsn ?: 0)
        result = 31 * result + (localGatewayId?.hashCode() ?: 0)
        result = 31 * result + (localGatewayVirtualInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (peerAddress?.hashCode() ?: 0)
        result = 31 * result + (peerBgpAsn ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vlan ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LocalGatewayVirtualInterface

        if (localAddress != other.localAddress) return false
        if (localBgpAsn != other.localBgpAsn) return false
        if (localGatewayId != other.localGatewayId) return false
        if (localGatewayVirtualInterfaceId != other.localGatewayVirtualInterfaceId) return false
        if (ownerId != other.ownerId) return false
        if (peerAddress != other.peerAddress) return false
        if (peerBgpAsn != other.peerBgpAsn) return false
        if (tags != other.tags) return false
        if (vlan != other.vlan) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LocalGatewayVirtualInterface = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LocalGatewayVirtualInterface
        /**
         * The local address.
         */
        fun localAddress(localAddress: String): FluentBuilder
        /**
         * The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.
         */
        fun localBgpAsn(localBgpAsn: Int): FluentBuilder
        /**
         * The ID of the local gateway.
         */
        fun localGatewayId(localGatewayId: String): FluentBuilder
        /**
         * The ID of the virtual interface.
         */
        fun localGatewayVirtualInterfaceId(localGatewayVirtualInterfaceId: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the local gateway virtual interface.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * The peer address.
         */
        fun peerAddress(peerAddress: String): FluentBuilder
        /**
         * The peer BGP ASN.
         */
        fun peerBgpAsn(peerBgpAsn: Int): FluentBuilder
        /**
         * The tags assigned to the virtual interface.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The ID of the VLAN.
         */
        fun vlan(vlan: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The local address.
         */
        var localAddress: String?
        /**
         * The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.
         */
        var localBgpAsn: Int?
        /**
         * The ID of the local gateway.
         */
        var localGatewayId: String?
        /**
         * The ID of the virtual interface.
         */
        var localGatewayVirtualInterfaceId: String?
        /**
         * The ID of the Amazon Web Services account that owns the local gateway virtual interface.
         */
        var ownerId: String?
        /**
         * The peer address.
         */
        var peerAddress: String?
        /**
         * The peer BGP ASN.
         */
        var peerBgpAsn: Int?
        /**
         * The tags assigned to the virtual interface.
         */
        var tags: List<Tag>?
        /**
         * The ID of the VLAN.
         */
        var vlan: Int?

        fun build(): LocalGatewayVirtualInterface
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var localAddress: String? = null
        override var localBgpAsn: Int? = null
        override var localGatewayId: String? = null
        override var localGatewayVirtualInterfaceId: String? = null
        override var ownerId: String? = null
        override var peerAddress: String? = null
        override var peerBgpAsn: Int? = null
        override var tags: List<Tag>? = null
        override var vlan: Int? = null

        constructor(x: LocalGatewayVirtualInterface) : this() {
            this.localAddress = x.localAddress
            this.localBgpAsn = x.localBgpAsn
            this.localGatewayId = x.localGatewayId
            this.localGatewayVirtualInterfaceId = x.localGatewayVirtualInterfaceId
            this.ownerId = x.ownerId
            this.peerAddress = x.peerAddress
            this.peerBgpAsn = x.peerBgpAsn
            this.tags = x.tags
            this.vlan = x.vlan
        }

        override fun build(): LocalGatewayVirtualInterface = LocalGatewayVirtualInterface(this)
        override fun localAddress(localAddress: String): FluentBuilder = apply { this.localAddress = localAddress }
        override fun localBgpAsn(localBgpAsn: Int): FluentBuilder = apply { this.localBgpAsn = localBgpAsn }
        override fun localGatewayId(localGatewayId: String): FluentBuilder = apply { this.localGatewayId = localGatewayId }
        override fun localGatewayVirtualInterfaceId(localGatewayVirtualInterfaceId: String): FluentBuilder = apply { this.localGatewayVirtualInterfaceId = localGatewayVirtualInterfaceId }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun peerAddress(peerAddress: String): FluentBuilder = apply { this.peerAddress = peerAddress }
        override fun peerBgpAsn(peerBgpAsn: Int): FluentBuilder = apply { this.peerBgpAsn = peerBgpAsn }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun vlan(vlan: Int): FluentBuilder = apply { this.vlan = vlan }
    }
}
