// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a managed prefix list.
 */
class ManagedPrefixList private constructor(builder: BuilderImpl) {
    /**
     * The IP address version.
     */
    val addressFamily: String? = builder.addressFamily
    /**
     * The maximum number of entries for the prefix list.
     */
    val maxEntries: Int? = builder.maxEntries
    /**
     * The ID of the owner of the prefix list.
     */
    val ownerId: String? = builder.ownerId
    /**
     * The Amazon Resource Name (ARN) for the prefix list.
     */
    val prefixListArn: String? = builder.prefixListArn
    /**
     * The ID of the prefix list.
     */
    val prefixListId: String? = builder.prefixListId
    /**
     * The name of the prefix list.
     */
    val prefixListName: String? = builder.prefixListName
    /**
     * The current state of the prefix list.
     */
    val state: PrefixListState? = builder.state
    /**
     * The state message.
     */
    val stateMessage: String? = builder.stateMessage
    /**
     * The tags for the prefix list.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The version of the prefix list.
     */
    val version: Long? = builder.version

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ManagedPrefixList = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ManagedPrefixList(")
        append("addressFamily=$addressFamily,")
        append("maxEntries=$maxEntries,")
        append("ownerId=$ownerId,")
        append("prefixListArn=$prefixListArn,")
        append("prefixListId=$prefixListId,")
        append("prefixListName=$prefixListName,")
        append("state=$state,")
        append("stateMessage=$stateMessage,")
        append("tags=$tags,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressFamily?.hashCode() ?: 0
        result = 31 * result + (maxEntries ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (prefixListArn?.hashCode() ?: 0)
        result = 31 * result + (prefixListId?.hashCode() ?: 0)
        result = 31 * result + (prefixListName?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateMessage?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ManagedPrefixList

        if (addressFamily != other.addressFamily) return false
        if (maxEntries != other.maxEntries) return false
        if (ownerId != other.ownerId) return false
        if (prefixListArn != other.prefixListArn) return false
        if (prefixListId != other.prefixListId) return false
        if (prefixListName != other.prefixListName) return false
        if (state != other.state) return false
        if (stateMessage != other.stateMessage) return false
        if (tags != other.tags) return false
        if (version != other.version) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ManagedPrefixList = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ManagedPrefixList
        /**
         * The IP address version.
         */
        fun addressFamily(addressFamily: String): FluentBuilder
        /**
         * The maximum number of entries for the prefix list.
         */
        fun maxEntries(maxEntries: Int): FluentBuilder
        /**
         * The ID of the owner of the prefix list.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) for the prefix list.
         */
        fun prefixListArn(prefixListArn: String): FluentBuilder
        /**
         * The ID of the prefix list.
         */
        fun prefixListId(prefixListId: String): FluentBuilder
        /**
         * The name of the prefix list.
         */
        fun prefixListName(prefixListName: String): FluentBuilder
        /**
         * The current state of the prefix list.
         */
        fun state(state: PrefixListState): FluentBuilder
        /**
         * The state message.
         */
        fun stateMessage(stateMessage: String): FluentBuilder
        /**
         * The tags for the prefix list.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The version of the prefix list.
         */
        fun version(version: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The IP address version.
         */
        var addressFamily: String?
        /**
         * The maximum number of entries for the prefix list.
         */
        var maxEntries: Int?
        /**
         * The ID of the owner of the prefix list.
         */
        var ownerId: String?
        /**
         * The Amazon Resource Name (ARN) for the prefix list.
         */
        var prefixListArn: String?
        /**
         * The ID of the prefix list.
         */
        var prefixListId: String?
        /**
         * The name of the prefix list.
         */
        var prefixListName: String?
        /**
         * The current state of the prefix list.
         */
        var state: PrefixListState?
        /**
         * The state message.
         */
        var stateMessage: String?
        /**
         * The tags for the prefix list.
         */
        var tags: List<Tag>?
        /**
         * The version of the prefix list.
         */
        var version: Long?

        fun build(): ManagedPrefixList
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var addressFamily: String? = null
        override var maxEntries: Int? = null
        override var ownerId: String? = null
        override var prefixListArn: String? = null
        override var prefixListId: String? = null
        override var prefixListName: String? = null
        override var state: PrefixListState? = null
        override var stateMessage: String? = null
        override var tags: List<Tag>? = null
        override var version: Long? = null

        constructor(x: ManagedPrefixList) : this() {
            this.addressFamily = x.addressFamily
            this.maxEntries = x.maxEntries
            this.ownerId = x.ownerId
            this.prefixListArn = x.prefixListArn
            this.prefixListId = x.prefixListId
            this.prefixListName = x.prefixListName
            this.state = x.state
            this.stateMessage = x.stateMessage
            this.tags = x.tags
            this.version = x.version
        }

        override fun build(): ManagedPrefixList = ManagedPrefixList(this)
        override fun addressFamily(addressFamily: String): FluentBuilder = apply { this.addressFamily = addressFamily }
        override fun maxEntries(maxEntries: Int): FluentBuilder = apply { this.maxEntries = maxEntries }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun prefixListArn(prefixListArn: String): FluentBuilder = apply { this.prefixListArn = prefixListArn }
        override fun prefixListId(prefixListId: String): FluentBuilder = apply { this.prefixListId = prefixListId }
        override fun prefixListName(prefixListName: String): FluentBuilder = apply { this.prefixListName = prefixListName }
        override fun state(state: PrefixListState): FluentBuilder = apply { this.state = state }
        override fun stateMessage(stateMessage: String): FluentBuilder = apply { this.stateMessage = stateMessage }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun version(version: Long): FluentBuilder = apply { this.version = version }
    }
}
