// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

class ModifyCapacityReservationFleetRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID of the Capacity Reservation Fleet to modify.
     */
    val capacityReservationFleetId: String? = builder.capacityReservationFleetId
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The date and time at which the Capacity Reservation Fleet expires. When the Capacity Reservation
     * Fleet expires, its state changes to expired and all of the Capacity Reservations in the
     * Fleet expire.
     * The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you
     * specify 5/31/2019, 13:30:55, the Capacity Reservation Fleet is guaranteed
     * to expire between 13:30:55 and 14:30:55 on 5/31/2019.
     * You can't specify EndDate and
     * RemoveEndDate in the same request.
     */
    val endDate: Instant? = builder.endDate
    /**
     * Indicates whether to remove the end date from the Capacity Reservation Fleet. If you remove the
     * end date, the Capacity Reservation Fleet does not expire and it remains active until you explicitly
     * cancel it using the CancelCapacityReservationFleet action.
     * You can't specify RemoveEndDate and
     * EndDate in the same request.
     */
    val removeEndDate: Boolean? = builder.removeEndDate
    /**
     * The total number of capacity units to be reserved by the Capacity Reservation Fleet. This value,
     * together with the instance type weights that you assign to each instance type used by the Fleet
     * determine the number of instances for which the Fleet reserves capacity. Both values are based on
     * units that make sense for your workload. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target capacity
     * in the Amazon EC2 User Guide.
     */
    val totalTargetCapacity: Int? = builder.totalTargetCapacity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifyCapacityReservationFleetRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyCapacityReservationFleetRequest(")
        append("capacityReservationFleetId=$capacityReservationFleetId,")
        append("dryRun=$dryRun,")
        append("endDate=$endDate,")
        append("removeEndDate=$removeEndDate,")
        append("totalTargetCapacity=$totalTargetCapacity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityReservationFleetId?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (endDate?.hashCode() ?: 0)
        result = 31 * result + (removeEndDate?.hashCode() ?: 0)
        result = 31 * result + (totalTargetCapacity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifyCapacityReservationFleetRequest

        if (capacityReservationFleetId != other.capacityReservationFleetId) return false
        if (dryRun != other.dryRun) return false
        if (endDate != other.endDate) return false
        if (removeEndDate != other.removeEndDate) return false
        if (totalTargetCapacity != other.totalTargetCapacity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifyCapacityReservationFleetRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifyCapacityReservationFleetRequest
        /**
         * The ID of the Capacity Reservation Fleet to modify.
         */
        fun capacityReservationFleetId(capacityReservationFleetId: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The date and time at which the Capacity Reservation Fleet expires. When the Capacity Reservation
         * Fleet expires, its state changes to expired and all of the Capacity Reservations in the
         * Fleet expire.
         * The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you
         * specify 5/31/2019, 13:30:55, the Capacity Reservation Fleet is guaranteed
         * to expire between 13:30:55 and 14:30:55 on 5/31/2019.
         * You can't specify EndDate and
         * RemoveEndDate in the same request.
         */
        fun endDate(endDate: Instant): FluentBuilder
        /**
         * Indicates whether to remove the end date from the Capacity Reservation Fleet. If you remove the
         * end date, the Capacity Reservation Fleet does not expire and it remains active until you explicitly
         * cancel it using the CancelCapacityReservationFleet action.
         * You can't specify RemoveEndDate and
         * EndDate in the same request.
         */
        fun removeEndDate(removeEndDate: Boolean): FluentBuilder
        /**
         * The total number of capacity units to be reserved by the Capacity Reservation Fleet. This value,
         * together with the instance type weights that you assign to each instance type used by the Fleet
         * determine the number of instances for which the Fleet reserves capacity. Both values are based on
         * units that make sense for your workload. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target capacity
         * in the Amazon EC2 User Guide.
         */
        fun totalTargetCapacity(totalTargetCapacity: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the Capacity Reservation Fleet to modify.
         */
        var capacityReservationFleetId: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The date and time at which the Capacity Reservation Fleet expires. When the Capacity Reservation
         * Fleet expires, its state changes to expired and all of the Capacity Reservations in the
         * Fleet expire.
         * The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you
         * specify 5/31/2019, 13:30:55, the Capacity Reservation Fleet is guaranteed
         * to expire between 13:30:55 and 14:30:55 on 5/31/2019.
         * You can't specify EndDate and
         * RemoveEndDate in the same request.
         */
        var endDate: Instant?
        /**
         * Indicates whether to remove the end date from the Capacity Reservation Fleet. If you remove the
         * end date, the Capacity Reservation Fleet does not expire and it remains active until you explicitly
         * cancel it using the CancelCapacityReservationFleet action.
         * You can't specify RemoveEndDate and
         * EndDate in the same request.
         */
        var removeEndDate: Boolean?
        /**
         * The total number of capacity units to be reserved by the Capacity Reservation Fleet. This value,
         * together with the instance type weights that you assign to each instance type used by the Fleet
         * determine the number of instances for which the Fleet reserves capacity. Both values are based on
         * units that make sense for your workload. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target capacity
         * in the Amazon EC2 User Guide.
         */
        var totalTargetCapacity: Int?

        fun build(): ModifyCapacityReservationFleetRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var capacityReservationFleetId: String? = null
        override var dryRun: Boolean? = null
        override var endDate: Instant? = null
        override var removeEndDate: Boolean? = null
        override var totalTargetCapacity: Int? = null

        constructor(x: ModifyCapacityReservationFleetRequest) : this() {
            this.capacityReservationFleetId = x.capacityReservationFleetId
            this.dryRun = x.dryRun
            this.endDate = x.endDate
            this.removeEndDate = x.removeEndDate
            this.totalTargetCapacity = x.totalTargetCapacity
        }

        override fun build(): ModifyCapacityReservationFleetRequest = ModifyCapacityReservationFleetRequest(this)
        override fun capacityReservationFleetId(capacityReservationFleetId: String): FluentBuilder = apply { this.capacityReservationFleetId = capacityReservationFleetId }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun endDate(endDate: Instant): FluentBuilder = apply { this.endDate = endDate }
        override fun removeEndDate(removeEndDate: Boolean): FluentBuilder = apply { this.removeEndDate = removeEndDate }
        override fun totalTargetCapacity(totalTargetCapacity: Int): FluentBuilder = apply { this.totalTargetCapacity = totalTargetCapacity }
    }
}
