// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

class ModifyCapacityReservationRequest private constructor(builder: BuilderImpl) {
    /**
     * Reserved. Capacity Reservations you have created are accepted by default.
     */
    val accept: Boolean? = builder.accept
    /**
     * The ID of the Capacity Reservation.
     */
    val capacityReservationId: String? = builder.capacityReservationId
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity
     * is released and you can no longer launch instances into it. The Capacity Reservation's state changes to
     * expired when it reaches its end date and time.
     * The Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify
     * 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
     * You must provide an EndDate value if EndDateType is
     * limited. Omit EndDate if EndDateType is
     * unlimited.
     */
    val endDate: Instant? = builder.endDate
    /**
     * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end
     * types:
     * unlimited - The Capacity Reservation remains active until you explicitly cancel it. Do not
     * provide an EndDate value if EndDateType is
     * unlimited.
     * limited - The Capacity Reservation expires automatically at a specified date and time. You must
     * provide an EndDate value if EndDateType is
     * limited.
     */
    val endDateType: EndDateType? = builder.endDateType
    /**
     * The number of instances for which to reserve capacity. The number of instances can't be increased or
     * decreased by more than 1000 in a single request.
     */
    val instanceCount: Int? = builder.instanceCount

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifyCapacityReservationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyCapacityReservationRequest(")
        append("accept=$accept,")
        append("capacityReservationId=$capacityReservationId,")
        append("dryRun=$dryRun,")
        append("endDate=$endDate,")
        append("endDateType=$endDateType,")
        append("instanceCount=$instanceCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accept?.hashCode() ?: 0
        result = 31 * result + (capacityReservationId?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (endDate?.hashCode() ?: 0)
        result = 31 * result + (endDateType?.hashCode() ?: 0)
        result = 31 * result + (instanceCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifyCapacityReservationRequest

        if (accept != other.accept) return false
        if (capacityReservationId != other.capacityReservationId) return false
        if (dryRun != other.dryRun) return false
        if (endDate != other.endDate) return false
        if (endDateType != other.endDateType) return false
        if (instanceCount != other.instanceCount) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifyCapacityReservationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifyCapacityReservationRequest
        /**
         * Reserved. Capacity Reservations you have created are accepted by default.
         */
        fun accept(accept: Boolean): FluentBuilder
        /**
         * The ID of the Capacity Reservation.
         */
        fun capacityReservationId(capacityReservationId: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity
         * is released and you can no longer launch instances into it. The Capacity Reservation's state changes to
         * expired when it reaches its end date and time.
         * The Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify
         * 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
         * You must provide an EndDate value if EndDateType is
         * limited. Omit EndDate if EndDateType is
         * unlimited.
         */
        fun endDate(endDate: Instant): FluentBuilder
        /**
         * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end
         * types:
         * unlimited - The Capacity Reservation remains active until you explicitly cancel it. Do not
         * provide an EndDate value if EndDateType is
         * unlimited.
         * limited - The Capacity Reservation expires automatically at a specified date and time. You must
         * provide an EndDate value if EndDateType is
         * limited.
         */
        fun endDateType(endDateType: EndDateType): FluentBuilder
        /**
         * The number of instances for which to reserve capacity. The number of instances can't be increased or
         * decreased by more than 1000 in a single request.
         */
        fun instanceCount(instanceCount: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Reserved. Capacity Reservations you have created are accepted by default.
         */
        var accept: Boolean?
        /**
         * The ID of the Capacity Reservation.
         */
        var capacityReservationId: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity
         * is released and you can no longer launch instances into it. The Capacity Reservation's state changes to
         * expired when it reaches its end date and time.
         * The Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify
         * 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
         * You must provide an EndDate value if EndDateType is
         * limited. Omit EndDate if EndDateType is
         * unlimited.
         */
        var endDate: Instant?
        /**
         * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end
         * types:
         * unlimited - The Capacity Reservation remains active until you explicitly cancel it. Do not
         * provide an EndDate value if EndDateType is
         * unlimited.
         * limited - The Capacity Reservation expires automatically at a specified date and time. You must
         * provide an EndDate value if EndDateType is
         * limited.
         */
        var endDateType: EndDateType?
        /**
         * The number of instances for which to reserve capacity. The number of instances can't be increased or
         * decreased by more than 1000 in a single request.
         */
        var instanceCount: Int?

        fun build(): ModifyCapacityReservationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accept: Boolean? = null
        override var capacityReservationId: String? = null
        override var dryRun: Boolean? = null
        override var endDate: Instant? = null
        override var endDateType: EndDateType? = null
        override var instanceCount: Int? = null

        constructor(x: ModifyCapacityReservationRequest) : this() {
            this.accept = x.accept
            this.capacityReservationId = x.capacityReservationId
            this.dryRun = x.dryRun
            this.endDate = x.endDate
            this.endDateType = x.endDateType
            this.instanceCount = x.instanceCount
        }

        override fun build(): ModifyCapacityReservationRequest = ModifyCapacityReservationRequest(this)
        override fun accept(accept: Boolean): FluentBuilder = apply { this.accept = accept }
        override fun capacityReservationId(capacityReservationId: String): FluentBuilder = apply { this.capacityReservationId = capacityReservationId }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun endDate(endDate: Instant): FluentBuilder = apply { this.endDate = endDate }
        override fun endDateType(endDateType: EndDateType): FluentBuilder = apply { this.endDateType = endDateType }
        override fun instanceCount(instanceCount: Int): FluentBuilder = apply { this.instanceCount = instanceCount }
    }
}
