// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class ModifyClientVpnEndpointRequest private constructor(builder: BuilderImpl) {
    /**
     * The options for managing connection authorization for new client connections.
     */
    val clientConnectOptions: ClientConnectOptions? = builder.clientConnectOptions
    /**
     * The ID of the Client VPN endpoint to modify.
     */
    val clientVpnEndpointId: String? = builder.clientVpnEndpointId
    /**
     * Information about the client connection logging options.
     * If you enable client connection logging, data about client connections is sent to a
     * Cloudwatch Logs log stream. The following information is logged:
     * Client connection requests
     * Client connection results (successful and unsuccessful)
     * Reasons for unsuccessful client connection requests
     * Client connection termination time
     */
    val connectionLogOptions: ConnectionLogOptions? = builder.connectionLogOptions
    /**
     * A brief description of the Client VPN endpoint.
     */
    val description: String? = builder.description
    /**
     * Information about the DNS servers to be used by Client VPN connections. A Client VPN endpoint can have
     * up to two DNS servers.
     */
    val dnsServers: DnsServersOptionsModifyStructure? = builder.dnsServers
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The IDs of one or more security groups to apply to the target network.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * Specify whether to enable the self-service portal for the Client VPN endpoint.
     */
    val selfServicePortal: SelfServicePortal? = builder.selfServicePortal
    /**
     * The ARN of the server certificate to be used. The server certificate must be provisioned in
     * Certificate Manager (ACM).
     */
    val serverCertificateArn: String? = builder.serverCertificateArn
    /**
     * Indicates whether the VPN is split-tunnel.
     * For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client VPN endpoint in the
     * Client VPN Administrator Guide.
     */
    val splitTunnel: Boolean? = builder.splitTunnel
    /**
     * The ID of the VPC to associate with the Client VPN endpoint.
     */
    val vpcId: String? = builder.vpcId
    /**
     * The port number to assign to the Client VPN endpoint for TCP and UDP traffic.
     * Valid Values: 443 | 1194
     * Default Value: 443
     */
    val vpnPort: Int? = builder.vpnPort

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifyClientVpnEndpointRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyClientVpnEndpointRequest(")
        append("clientConnectOptions=$clientConnectOptions,")
        append("clientVpnEndpointId=$clientVpnEndpointId,")
        append("connectionLogOptions=$connectionLogOptions,")
        append("description=$description,")
        append("dnsServers=$dnsServers,")
        append("dryRun=$dryRun,")
        append("securityGroupIds=$securityGroupIds,")
        append("selfServicePortal=$selfServicePortal,")
        append("serverCertificateArn=$serverCertificateArn,")
        append("splitTunnel=$splitTunnel,")
        append("vpcId=$vpcId,")
        append("vpnPort=$vpnPort)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientConnectOptions?.hashCode() ?: 0
        result = 31 * result + (clientVpnEndpointId?.hashCode() ?: 0)
        result = 31 * result + (connectionLogOptions?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dnsServers?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (selfServicePortal?.hashCode() ?: 0)
        result = 31 * result + (serverCertificateArn?.hashCode() ?: 0)
        result = 31 * result + (splitTunnel?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        result = 31 * result + (vpnPort ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifyClientVpnEndpointRequest

        if (clientConnectOptions != other.clientConnectOptions) return false
        if (clientVpnEndpointId != other.clientVpnEndpointId) return false
        if (connectionLogOptions != other.connectionLogOptions) return false
        if (description != other.description) return false
        if (dnsServers != other.dnsServers) return false
        if (dryRun != other.dryRun) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (selfServicePortal != other.selfServicePortal) return false
        if (serverCertificateArn != other.serverCertificateArn) return false
        if (splitTunnel != other.splitTunnel) return false
        if (vpcId != other.vpcId) return false
        if (vpnPort != other.vpnPort) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifyClientVpnEndpointRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifyClientVpnEndpointRequest
        /**
         * The options for managing connection authorization for new client connections.
         */
        fun clientConnectOptions(clientConnectOptions: ClientConnectOptions): FluentBuilder
        /**
         * The ID of the Client VPN endpoint to modify.
         */
        fun clientVpnEndpointId(clientVpnEndpointId: String): FluentBuilder
        /**
         * Information about the client connection logging options.
         * If you enable client connection logging, data about client connections is sent to a
         * Cloudwatch Logs log stream. The following information is logged:
         * Client connection requests
         * Client connection results (successful and unsuccessful)
         * Reasons for unsuccessful client connection requests
         * Client connection termination time
         */
        fun connectionLogOptions(connectionLogOptions: ConnectionLogOptions): FluentBuilder
        /**
         * A brief description of the Client VPN endpoint.
         */
        fun description(description: String): FluentBuilder
        /**
         * Information about the DNS servers to be used by Client VPN connections. A Client VPN endpoint can have
         * up to two DNS servers.
         */
        fun dnsServers(dnsServers: DnsServersOptionsModifyStructure): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The IDs of one or more security groups to apply to the target network.
         */
        fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder
        /**
         * Specify whether to enable the self-service portal for the Client VPN endpoint.
         */
        fun selfServicePortal(selfServicePortal: SelfServicePortal): FluentBuilder
        /**
         * The ARN of the server certificate to be used. The server certificate must be provisioned in
         * Certificate Manager (ACM).
         */
        fun serverCertificateArn(serverCertificateArn: String): FluentBuilder
        /**
         * Indicates whether the VPN is split-tunnel.
         * For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client VPN endpoint in the
         * Client VPN Administrator Guide.
         */
        fun splitTunnel(splitTunnel: Boolean): FluentBuilder
        /**
         * The ID of the VPC to associate with the Client VPN endpoint.
         */
        fun vpcId(vpcId: String): FluentBuilder
        /**
         * The port number to assign to the Client VPN endpoint for TCP and UDP traffic.
         * Valid Values: 443 | 1194
         * Default Value: 443
         */
        fun vpnPort(vpnPort: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The options for managing connection authorization for new client connections.
         */
        var clientConnectOptions: ClientConnectOptions?
        /**
         * The ID of the Client VPN endpoint to modify.
         */
        var clientVpnEndpointId: String?
        /**
         * Information about the client connection logging options.
         * If you enable client connection logging, data about client connections is sent to a
         * Cloudwatch Logs log stream. The following information is logged:
         * Client connection requests
         * Client connection results (successful and unsuccessful)
         * Reasons for unsuccessful client connection requests
         * Client connection termination time
         */
        var connectionLogOptions: ConnectionLogOptions?
        /**
         * A brief description of the Client VPN endpoint.
         */
        var description: String?
        /**
         * Information about the DNS servers to be used by Client VPN connections. A Client VPN endpoint can have
         * up to two DNS servers.
         */
        var dnsServers: DnsServersOptionsModifyStructure?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The IDs of one or more security groups to apply to the target network.
         */
        var securityGroupIds: List<String>?
        /**
         * Specify whether to enable the self-service portal for the Client VPN endpoint.
         */
        var selfServicePortal: SelfServicePortal?
        /**
         * The ARN of the server certificate to be used. The server certificate must be provisioned in
         * Certificate Manager (ACM).
         */
        var serverCertificateArn: String?
        /**
         * Indicates whether the VPN is split-tunnel.
         * For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client VPN endpoint in the
         * Client VPN Administrator Guide.
         */
        var splitTunnel: Boolean?
        /**
         * The ID of the VPC to associate with the Client VPN endpoint.
         */
        var vpcId: String?
        /**
         * The port number to assign to the Client VPN endpoint for TCP and UDP traffic.
         * Valid Values: 443 | 1194
         * Default Value: 443
         */
        var vpnPort: Int?

        fun build(): ModifyClientVpnEndpointRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ClientConnectOptions] inside the given [block]
         */
        fun clientConnectOptions(block: ClientConnectOptions.DslBuilder.() -> kotlin.Unit) {
            this.clientConnectOptions = ClientConnectOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ConnectionLogOptions] inside the given [block]
         */
        fun connectionLogOptions(block: ConnectionLogOptions.DslBuilder.() -> kotlin.Unit) {
            this.connectionLogOptions = ConnectionLogOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.DnsServersOptionsModifyStructure] inside the given [block]
         */
        fun dnsServers(block: DnsServersOptionsModifyStructure.DslBuilder.() -> kotlin.Unit) {
            this.dnsServers = DnsServersOptionsModifyStructure.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientConnectOptions: ClientConnectOptions? = null
        override var clientVpnEndpointId: String? = null
        override var connectionLogOptions: ConnectionLogOptions? = null
        override var description: String? = null
        override var dnsServers: DnsServersOptionsModifyStructure? = null
        override var dryRun: Boolean? = null
        override var securityGroupIds: List<String>? = null
        override var selfServicePortal: SelfServicePortal? = null
        override var serverCertificateArn: String? = null
        override var splitTunnel: Boolean? = null
        override var vpcId: String? = null
        override var vpnPort: Int? = null

        constructor(x: ModifyClientVpnEndpointRequest) : this() {
            this.clientConnectOptions = x.clientConnectOptions
            this.clientVpnEndpointId = x.clientVpnEndpointId
            this.connectionLogOptions = x.connectionLogOptions
            this.description = x.description
            this.dnsServers = x.dnsServers
            this.dryRun = x.dryRun
            this.securityGroupIds = x.securityGroupIds
            this.selfServicePortal = x.selfServicePortal
            this.serverCertificateArn = x.serverCertificateArn
            this.splitTunnel = x.splitTunnel
            this.vpcId = x.vpcId
            this.vpnPort = x.vpnPort
        }

        override fun build(): ModifyClientVpnEndpointRequest = ModifyClientVpnEndpointRequest(this)
        override fun clientConnectOptions(clientConnectOptions: ClientConnectOptions): FluentBuilder = apply { this.clientConnectOptions = clientConnectOptions }
        override fun clientVpnEndpointId(clientVpnEndpointId: String): FluentBuilder = apply { this.clientVpnEndpointId = clientVpnEndpointId }
        override fun connectionLogOptions(connectionLogOptions: ConnectionLogOptions): FluentBuilder = apply { this.connectionLogOptions = connectionLogOptions }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun dnsServers(dnsServers: DnsServersOptionsModifyStructure): FluentBuilder = apply { this.dnsServers = dnsServers }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder = apply { this.securityGroupIds = securityGroupIds }
        override fun selfServicePortal(selfServicePortal: SelfServicePortal): FluentBuilder = apply { this.selfServicePortal = selfServicePortal }
        override fun serverCertificateArn(serverCertificateArn: String): FluentBuilder = apply { this.serverCertificateArn = serverCertificateArn }
        override fun splitTunnel(splitTunnel: Boolean): FluentBuilder = apply { this.splitTunnel = splitTunnel }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
        override fun vpnPort(vpnPort: Int): FluentBuilder = apply { this.vpnPort = vpnPort }
    }
}
