// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class ModifyHostsRequest private constructor(builder: BuilderImpl) {
    /**
     * Specify whether to enable or disable auto-placement.
     */
    val autoPlacement: AutoPlacement? = builder.autoPlacement
    /**
     * The IDs of the Dedicated Hosts to modify.
     */
    val hostIds: List<String>? = builder.hostIds
    /**
     * Indicates whether to enable or disable host recovery for the Dedicated Host. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html">
     * Host recovery in the Amazon EC2 User Guide.
     */
    val hostRecovery: HostRecovery? = builder.hostRecovery
    /**
     * Specifies the instance family to be supported by the Dedicated Host. Specify this parameter
     * to modify a Dedicated Host to support multiple instance types within its current
     * instance family.
     * If you want to modify a Dedicated Host to support a specific instance type only, omit this parameter
     * and specify InstanceType instead. You cannot specify
     * InstanceFamily and InstanceType
     * in the same request.
     */
    val instanceFamily: String? = builder.instanceFamily
    /**
     * Specifies the instance type to be supported by the Dedicated Host. Specify this parameter to
     * modify a Dedicated Host to support only a specific instance type.
     * If you want to modify a Dedicated Host to support multiple instance types in its current instance
     * family, omit this parameter and specify InstanceFamily
     * instead. You cannot specify InstanceType and
     * InstanceFamily in the same request.
     */
    val instanceType: String? = builder.instanceType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifyHostsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyHostsRequest(")
        append("autoPlacement=$autoPlacement,")
        append("hostIds=$hostIds,")
        append("hostRecovery=$hostRecovery,")
        append("instanceFamily=$instanceFamily,")
        append("instanceType=$instanceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoPlacement?.hashCode() ?: 0
        result = 31 * result + (hostIds?.hashCode() ?: 0)
        result = 31 * result + (hostRecovery?.hashCode() ?: 0)
        result = 31 * result + (instanceFamily?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifyHostsRequest

        if (autoPlacement != other.autoPlacement) return false
        if (hostIds != other.hostIds) return false
        if (hostRecovery != other.hostRecovery) return false
        if (instanceFamily != other.instanceFamily) return false
        if (instanceType != other.instanceType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifyHostsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifyHostsRequest
        /**
         * Specify whether to enable or disable auto-placement.
         */
        fun autoPlacement(autoPlacement: AutoPlacement): FluentBuilder
        /**
         * The IDs of the Dedicated Hosts to modify.
         */
        fun hostIds(hostIds: List<String>): FluentBuilder
        /**
         * Indicates whether to enable or disable host recovery for the Dedicated Host. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html">
         * Host recovery in the Amazon EC2 User Guide.
         */
        fun hostRecovery(hostRecovery: HostRecovery): FluentBuilder
        /**
         * Specifies the instance family to be supported by the Dedicated Host. Specify this parameter
         * to modify a Dedicated Host to support multiple instance types within its current
         * instance family.
         * If you want to modify a Dedicated Host to support a specific instance type only, omit this parameter
         * and specify InstanceType instead. You cannot specify
         * InstanceFamily and InstanceType
         * in the same request.
         */
        fun instanceFamily(instanceFamily: String): FluentBuilder
        /**
         * Specifies the instance type to be supported by the Dedicated Host. Specify this parameter to
         * modify a Dedicated Host to support only a specific instance type.
         * If you want to modify a Dedicated Host to support multiple instance types in its current instance
         * family, omit this parameter and specify InstanceFamily
         * instead. You cannot specify InstanceType and
         * InstanceFamily in the same request.
         */
        fun instanceType(instanceType: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specify whether to enable or disable auto-placement.
         */
        var autoPlacement: AutoPlacement?
        /**
         * The IDs of the Dedicated Hosts to modify.
         */
        var hostIds: List<String>?
        /**
         * Indicates whether to enable or disable host recovery for the Dedicated Host. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html">
         * Host recovery in the Amazon EC2 User Guide.
         */
        var hostRecovery: HostRecovery?
        /**
         * Specifies the instance family to be supported by the Dedicated Host. Specify this parameter
         * to modify a Dedicated Host to support multiple instance types within its current
         * instance family.
         * If you want to modify a Dedicated Host to support a specific instance type only, omit this parameter
         * and specify InstanceType instead. You cannot specify
         * InstanceFamily and InstanceType
         * in the same request.
         */
        var instanceFamily: String?
        /**
         * Specifies the instance type to be supported by the Dedicated Host. Specify this parameter to
         * modify a Dedicated Host to support only a specific instance type.
         * If you want to modify a Dedicated Host to support multiple instance types in its current instance
         * family, omit this parameter and specify InstanceFamily
         * instead. You cannot specify InstanceType and
         * InstanceFamily in the same request.
         */
        var instanceType: String?

        fun build(): ModifyHostsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var autoPlacement: AutoPlacement? = null
        override var hostIds: List<String>? = null
        override var hostRecovery: HostRecovery? = null
        override var instanceFamily: String? = null
        override var instanceType: String? = null

        constructor(x: ModifyHostsRequest) : this() {
            this.autoPlacement = x.autoPlacement
            this.hostIds = x.hostIds
            this.hostRecovery = x.hostRecovery
            this.instanceFamily = x.instanceFamily
            this.instanceType = x.instanceType
        }

        override fun build(): ModifyHostsRequest = ModifyHostsRequest(this)
        override fun autoPlacement(autoPlacement: AutoPlacement): FluentBuilder = apply { this.autoPlacement = autoPlacement }
        override fun hostIds(hostIds: List<String>): FluentBuilder = apply { this.hostIds = hostIds }
        override fun hostRecovery(hostRecovery: HostRecovery): FluentBuilder = apply { this.hostRecovery = hostRecovery }
        override fun instanceFamily(instanceFamily: String): FluentBuilder = apply { this.instanceFamily = instanceFamily }
        override fun instanceType(instanceType: String): FluentBuilder = apply { this.instanceType = instanceType }
    }
}
