// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for ModifyImageAttribute.
 */
class ModifyImageAttributeRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the attribute to modify.
     * The valid values are description and launchPermission.
     */
    val attribute: String? = builder.attribute
    /**
     * A new description for the AMI.
     */
    val description: AttributeValue? = builder.description
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The ID of the AMI.
     */
    val imageId: String? = builder.imageId
    /**
     * A new launch permission for the AMI.
     */
    val launchPermission: LaunchPermissionModifications? = builder.launchPermission
    /**
     * The operation type.
     * This parameter can be used only when the Attribute parameter is launchPermission.
     */
    val operationType: OperationType? = builder.operationType
    /**
     * Not supported.
     */
    val productCodes: List<String>? = builder.productCodes
    /**
     * The user groups.
     * This parameter can be used only when the Attribute parameter is launchPermission.
     */
    val userGroups: List<String>? = builder.userGroups
    /**
     * The Amazon Web Services account IDs.
     * This parameter can be used only when the Attribute parameter is launchPermission.
     */
    val userIds: List<String>? = builder.userIds
    /**
     * The value of the attribute being modified.
     * This parameter can be used only when the Attribute parameter is description.
     */
    val value: String? = builder.value

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifyImageAttributeRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyImageAttributeRequest(")
        append("attribute=$attribute,")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("imageId=$imageId,")
        append("launchPermission=$launchPermission,")
        append("operationType=$operationType,")
        append("productCodes=$productCodes,")
        append("userGroups=$userGroups,")
        append("userIds=$userIds,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attribute?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (launchPermission?.hashCode() ?: 0)
        result = 31 * result + (operationType?.hashCode() ?: 0)
        result = 31 * result + (productCodes?.hashCode() ?: 0)
        result = 31 * result + (userGroups?.hashCode() ?: 0)
        result = 31 * result + (userIds?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifyImageAttributeRequest

        if (attribute != other.attribute) return false
        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (imageId != other.imageId) return false
        if (launchPermission != other.launchPermission) return false
        if (operationType != other.operationType) return false
        if (productCodes != other.productCodes) return false
        if (userGroups != other.userGroups) return false
        if (userIds != other.userIds) return false
        if (value != other.value) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifyImageAttributeRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifyImageAttributeRequest
        /**
         * The name of the attribute to modify.
         * The valid values are description and launchPermission.
         */
        fun attribute(attribute: String): FluentBuilder
        /**
         * A new description for the AMI.
         */
        fun description(description: AttributeValue): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The ID of the AMI.
         */
        fun imageId(imageId: String): FluentBuilder
        /**
         * A new launch permission for the AMI.
         */
        fun launchPermission(launchPermission: LaunchPermissionModifications): FluentBuilder
        /**
         * The operation type.
         * This parameter can be used only when the Attribute parameter is launchPermission.
         */
        fun operationType(operationType: OperationType): FluentBuilder
        /**
         * Not supported.
         */
        fun productCodes(productCodes: List<String>): FluentBuilder
        /**
         * The user groups.
         * This parameter can be used only when the Attribute parameter is launchPermission.
         */
        fun userGroups(userGroups: List<String>): FluentBuilder
        /**
         * The Amazon Web Services account IDs.
         * This parameter can be used only when the Attribute parameter is launchPermission.
         */
        fun userIds(userIds: List<String>): FluentBuilder
        /**
         * The value of the attribute being modified.
         * This parameter can be used only when the Attribute parameter is description.
         */
        fun value(value: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the attribute to modify.
         * The valid values are description and launchPermission.
         */
        var attribute: String?
        /**
         * A new description for the AMI.
         */
        var description: AttributeValue?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The ID of the AMI.
         */
        var imageId: String?
        /**
         * A new launch permission for the AMI.
         */
        var launchPermission: LaunchPermissionModifications?
        /**
         * The operation type.
         * This parameter can be used only when the Attribute parameter is launchPermission.
         */
        var operationType: OperationType?
        /**
         * Not supported.
         */
        var productCodes: List<String>?
        /**
         * The user groups.
         * This parameter can be used only when the Attribute parameter is launchPermission.
         */
        var userGroups: List<String>?
        /**
         * The Amazon Web Services account IDs.
         * This parameter can be used only when the Attribute parameter is launchPermission.
         */
        var userIds: List<String>?
        /**
         * The value of the attribute being modified.
         * This parameter can be used only when the Attribute parameter is description.
         */
        var value: String?

        fun build(): ModifyImageAttributeRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeValue] inside the given [block]
         */
        fun description(block: AttributeValue.DslBuilder.() -> kotlin.Unit) {
            this.description = AttributeValue.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchPermissionModifications] inside the given [block]
         */
        fun launchPermission(block: LaunchPermissionModifications.DslBuilder.() -> kotlin.Unit) {
            this.launchPermission = LaunchPermissionModifications.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var attribute: String? = null
        override var description: AttributeValue? = null
        override var dryRun: Boolean? = null
        override var imageId: String? = null
        override var launchPermission: LaunchPermissionModifications? = null
        override var operationType: OperationType? = null
        override var productCodes: List<String>? = null
        override var userGroups: List<String>? = null
        override var userIds: List<String>? = null
        override var value: String? = null

        constructor(x: ModifyImageAttributeRequest) : this() {
            this.attribute = x.attribute
            this.description = x.description
            this.dryRun = x.dryRun
            this.imageId = x.imageId
            this.launchPermission = x.launchPermission
            this.operationType = x.operationType
            this.productCodes = x.productCodes
            this.userGroups = x.userGroups
            this.userIds = x.userIds
            this.value = x.value
        }

        override fun build(): ModifyImageAttributeRequest = ModifyImageAttributeRequest(this)
        override fun attribute(attribute: String): FluentBuilder = apply { this.attribute = attribute }
        override fun description(description: AttributeValue): FluentBuilder = apply { this.description = description }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun imageId(imageId: String): FluentBuilder = apply { this.imageId = imageId }
        override fun launchPermission(launchPermission: LaunchPermissionModifications): FluentBuilder = apply { this.launchPermission = launchPermission }
        override fun operationType(operationType: OperationType): FluentBuilder = apply { this.operationType = operationType }
        override fun productCodes(productCodes: List<String>): FluentBuilder = apply { this.productCodes = productCodes }
        override fun userGroups(userGroups: List<String>): FluentBuilder = apply { this.userGroups = userGroups }
        override fun userIds(userIds: List<String>): FluentBuilder = apply { this.userIds = userIds }
        override fun value(value: String): FluentBuilder = apply { this.value = value }
    }
}
