// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class ModifyInstanceMetadataOptionsRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * This parameter enables or disables the HTTP metadata endpoint on your instances. If
     * the parameter is not specified, the existing state is maintained.
     * If you specify a value of disabled, you will not be able to access your
     * instance metadata.
     */
    val httpEndpoint: InstanceMetadataEndpointState? = builder.httpEndpoint
    /**
     * Enables or disables the IPv6 endpoint for the instance metadata service.
     */
    val httpProtocolIpv6: InstanceMetadataProtocolState? = builder.httpProtocolIpv6
    /**
     * The desired HTTP PUT response hop limit for instance metadata requests. The larger the
     * number, the further instance metadata requests can travel. If no parameter is specified, the existing state is maintained.
     * Possible values: Integers from 1 to 64
     */
    val httpPutResponseHopLimit: Int? = builder.httpPutResponseHopLimit
    /**
     * The state of token usage for your instance metadata requests. If the parameter is not
     * specified in the request, the default state is optional.
     * If the state is optional, you can choose to retrieve instance metadata
     * with or without a signed token header on your request. If you retrieve the IAM role
     * credentials without a token, the version 1.0 role credentials are returned. If you
     * retrieve the IAM role credentials using a valid signed token, the version 2.0 role
     * credentials are returned.
     * If the state is required, you must send a signed token header with any
     * instance metadata retrieval requests. In this state, retrieving the IAM role credential
     * always returns the version 2.0 credentials; the version 1.0 credentials are not
     * available.
     */
    val httpTokens: HttpTokensState? = builder.httpTokens
    /**
     * The ID of the instance.
     */
    val instanceId: String? = builder.instanceId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifyInstanceMetadataOptionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyInstanceMetadataOptionsRequest(")
        append("dryRun=$dryRun,")
        append("httpEndpoint=$httpEndpoint,")
        append("httpProtocolIpv6=$httpProtocolIpv6,")
        append("httpPutResponseHopLimit=$httpPutResponseHopLimit,")
        append("httpTokens=$httpTokens,")
        append("instanceId=$instanceId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (httpEndpoint?.hashCode() ?: 0)
        result = 31 * result + (httpProtocolIpv6?.hashCode() ?: 0)
        result = 31 * result + (httpPutResponseHopLimit ?: 0)
        result = 31 * result + (httpTokens?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifyInstanceMetadataOptionsRequest

        if (dryRun != other.dryRun) return false
        if (httpEndpoint != other.httpEndpoint) return false
        if (httpProtocolIpv6 != other.httpProtocolIpv6) return false
        if (httpPutResponseHopLimit != other.httpPutResponseHopLimit) return false
        if (httpTokens != other.httpTokens) return false
        if (instanceId != other.instanceId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifyInstanceMetadataOptionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifyInstanceMetadataOptionsRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * This parameter enables or disables the HTTP metadata endpoint on your instances. If
         * the parameter is not specified, the existing state is maintained.
         * If you specify a value of disabled, you will not be able to access your
         * instance metadata.
         */
        fun httpEndpoint(httpEndpoint: InstanceMetadataEndpointState): FluentBuilder
        /**
         * Enables or disables the IPv6 endpoint for the instance metadata service.
         */
        fun httpProtocolIpv6(httpProtocolIpv6: InstanceMetadataProtocolState): FluentBuilder
        /**
         * The desired HTTP PUT response hop limit for instance metadata requests. The larger the
         * number, the further instance metadata requests can travel. If no parameter is specified, the existing state is maintained.
         * Possible values: Integers from 1 to 64
         */
        fun httpPutResponseHopLimit(httpPutResponseHopLimit: Int): FluentBuilder
        /**
         * The state of token usage for your instance metadata requests. If the parameter is not
         * specified in the request, the default state is optional.
         * If the state is optional, you can choose to retrieve instance metadata
         * with or without a signed token header on your request. If you retrieve the IAM role
         * credentials without a token, the version 1.0 role credentials are returned. If you
         * retrieve the IAM role credentials using a valid signed token, the version 2.0 role
         * credentials are returned.
         * If the state is required, you must send a signed token header with any
         * instance metadata retrieval requests. In this state, retrieving the IAM role credential
         * always returns the version 2.0 credentials; the version 1.0 credentials are not
         * available.
         */
        fun httpTokens(httpTokens: HttpTokensState): FluentBuilder
        /**
         * The ID of the instance.
         */
        fun instanceId(instanceId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * This parameter enables or disables the HTTP metadata endpoint on your instances. If
         * the parameter is not specified, the existing state is maintained.
         * If you specify a value of disabled, you will not be able to access your
         * instance metadata.
         */
        var httpEndpoint: InstanceMetadataEndpointState?
        /**
         * Enables or disables the IPv6 endpoint for the instance metadata service.
         */
        var httpProtocolIpv6: InstanceMetadataProtocolState?
        /**
         * The desired HTTP PUT response hop limit for instance metadata requests. The larger the
         * number, the further instance metadata requests can travel. If no parameter is specified, the existing state is maintained.
         * Possible values: Integers from 1 to 64
         */
        var httpPutResponseHopLimit: Int?
        /**
         * The state of token usage for your instance metadata requests. If the parameter is not
         * specified in the request, the default state is optional.
         * If the state is optional, you can choose to retrieve instance metadata
         * with or without a signed token header on your request. If you retrieve the IAM role
         * credentials without a token, the version 1.0 role credentials are returned. If you
         * retrieve the IAM role credentials using a valid signed token, the version 2.0 role
         * credentials are returned.
         * If the state is required, you must send a signed token header with any
         * instance metadata retrieval requests. In this state, retrieving the IAM role credential
         * always returns the version 2.0 credentials; the version 1.0 credentials are not
         * available.
         */
        var httpTokens: HttpTokensState?
        /**
         * The ID of the instance.
         */
        var instanceId: String?

        fun build(): ModifyInstanceMetadataOptionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var httpEndpoint: InstanceMetadataEndpointState? = null
        override var httpProtocolIpv6: InstanceMetadataProtocolState? = null
        override var httpPutResponseHopLimit: Int? = null
        override var httpTokens: HttpTokensState? = null
        override var instanceId: String? = null

        constructor(x: ModifyInstanceMetadataOptionsRequest) : this() {
            this.dryRun = x.dryRun
            this.httpEndpoint = x.httpEndpoint
            this.httpProtocolIpv6 = x.httpProtocolIpv6
            this.httpPutResponseHopLimit = x.httpPutResponseHopLimit
            this.httpTokens = x.httpTokens
            this.instanceId = x.instanceId
        }

        override fun build(): ModifyInstanceMetadataOptionsRequest = ModifyInstanceMetadataOptionsRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun httpEndpoint(httpEndpoint: InstanceMetadataEndpointState): FluentBuilder = apply { this.httpEndpoint = httpEndpoint }
        override fun httpProtocolIpv6(httpProtocolIpv6: InstanceMetadataProtocolState): FluentBuilder = apply { this.httpProtocolIpv6 = httpProtocolIpv6 }
        override fun httpPutResponseHopLimit(httpPutResponseHopLimit: Int): FluentBuilder = apply { this.httpPutResponseHopLimit = httpPutResponseHopLimit }
        override fun httpTokens(httpTokens: HttpTokensState): FluentBuilder = apply { this.httpTokens = httpTokens }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
    }
}
