// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class ModifyInstancePlacementRequest private constructor(builder: BuilderImpl) {
    /**
     * The affinity setting for the instance.
     */
    val affinity: Affinity? = builder.affinity
    /**
     * The name of the placement group in which to place the instance. For spread placement
     * groups, the instance must have a tenancy of default. For cluster and
     * partition placement groups, the instance must have a tenancy of default or
     * dedicated.
     * To remove an instance from a placement group, specify an empty string
     * ("").
     */
    val groupName: String? = builder.groupName
    /**
     * The ID of the Dedicated Host with which to associate the instance.
     */
    val hostId: String? = builder.hostId
    /**
     * The ARN of the host resource group in which to place the instance.
     */
    val hostResourceGroupArn: String? = builder.hostResourceGroupArn
    /**
     * The ID of the instance that you are modifying.
     */
    val instanceId: String? = builder.instanceId
    /**
     * Reserved for future use.
     */
    val partitionNumber: Int? = builder.partitionNumber
    /**
     * The tenancy for the instance.
     * For T3 instances, you can't change the tenancy from dedicated
     * to host, or from host to dedicated.
     * Attempting to make one of these unsupported tenancy changes results in the
     * InvalidTenancy error code.
     */
    val tenancy: HostTenancy? = builder.tenancy

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifyInstancePlacementRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyInstancePlacementRequest(")
        append("affinity=$affinity,")
        append("groupName=$groupName,")
        append("hostId=$hostId,")
        append("hostResourceGroupArn=$hostResourceGroupArn,")
        append("instanceId=$instanceId,")
        append("partitionNumber=$partitionNumber,")
        append("tenancy=$tenancy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = affinity?.hashCode() ?: 0
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (hostId?.hashCode() ?: 0)
        result = 31 * result + (hostResourceGroupArn?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (partitionNumber ?: 0)
        result = 31 * result + (tenancy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifyInstancePlacementRequest

        if (affinity != other.affinity) return false
        if (groupName != other.groupName) return false
        if (hostId != other.hostId) return false
        if (hostResourceGroupArn != other.hostResourceGroupArn) return false
        if (instanceId != other.instanceId) return false
        if (partitionNumber != other.partitionNumber) return false
        if (tenancy != other.tenancy) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifyInstancePlacementRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifyInstancePlacementRequest
        /**
         * The affinity setting for the instance.
         */
        fun affinity(affinity: Affinity): FluentBuilder
        /**
         * The name of the placement group in which to place the instance. For spread placement
         * groups, the instance must have a tenancy of default. For cluster and
         * partition placement groups, the instance must have a tenancy of default or
         * dedicated.
         * To remove an instance from a placement group, specify an empty string
         * ("").
         */
        fun groupName(groupName: String): FluentBuilder
        /**
         * The ID of the Dedicated Host with which to associate the instance.
         */
        fun hostId(hostId: String): FluentBuilder
        /**
         * The ARN of the host resource group in which to place the instance.
         */
        fun hostResourceGroupArn(hostResourceGroupArn: String): FluentBuilder
        /**
         * The ID of the instance that you are modifying.
         */
        fun instanceId(instanceId: String): FluentBuilder
        /**
         * Reserved for future use.
         */
        fun partitionNumber(partitionNumber: Int): FluentBuilder
        /**
         * The tenancy for the instance.
         * For T3 instances, you can't change the tenancy from dedicated
         * to host, or from host to dedicated.
         * Attempting to make one of these unsupported tenancy changes results in the
         * InvalidTenancy error code.
         */
        fun tenancy(tenancy: HostTenancy): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The affinity setting for the instance.
         */
        var affinity: Affinity?
        /**
         * The name of the placement group in which to place the instance. For spread placement
         * groups, the instance must have a tenancy of default. For cluster and
         * partition placement groups, the instance must have a tenancy of default or
         * dedicated.
         * To remove an instance from a placement group, specify an empty string
         * ("").
         */
        var groupName: String?
        /**
         * The ID of the Dedicated Host with which to associate the instance.
         */
        var hostId: String?
        /**
         * The ARN of the host resource group in which to place the instance.
         */
        var hostResourceGroupArn: String?
        /**
         * The ID of the instance that you are modifying.
         */
        var instanceId: String?
        /**
         * Reserved for future use.
         */
        var partitionNumber: Int?
        /**
         * The tenancy for the instance.
         * For T3 instances, you can't change the tenancy from dedicated
         * to host, or from host to dedicated.
         * Attempting to make one of these unsupported tenancy changes results in the
         * InvalidTenancy error code.
         */
        var tenancy: HostTenancy?

        fun build(): ModifyInstancePlacementRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var affinity: Affinity? = null
        override var groupName: String? = null
        override var hostId: String? = null
        override var hostResourceGroupArn: String? = null
        override var instanceId: String? = null
        override var partitionNumber: Int? = null
        override var tenancy: HostTenancy? = null

        constructor(x: ModifyInstancePlacementRequest) : this() {
            this.affinity = x.affinity
            this.groupName = x.groupName
            this.hostId = x.hostId
            this.hostResourceGroupArn = x.hostResourceGroupArn
            this.instanceId = x.instanceId
            this.partitionNumber = x.partitionNumber
            this.tenancy = x.tenancy
        }

        override fun build(): ModifyInstancePlacementRequest = ModifyInstancePlacementRequest(this)
        override fun affinity(affinity: Affinity): FluentBuilder = apply { this.affinity = affinity }
        override fun groupName(groupName: String): FluentBuilder = apply { this.groupName = groupName }
        override fun hostId(hostId: String): FluentBuilder = apply { this.hostId = hostId }
        override fun hostResourceGroupArn(hostResourceGroupArn: String): FluentBuilder = apply { this.hostResourceGroupArn = hostResourceGroupArn }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
        override fun partitionNumber(partitionNumber: Int): FluentBuilder = apply { this.partitionNumber = partitionNumber }
        override fun tenancy(tenancy: HostTenancy): FluentBuilder = apply { this.tenancy = tenancy }
    }
}
