// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for ModifyNetworkInterfaceAttribute.
 */
class ModifyNetworkInterfaceAttributeRequest private constructor(builder: BuilderImpl) {
    /**
     * Information about the interface attachment. If modifying the 'delete on termination' attribute, you must specify the ID of the interface attachment.
     */
    val attachment: NetworkInterfaceAttachmentChanges? = builder.attachment
    /**
     * A description for the network interface.
     */
    val description: AttributeValue? = builder.description
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * Changes the security groups for the network interface. The new set of groups you specify replaces the current set. You must specify at least one group, even if it's just the default security group in the VPC. You must specify the ID of the security group, not the name.
     */
    val groups: List<String>? = builder.groups
    /**
     * The ID of the network interface.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * Enable or disable source/destination checks, which ensure that the instance
     * is either the source or the destination of any traffic that it receives.
     * If the value is true, source/destination checks are enabled;
     * otherwise, they are disabled. The default value is true.
     * You must disable source/destination checks if the instance runs services
     * such as network address translation, routing, or firewalls.
     */
    val sourceDestCheck: AttributeBooleanValue? = builder.sourceDestCheck

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifyNetworkInterfaceAttributeRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyNetworkInterfaceAttributeRequest(")
        append("attachment=$attachment,")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("groups=$groups,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("sourceDestCheck=$sourceDestCheck)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachment?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (groups?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (sourceDestCheck?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifyNetworkInterfaceAttributeRequest

        if (attachment != other.attachment) return false
        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (groups != other.groups) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (sourceDestCheck != other.sourceDestCheck) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifyNetworkInterfaceAttributeRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifyNetworkInterfaceAttributeRequest
        /**
         * Information about the interface attachment. If modifying the 'delete on termination' attribute, you must specify the ID of the interface attachment.
         */
        fun attachment(attachment: NetworkInterfaceAttachmentChanges): FluentBuilder
        /**
         * A description for the network interface.
         */
        fun description(description: AttributeValue): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * Changes the security groups for the network interface. The new set of groups you specify replaces the current set. You must specify at least one group, even if it's just the default security group in the VPC. You must specify the ID of the security group, not the name.
         */
        fun groups(groups: List<String>): FluentBuilder
        /**
         * The ID of the network interface.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * Enable or disable source/destination checks, which ensure that the instance
         * is either the source or the destination of any traffic that it receives.
         * If the value is true, source/destination checks are enabled;
         * otherwise, they are disabled. The default value is true.
         * You must disable source/destination checks if the instance runs services
         * such as network address translation, routing, or firewalls.
         */
        fun sourceDestCheck(sourceDestCheck: AttributeBooleanValue): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Information about the interface attachment. If modifying the 'delete on termination' attribute, you must specify the ID of the interface attachment.
         */
        var attachment: NetworkInterfaceAttachmentChanges?
        /**
         * A description for the network interface.
         */
        var description: AttributeValue?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * Changes the security groups for the network interface. The new set of groups you specify replaces the current set. You must specify at least one group, even if it's just the default security group in the VPC. You must specify the ID of the security group, not the name.
         */
        var groups: List<String>?
        /**
         * The ID of the network interface.
         */
        var networkInterfaceId: String?
        /**
         * Enable or disable source/destination checks, which ensure that the instance
         * is either the source or the destination of any traffic that it receives.
         * If the value is true, source/destination checks are enabled;
         * otherwise, they are disabled. The default value is true.
         * You must disable source/destination checks if the instance runs services
         * such as network address translation, routing, or firewalls.
         */
        var sourceDestCheck: AttributeBooleanValue?

        fun build(): ModifyNetworkInterfaceAttributeRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAttachmentChanges] inside the given [block]
         */
        fun attachment(block: NetworkInterfaceAttachmentChanges.DslBuilder.() -> kotlin.Unit) {
            this.attachment = NetworkInterfaceAttachmentChanges.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeValue] inside the given [block]
         */
        fun description(block: AttributeValue.DslBuilder.() -> kotlin.Unit) {
            this.description = AttributeValue.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue] inside the given [block]
         */
        fun sourceDestCheck(block: AttributeBooleanValue.DslBuilder.() -> kotlin.Unit) {
            this.sourceDestCheck = AttributeBooleanValue.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var attachment: NetworkInterfaceAttachmentChanges? = null
        override var description: AttributeValue? = null
        override var dryRun: Boolean? = null
        override var groups: List<String>? = null
        override var networkInterfaceId: String? = null
        override var sourceDestCheck: AttributeBooleanValue? = null

        constructor(x: ModifyNetworkInterfaceAttributeRequest) : this() {
            this.attachment = x.attachment
            this.description = x.description
            this.dryRun = x.dryRun
            this.groups = x.groups
            this.networkInterfaceId = x.networkInterfaceId
            this.sourceDestCheck = x.sourceDestCheck
        }

        override fun build(): ModifyNetworkInterfaceAttributeRequest = ModifyNetworkInterfaceAttributeRequest(this)
        override fun attachment(attachment: NetworkInterfaceAttachmentChanges): FluentBuilder = apply { this.attachment = attachment }
        override fun description(description: AttributeValue): FluentBuilder = apply { this.description = description }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun groups(groups: List<String>): FluentBuilder = apply { this.groups = groups }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun sourceDestCheck(sourceDestCheck: AttributeBooleanValue): FluentBuilder = apply { this.sourceDestCheck = sourceDestCheck }
    }
}
