// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class ModifySubnetAttributeRequest private constructor(builder: BuilderImpl) {
    /**
     * Specify true to indicate that network interfaces created in the
     * specified subnet should be assigned an IPv6 address. This includes a network interface
     * that's created when launching an instance into the subnet (the instance therefore
     * receives an IPv6 address).
     * If you enable the IPv6 addressing feature for your subnet, your network interface
     * or instance only receives an IPv6 address if it's created using version
     * 2016-11-15 or later of the Amazon EC2 API.
     */
    val assignIpv6AddressOnCreation: AttributeBooleanValue? = builder.assignIpv6AddressOnCreation
    /**
     * The customer-owned IPv4 address pool associated with the subnet.
     * You must set this value when you specify true for MapCustomerOwnedIpOnLaunch.
     */
    val customerOwnedIpv4Pool: String? = builder.customerOwnedIpv4Pool
    /**
     * Specify true to indicate that network interfaces  attached to instances created in the
     * specified subnet should be assigned a customer-owned IPv4 address.
     * When this value is true, you must specify the customer-owned IP pool using CustomerOwnedIpv4Pool.
     */
    val mapCustomerOwnedIpOnLaunch: AttributeBooleanValue? = builder.mapCustomerOwnedIpOnLaunch
    /**
     * Specify true to indicate that network interfaces attached to instances created in the
     * specified subnet should be assigned a public IPv4 address.
     */
    val mapPublicIpOnLaunch: AttributeBooleanValue? = builder.mapPublicIpOnLaunch
    /**
     * The ID of the subnet.
     */
    val subnetId: String? = builder.subnetId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifySubnetAttributeRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifySubnetAttributeRequest(")
        append("assignIpv6AddressOnCreation=$assignIpv6AddressOnCreation,")
        append("customerOwnedIpv4Pool=$customerOwnedIpv4Pool,")
        append("mapCustomerOwnedIpOnLaunch=$mapCustomerOwnedIpOnLaunch,")
        append("mapPublicIpOnLaunch=$mapPublicIpOnLaunch,")
        append("subnetId=$subnetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assignIpv6AddressOnCreation?.hashCode() ?: 0
        result = 31 * result + (customerOwnedIpv4Pool?.hashCode() ?: 0)
        result = 31 * result + (mapCustomerOwnedIpOnLaunch?.hashCode() ?: 0)
        result = 31 * result + (mapPublicIpOnLaunch?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifySubnetAttributeRequest

        if (assignIpv6AddressOnCreation != other.assignIpv6AddressOnCreation) return false
        if (customerOwnedIpv4Pool != other.customerOwnedIpv4Pool) return false
        if (mapCustomerOwnedIpOnLaunch != other.mapCustomerOwnedIpOnLaunch) return false
        if (mapPublicIpOnLaunch != other.mapPublicIpOnLaunch) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifySubnetAttributeRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifySubnetAttributeRequest
        /**
         * Specify true to indicate that network interfaces created in the
         * specified subnet should be assigned an IPv6 address. This includes a network interface
         * that's created when launching an instance into the subnet (the instance therefore
         * receives an IPv6 address).
         * If you enable the IPv6 addressing feature for your subnet, your network interface
         * or instance only receives an IPv6 address if it's created using version
         * 2016-11-15 or later of the Amazon EC2 API.
         */
        fun assignIpv6AddressOnCreation(assignIpv6AddressOnCreation: AttributeBooleanValue): FluentBuilder
        /**
         * The customer-owned IPv4 address pool associated with the subnet.
         * You must set this value when you specify true for MapCustomerOwnedIpOnLaunch.
         */
        fun customerOwnedIpv4Pool(customerOwnedIpv4Pool: String): FluentBuilder
        /**
         * Specify true to indicate that network interfaces  attached to instances created in the
         * specified subnet should be assigned a customer-owned IPv4 address.
         * When this value is true, you must specify the customer-owned IP pool using CustomerOwnedIpv4Pool.
         */
        fun mapCustomerOwnedIpOnLaunch(mapCustomerOwnedIpOnLaunch: AttributeBooleanValue): FluentBuilder
        /**
         * Specify true to indicate that network interfaces attached to instances created in the
         * specified subnet should be assigned a public IPv4 address.
         */
        fun mapPublicIpOnLaunch(mapPublicIpOnLaunch: AttributeBooleanValue): FluentBuilder
        /**
         * The ID of the subnet.
         */
        fun subnetId(subnetId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specify true to indicate that network interfaces created in the
         * specified subnet should be assigned an IPv6 address. This includes a network interface
         * that's created when launching an instance into the subnet (the instance therefore
         * receives an IPv6 address).
         * If you enable the IPv6 addressing feature for your subnet, your network interface
         * or instance only receives an IPv6 address if it's created using version
         * 2016-11-15 or later of the Amazon EC2 API.
         */
        var assignIpv6AddressOnCreation: AttributeBooleanValue?
        /**
         * The customer-owned IPv4 address pool associated with the subnet.
         * You must set this value when you specify true for MapCustomerOwnedIpOnLaunch.
         */
        var customerOwnedIpv4Pool: String?
        /**
         * Specify true to indicate that network interfaces  attached to instances created in the
         * specified subnet should be assigned a customer-owned IPv4 address.
         * When this value is true, you must specify the customer-owned IP pool using CustomerOwnedIpv4Pool.
         */
        var mapCustomerOwnedIpOnLaunch: AttributeBooleanValue?
        /**
         * Specify true to indicate that network interfaces attached to instances created in the
         * specified subnet should be assigned a public IPv4 address.
         */
        var mapPublicIpOnLaunch: AttributeBooleanValue?
        /**
         * The ID of the subnet.
         */
        var subnetId: String?

        fun build(): ModifySubnetAttributeRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue] inside the given [block]
         */
        fun assignIpv6AddressOnCreation(block: AttributeBooleanValue.DslBuilder.() -> kotlin.Unit) {
            this.assignIpv6AddressOnCreation = AttributeBooleanValue.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue] inside the given [block]
         */
        fun mapCustomerOwnedIpOnLaunch(block: AttributeBooleanValue.DslBuilder.() -> kotlin.Unit) {
            this.mapCustomerOwnedIpOnLaunch = AttributeBooleanValue.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue] inside the given [block]
         */
        fun mapPublicIpOnLaunch(block: AttributeBooleanValue.DslBuilder.() -> kotlin.Unit) {
            this.mapPublicIpOnLaunch = AttributeBooleanValue.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assignIpv6AddressOnCreation: AttributeBooleanValue? = null
        override var customerOwnedIpv4Pool: String? = null
        override var mapCustomerOwnedIpOnLaunch: AttributeBooleanValue? = null
        override var mapPublicIpOnLaunch: AttributeBooleanValue? = null
        override var subnetId: String? = null

        constructor(x: ModifySubnetAttributeRequest) : this() {
            this.assignIpv6AddressOnCreation = x.assignIpv6AddressOnCreation
            this.customerOwnedIpv4Pool = x.customerOwnedIpv4Pool
            this.mapCustomerOwnedIpOnLaunch = x.mapCustomerOwnedIpOnLaunch
            this.mapPublicIpOnLaunch = x.mapPublicIpOnLaunch
            this.subnetId = x.subnetId
        }

        override fun build(): ModifySubnetAttributeRequest = ModifySubnetAttributeRequest(this)
        override fun assignIpv6AddressOnCreation(assignIpv6AddressOnCreation: AttributeBooleanValue): FluentBuilder = apply { this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation }
        override fun customerOwnedIpv4Pool(customerOwnedIpv4Pool: String): FluentBuilder = apply { this.customerOwnedIpv4Pool = customerOwnedIpv4Pool }
        override fun mapCustomerOwnedIpOnLaunch(mapCustomerOwnedIpOnLaunch: AttributeBooleanValue): FluentBuilder = apply { this.mapCustomerOwnedIpOnLaunch = mapCustomerOwnedIpOnLaunch }
        override fun mapPublicIpOnLaunch(mapPublicIpOnLaunch: AttributeBooleanValue): FluentBuilder = apply { this.mapPublicIpOnLaunch = mapPublicIpOnLaunch }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
    }
}
