// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class ModifyTrafficMirrorSessionRequest private constructor(builder: BuilderImpl) {
    /**
     * The description to assign to the Traffic Mirror session.
     */
    val description: String? = builder.description
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The number of bytes in each packet to mirror. These are bytes after the VXLAN header. To mirror a subset, set this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first 100 bytes that meet the filter criteria are copied to the target. Do not specify this parameter when you want to mirror the entire packet.
     */
    val packetLength: Int? = builder.packetLength
    /**
     * The properties that you want to remove from the Traffic Mirror session.
     * When you remove a property from a Traffic Mirror session, the property is set to the default.
     */
    val removeFields: List<TrafficMirrorSessionField>? = builder.removeFields
    /**
     * The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
     * Valid values are 1-32766.
     */
    val sessionNumber: Int? = builder.sessionNumber
    /**
     * The ID of the Traffic Mirror filter.
     */
    val trafficMirrorFilterId: String? = builder.trafficMirrorFilterId
    /**
     * The ID of the Traffic Mirror session.
     */
    val trafficMirrorSessionId: String? = builder.trafficMirrorSessionId
    /**
     * The Traffic Mirror target. The target must be in the same VPC as the source, or have a VPC peering connection with the source.
     */
    val trafficMirrorTargetId: String? = builder.trafficMirrorTargetId
    /**
     * The virtual network ID of the Traffic Mirror session.
     */
    val virtualNetworkId: Int? = builder.virtualNetworkId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifyTrafficMirrorSessionRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyTrafficMirrorSessionRequest(")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("packetLength=$packetLength,")
        append("removeFields=$removeFields,")
        append("sessionNumber=$sessionNumber,")
        append("trafficMirrorFilterId=$trafficMirrorFilterId,")
        append("trafficMirrorSessionId=$trafficMirrorSessionId,")
        append("trafficMirrorTargetId=$trafficMirrorTargetId,")
        append("virtualNetworkId=$virtualNetworkId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (packetLength ?: 0)
        result = 31 * result + (removeFields?.hashCode() ?: 0)
        result = 31 * result + (sessionNumber ?: 0)
        result = 31 * result + (trafficMirrorFilterId?.hashCode() ?: 0)
        result = 31 * result + (trafficMirrorSessionId?.hashCode() ?: 0)
        result = 31 * result + (trafficMirrorTargetId?.hashCode() ?: 0)
        result = 31 * result + (virtualNetworkId ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifyTrafficMirrorSessionRequest

        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (packetLength != other.packetLength) return false
        if (removeFields != other.removeFields) return false
        if (sessionNumber != other.sessionNumber) return false
        if (trafficMirrorFilterId != other.trafficMirrorFilterId) return false
        if (trafficMirrorSessionId != other.trafficMirrorSessionId) return false
        if (trafficMirrorTargetId != other.trafficMirrorTargetId) return false
        if (virtualNetworkId != other.virtualNetworkId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifyTrafficMirrorSessionRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifyTrafficMirrorSessionRequest
        /**
         * The description to assign to the Traffic Mirror session.
         */
        fun description(description: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The number of bytes in each packet to mirror. These are bytes after the VXLAN header. To mirror a subset, set this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first 100 bytes that meet the filter criteria are copied to the target. Do not specify this parameter when you want to mirror the entire packet.
         */
        fun packetLength(packetLength: Int): FluentBuilder
        /**
         * The properties that you want to remove from the Traffic Mirror session.
         * When you remove a property from a Traffic Mirror session, the property is set to the default.
         */
        fun removeFields(removeFields: List<TrafficMirrorSessionField>): FluentBuilder
        /**
         * The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
         * Valid values are 1-32766.
         */
        fun sessionNumber(sessionNumber: Int): FluentBuilder
        /**
         * The ID of the Traffic Mirror filter.
         */
        fun trafficMirrorFilterId(trafficMirrorFilterId: String): FluentBuilder
        /**
         * The ID of the Traffic Mirror session.
         */
        fun trafficMirrorSessionId(trafficMirrorSessionId: String): FluentBuilder
        /**
         * The Traffic Mirror target. The target must be in the same VPC as the source, or have a VPC peering connection with the source.
         */
        fun trafficMirrorTargetId(trafficMirrorTargetId: String): FluentBuilder
        /**
         * The virtual network ID of the Traffic Mirror session.
         */
        fun virtualNetworkId(virtualNetworkId: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The description to assign to the Traffic Mirror session.
         */
        var description: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The number of bytes in each packet to mirror. These are bytes after the VXLAN header. To mirror a subset, set this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first 100 bytes that meet the filter criteria are copied to the target. Do not specify this parameter when you want to mirror the entire packet.
         */
        var packetLength: Int?
        /**
         * The properties that you want to remove from the Traffic Mirror session.
         * When you remove a property from a Traffic Mirror session, the property is set to the default.
         */
        var removeFields: List<TrafficMirrorSessionField>?
        /**
         * The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
         * Valid values are 1-32766.
         */
        var sessionNumber: Int?
        /**
         * The ID of the Traffic Mirror filter.
         */
        var trafficMirrorFilterId: String?
        /**
         * The ID of the Traffic Mirror session.
         */
        var trafficMirrorSessionId: String?
        /**
         * The Traffic Mirror target. The target must be in the same VPC as the source, or have a VPC peering connection with the source.
         */
        var trafficMirrorTargetId: String?
        /**
         * The virtual network ID of the Traffic Mirror session.
         */
        var virtualNetworkId: Int?

        fun build(): ModifyTrafficMirrorSessionRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var dryRun: Boolean? = null
        override var packetLength: Int? = null
        override var removeFields: List<TrafficMirrorSessionField>? = null
        override var sessionNumber: Int? = null
        override var trafficMirrorFilterId: String? = null
        override var trafficMirrorSessionId: String? = null
        override var trafficMirrorTargetId: String? = null
        override var virtualNetworkId: Int? = null

        constructor(x: ModifyTrafficMirrorSessionRequest) : this() {
            this.description = x.description
            this.dryRun = x.dryRun
            this.packetLength = x.packetLength
            this.removeFields = x.removeFields
            this.sessionNumber = x.sessionNumber
            this.trafficMirrorFilterId = x.trafficMirrorFilterId
            this.trafficMirrorSessionId = x.trafficMirrorSessionId
            this.trafficMirrorTargetId = x.trafficMirrorTargetId
            this.virtualNetworkId = x.virtualNetworkId
        }

        override fun build(): ModifyTrafficMirrorSessionRequest = ModifyTrafficMirrorSessionRequest(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun packetLength(packetLength: Int): FluentBuilder = apply { this.packetLength = packetLength }
        override fun removeFields(removeFields: List<TrafficMirrorSessionField>): FluentBuilder = apply { this.removeFields = removeFields }
        override fun sessionNumber(sessionNumber: Int): FluentBuilder = apply { this.sessionNumber = sessionNumber }
        override fun trafficMirrorFilterId(trafficMirrorFilterId: String): FluentBuilder = apply { this.trafficMirrorFilterId = trafficMirrorFilterId }
        override fun trafficMirrorSessionId(trafficMirrorSessionId: String): FluentBuilder = apply { this.trafficMirrorSessionId = trafficMirrorSessionId }
        override fun trafficMirrorTargetId(trafficMirrorTargetId: String): FluentBuilder = apply { this.trafficMirrorTargetId = trafficMirrorTargetId }
        override fun virtualNetworkId(virtualNetworkId: Int): FluentBuilder = apply { this.virtualNetworkId = virtualNetworkId }
    }
}
