// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class ModifyVolumeRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The target IOPS rate of the volume. This parameter is valid only for gp3, io1, and io2 volumes.
     * The following are the supported values for each volume type:
     * gp3: 3,000-16,000 IOPS
     * io1: 100-64,000 IOPS
     * io2: 100-64,000 IOPS
     * Default: The existing value is retained if you keep the same volume type. If you change
     * the volume type to io1, io2, or gp3, the default is 3,000.
     */
    val iops: Int? = builder.iops
    /**
     * Specifies whether to enable Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the
     * volume to up to 16 <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">
     * Nitro-based instances in the same Availability Zone. This parameter is
     * supported with io1 and io2 volumes only. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes-multi.html">
     * Amazon EBS Multi-Attach in the Amazon Elastic Compute Cloud User Guide.
     */
    val multiAttachEnabled: Boolean? = builder.multiAttachEnabled
    /**
     * The target size of the volume, in GiB. The target volume size must be greater than or
     * equal to the existing size of the volume.
     * The following are the supported volumes sizes for each volume type:
     * gp2 and gp3: 1-16,384
     * io1 and io2: 4-16,384
     * st1 and sc1: 125-16,384
     * standard: 1-1,024
     * Default: The existing size is retained.
     */
    val size: Int? = builder.size
    /**
     * The target throughput of the volume, in MiB/s. This parameter is valid only for gp3 volumes.
     * The maximum value is 1,000.
     * Default: The existing value is retained if the source and target volume type is gp3.
     * Otherwise, the default value is 125.
     * Valid Range: Minimum value of 125. Maximum value of 1000.
     */
    val throughput: Int? = builder.throughput
    /**
     * The ID of the volume.
     */
    val volumeId: String? = builder.volumeId
    /**
     * The target EBS volume type of the volume. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types in the Amazon Elastic Compute Cloud User Guide.
     * Default: The existing type is retained.
     */
    val volumeType: VolumeType? = builder.volumeType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifyVolumeRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyVolumeRequest(")
        append("dryRun=$dryRun,")
        append("iops=$iops,")
        append("multiAttachEnabled=$multiAttachEnabled,")
        append("size=$size,")
        append("throughput=$throughput,")
        append("volumeId=$volumeId,")
        append("volumeType=$volumeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (multiAttachEnabled?.hashCode() ?: 0)
        result = 31 * result + (size ?: 0)
        result = 31 * result + (throughput ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifyVolumeRequest

        if (dryRun != other.dryRun) return false
        if (iops != other.iops) return false
        if (multiAttachEnabled != other.multiAttachEnabled) return false
        if (size != other.size) return false
        if (throughput != other.throughput) return false
        if (volumeId != other.volumeId) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifyVolumeRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifyVolumeRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The target IOPS rate of the volume. This parameter is valid only for gp3, io1, and io2 volumes.
         * The following are the supported values for each volume type:
         * gp3: 3,000-16,000 IOPS
         * io1: 100-64,000 IOPS
         * io2: 100-64,000 IOPS
         * Default: The existing value is retained if you keep the same volume type. If you change
         * the volume type to io1, io2, or gp3, the default is 3,000.
         */
        fun iops(iops: Int): FluentBuilder
        /**
         * Specifies whether to enable Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the
         * volume to up to 16 <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">
         * Nitro-based instances in the same Availability Zone. This parameter is
         * supported with io1 and io2 volumes only. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes-multi.html">
         * Amazon EBS Multi-Attach in the Amazon Elastic Compute Cloud User Guide.
         */
        fun multiAttachEnabled(multiAttachEnabled: Boolean): FluentBuilder
        /**
         * The target size of the volume, in GiB. The target volume size must be greater than or
         * equal to the existing size of the volume.
         * The following are the supported volumes sizes for each volume type:
         * gp2 and gp3: 1-16,384
         * io1 and io2: 4-16,384
         * st1 and sc1: 125-16,384
         * standard: 1-1,024
         * Default: The existing size is retained.
         */
        fun size(size: Int): FluentBuilder
        /**
         * The target throughput of the volume, in MiB/s. This parameter is valid only for gp3 volumes.
         * The maximum value is 1,000.
         * Default: The existing value is retained if the source and target volume type is gp3.
         * Otherwise, the default value is 125.
         * Valid Range: Minimum value of 125. Maximum value of 1000.
         */
        fun throughput(throughput: Int): FluentBuilder
        /**
         * The ID of the volume.
         */
        fun volumeId(volumeId: String): FluentBuilder
        /**
         * The target EBS volume type of the volume. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types in the Amazon Elastic Compute Cloud User Guide.
         * Default: The existing type is retained.
         */
        fun volumeType(volumeType: VolumeType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The target IOPS rate of the volume. This parameter is valid only for gp3, io1, and io2 volumes.
         * The following are the supported values for each volume type:
         * gp3: 3,000-16,000 IOPS
         * io1: 100-64,000 IOPS
         * io2: 100-64,000 IOPS
         * Default: The existing value is retained if you keep the same volume type. If you change
         * the volume type to io1, io2, or gp3, the default is 3,000.
         */
        var iops: Int?
        /**
         * Specifies whether to enable Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the
         * volume to up to 16 <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">
         * Nitro-based instances in the same Availability Zone. This parameter is
         * supported with io1 and io2 volumes only. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes-multi.html">
         * Amazon EBS Multi-Attach in the Amazon Elastic Compute Cloud User Guide.
         */
        var multiAttachEnabled: Boolean?
        /**
         * The target size of the volume, in GiB. The target volume size must be greater than or
         * equal to the existing size of the volume.
         * The following are the supported volumes sizes for each volume type:
         * gp2 and gp3: 1-16,384
         * io1 and io2: 4-16,384
         * st1 and sc1: 125-16,384
         * standard: 1-1,024
         * Default: The existing size is retained.
         */
        var size: Int?
        /**
         * The target throughput of the volume, in MiB/s. This parameter is valid only for gp3 volumes.
         * The maximum value is 1,000.
         * Default: The existing value is retained if the source and target volume type is gp3.
         * Otherwise, the default value is 125.
         * Valid Range: Minimum value of 125. Maximum value of 1000.
         */
        var throughput: Int?
        /**
         * The ID of the volume.
         */
        var volumeId: String?
        /**
         * The target EBS volume type of the volume. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types in the Amazon Elastic Compute Cloud User Guide.
         * Default: The existing type is retained.
         */
        var volumeType: VolumeType?

        fun build(): ModifyVolumeRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var iops: Int? = null
        override var multiAttachEnabled: Boolean? = null
        override var size: Int? = null
        override var throughput: Int? = null
        override var volumeId: String? = null
        override var volumeType: VolumeType? = null

        constructor(x: ModifyVolumeRequest) : this() {
            this.dryRun = x.dryRun
            this.iops = x.iops
            this.multiAttachEnabled = x.multiAttachEnabled
            this.size = x.size
            this.throughput = x.throughput
            this.volumeId = x.volumeId
            this.volumeType = x.volumeType
        }

        override fun build(): ModifyVolumeRequest = ModifyVolumeRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun iops(iops: Int): FluentBuilder = apply { this.iops = iops }
        override fun multiAttachEnabled(multiAttachEnabled: Boolean): FluentBuilder = apply { this.multiAttachEnabled = multiAttachEnabled }
        override fun size(size: Int): FluentBuilder = apply { this.size = size }
        override fun throughput(throughput: Int): FluentBuilder = apply { this.throughput = throughput }
        override fun volumeId(volumeId: String): FluentBuilder = apply { this.volumeId = volumeId }
        override fun volumeType(volumeType: VolumeType): FluentBuilder = apply { this.volumeType = volumeType }
    }
}
