// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class ModifyVpcAttributeRequest private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether the instances launched in the VPC get DNS hostnames. If enabled, instances in the VPC get DNS hostnames; otherwise, they do not.
     * You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for each attribute. You can only enable DNS hostnames if you've enabled DNS support.
     */
    val enableDnsHostnames: AttributeBooleanValue? = builder.enableDnsHostnames
    /**
     * Indicates whether the DNS resolution is supported for the VPC. If enabled, queries to
     * the Amazon provided DNS server at the 169.254.169.253 IP address, or the reserved IP
     * address at the base of the VPC network range "plus two" succeed. If disabled, the Amazon
     * provided DNS service in the VPC that resolves public DNS hostnames to IP addresses is
     * not enabled.
     * You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for each attribute.
     */
    val enableDnsSupport: AttributeBooleanValue? = builder.enableDnsSupport
    /**
     * The ID of the VPC.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifyVpcAttributeRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyVpcAttributeRequest(")
        append("enableDnsHostnames=$enableDnsHostnames,")
        append("enableDnsSupport=$enableDnsSupport,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enableDnsHostnames?.hashCode() ?: 0
        result = 31 * result + (enableDnsSupport?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifyVpcAttributeRequest

        if (enableDnsHostnames != other.enableDnsHostnames) return false
        if (enableDnsSupport != other.enableDnsSupport) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifyVpcAttributeRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifyVpcAttributeRequest
        /**
         * Indicates whether the instances launched in the VPC get DNS hostnames. If enabled, instances in the VPC get DNS hostnames; otherwise, they do not.
         * You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for each attribute. You can only enable DNS hostnames if you've enabled DNS support.
         */
        fun enableDnsHostnames(enableDnsHostnames: AttributeBooleanValue): FluentBuilder
        /**
         * Indicates whether the DNS resolution is supported for the VPC. If enabled, queries to
         * the Amazon provided DNS server at the 169.254.169.253 IP address, or the reserved IP
         * address at the base of the VPC network range "plus two" succeed. If disabled, the Amazon
         * provided DNS service in the VPC that resolves public DNS hostnames to IP addresses is
         * not enabled.
         * You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for each attribute.
         */
        fun enableDnsSupport(enableDnsSupport: AttributeBooleanValue): FluentBuilder
        /**
         * The ID of the VPC.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether the instances launched in the VPC get DNS hostnames. If enabled, instances in the VPC get DNS hostnames; otherwise, they do not.
         * You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for each attribute. You can only enable DNS hostnames if you've enabled DNS support.
         */
        var enableDnsHostnames: AttributeBooleanValue?
        /**
         * Indicates whether the DNS resolution is supported for the VPC. If enabled, queries to
         * the Amazon provided DNS server at the 169.254.169.253 IP address, or the reserved IP
         * address at the base of the VPC network range "plus two" succeed. If disabled, the Amazon
         * provided DNS service in the VPC that resolves public DNS hostnames to IP addresses is
         * not enabled.
         * You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for each attribute.
         */
        var enableDnsSupport: AttributeBooleanValue?
        /**
         * The ID of the VPC.
         */
        var vpcId: String?

        fun build(): ModifyVpcAttributeRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue] inside the given [block]
         */
        fun enableDnsHostnames(block: AttributeBooleanValue.DslBuilder.() -> kotlin.Unit) {
            this.enableDnsHostnames = AttributeBooleanValue.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue] inside the given [block]
         */
        fun enableDnsSupport(block: AttributeBooleanValue.DslBuilder.() -> kotlin.Unit) {
            this.enableDnsSupport = AttributeBooleanValue.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var enableDnsHostnames: AttributeBooleanValue? = null
        override var enableDnsSupport: AttributeBooleanValue? = null
        override var vpcId: String? = null

        constructor(x: ModifyVpcAttributeRequest) : this() {
            this.enableDnsHostnames = x.enableDnsHostnames
            this.enableDnsSupport = x.enableDnsSupport
            this.vpcId = x.vpcId
        }

        override fun build(): ModifyVpcAttributeRequest = ModifyVpcAttributeRequest(this)
        override fun enableDnsHostnames(enableDnsHostnames: AttributeBooleanValue): FluentBuilder = apply { this.enableDnsHostnames = enableDnsHostnames }
        override fun enableDnsSupport(enableDnsSupport: AttributeBooleanValue): FluentBuilder = apply { this.enableDnsSupport = enableDnsSupport }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
