// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a NAT gateway.
 */
class NatGateway private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether the NAT gateway supports public or private connectivity.
     */
    val connectivityType: ConnectivityType? = builder.connectivityType
    /**
     * The date and time the NAT gateway was created.
     */
    val createTime: Instant? = builder.createTime
    /**
     * The date and time the NAT gateway was deleted, if applicable.
     */
    val deleteTime: Instant? = builder.deleteTime
    /**
     * If the NAT gateway could not be created, specifies the error code for the failure.
     * (InsufficientFreeAddressesInSubnet | Gateway.NotAttached |
     * InvalidAllocationID.NotFound | Resource.AlreadyAssociated |
     * InternalError | InvalidSubnetID.NotFound)
     */
    val failureCode: String? = builder.failureCode
    /**
     * If the NAT gateway could not be created, specifies the error message for the failure, that corresponds to the error code.
     * For InsufficientFreeAddressesInSubnet: "Subnet has insufficient free addresses to create this NAT gateway"
     * For Gateway.NotAttached: "Network vpc-xxxxxxxx has no Internet gateway attached"
     * For InvalidAllocationID.NotFound: "Elastic IP address eipalloc-xxxxxxxx could not be associated with this NAT gateway"
     * For Resource.AlreadyAssociated: "Elastic IP address eipalloc-xxxxxxxx is already associated"
     * For InternalError: "Network interface eni-xxxxxxxx, created and used internally by this NAT gateway is in an invalid state. Please try again."
     * For InvalidSubnetID.NotFound: "The specified subnet subnet-xxxxxxxx does not exist or could not be found."
     */
    val failureMessage: String? = builder.failureMessage
    /**
     * Information about the IP addresses and network interface associated with the NAT gateway.
     */
    val natGatewayAddresses: List<NatGatewayAddress>? = builder.natGatewayAddresses
    /**
     * The ID of the NAT gateway.
     */
    val natGatewayId: String? = builder.natGatewayId
    /**
     * Reserved. If you need to sustain traffic greater than the <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">documented limits, contact us through
     * the <a href="https://console.aws.amazon.com/support/home?">Support Center.
     */
    val provisionedBandwidth: ProvisionedBandwidth? = builder.provisionedBandwidth
    /**
     * The state of the NAT gateway.
     * pending: The NAT gateway is being created and is not ready to process
     * traffic.
     * failed: The NAT gateway could not be created. Check the
     * failureCode and failureMessage fields for the reason.
     * available: The NAT gateway is able to process traffic. This status remains
     * until you delete the NAT gateway, and does not indicate the health of the NAT gateway.
     * deleting: The NAT gateway is in the process of being terminated and may
     * still be processing traffic.
     * deleted: The NAT gateway has been terminated and is no longer processing
     * traffic.
     */
    val state: NatGatewayState? = builder.state
    /**
     * The ID of the subnet in which the NAT gateway is located.
     */
    val subnetId: String? = builder.subnetId
    /**
     * The tags for the NAT gateway.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the VPC in which the NAT gateway is located.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): NatGateway = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("NatGateway(")
        append("connectivityType=$connectivityType,")
        append("createTime=$createTime,")
        append("deleteTime=$deleteTime,")
        append("failureCode=$failureCode,")
        append("failureMessage=$failureMessage,")
        append("natGatewayAddresses=$natGatewayAddresses,")
        append("natGatewayId=$natGatewayId,")
        append("provisionedBandwidth=$provisionedBandwidth,")
        append("state=$state,")
        append("subnetId=$subnetId,")
        append("tags=$tags,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectivityType?.hashCode() ?: 0
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (deleteTime?.hashCode() ?: 0)
        result = 31 * result + (failureCode?.hashCode() ?: 0)
        result = 31 * result + (failureMessage?.hashCode() ?: 0)
        result = 31 * result + (natGatewayAddresses?.hashCode() ?: 0)
        result = 31 * result + (natGatewayId?.hashCode() ?: 0)
        result = 31 * result + (provisionedBandwidth?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as NatGateway

        if (connectivityType != other.connectivityType) return false
        if (createTime != other.createTime) return false
        if (deleteTime != other.deleteTime) return false
        if (failureCode != other.failureCode) return false
        if (failureMessage != other.failureMessage) return false
        if (natGatewayAddresses != other.natGatewayAddresses) return false
        if (natGatewayId != other.natGatewayId) return false
        if (provisionedBandwidth != other.provisionedBandwidth) return false
        if (state != other.state) return false
        if (subnetId != other.subnetId) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): NatGateway = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): NatGateway
        /**
         * Indicates whether the NAT gateway supports public or private connectivity.
         */
        fun connectivityType(connectivityType: ConnectivityType): FluentBuilder
        /**
         * The date and time the NAT gateway was created.
         */
        fun createTime(createTime: Instant): FluentBuilder
        /**
         * The date and time the NAT gateway was deleted, if applicable.
         */
        fun deleteTime(deleteTime: Instant): FluentBuilder
        /**
         * If the NAT gateway could not be created, specifies the error code for the failure.
         * (InsufficientFreeAddressesInSubnet | Gateway.NotAttached |
         * InvalidAllocationID.NotFound | Resource.AlreadyAssociated |
         * InternalError | InvalidSubnetID.NotFound)
         */
        fun failureCode(failureCode: String): FluentBuilder
        /**
         * If the NAT gateway could not be created, specifies the error message for the failure, that corresponds to the error code.
         * For InsufficientFreeAddressesInSubnet: "Subnet has insufficient free addresses to create this NAT gateway"
         * For Gateway.NotAttached: "Network vpc-xxxxxxxx has no Internet gateway attached"
         * For InvalidAllocationID.NotFound: "Elastic IP address eipalloc-xxxxxxxx could not be associated with this NAT gateway"
         * For Resource.AlreadyAssociated: "Elastic IP address eipalloc-xxxxxxxx is already associated"
         * For InternalError: "Network interface eni-xxxxxxxx, created and used internally by this NAT gateway is in an invalid state. Please try again."
         * For InvalidSubnetID.NotFound: "The specified subnet subnet-xxxxxxxx does not exist or could not be found."
         */
        fun failureMessage(failureMessage: String): FluentBuilder
        /**
         * Information about the IP addresses and network interface associated with the NAT gateway.
         */
        fun natGatewayAddresses(natGatewayAddresses: List<NatGatewayAddress>): FluentBuilder
        /**
         * The ID of the NAT gateway.
         */
        fun natGatewayId(natGatewayId: String): FluentBuilder
        /**
         * Reserved. If you need to sustain traffic greater than the <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">documented limits, contact us through
         * the <a href="https://console.aws.amazon.com/support/home?">Support Center.
         */
        fun provisionedBandwidth(provisionedBandwidth: ProvisionedBandwidth): FluentBuilder
        /**
         * The state of the NAT gateway.
         * pending: The NAT gateway is being created and is not ready to process
         * traffic.
         * failed: The NAT gateway could not be created. Check the
         * failureCode and failureMessage fields for the reason.
         * available: The NAT gateway is able to process traffic. This status remains
         * until you delete the NAT gateway, and does not indicate the health of the NAT gateway.
         * deleting: The NAT gateway is in the process of being terminated and may
         * still be processing traffic.
         * deleted: The NAT gateway has been terminated and is no longer processing
         * traffic.
         */
        fun state(state: NatGatewayState): FluentBuilder
        /**
         * The ID of the subnet in which the NAT gateway is located.
         */
        fun subnetId(subnetId: String): FluentBuilder
        /**
         * The tags for the NAT gateway.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The ID of the VPC in which the NAT gateway is located.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether the NAT gateway supports public or private connectivity.
         */
        var connectivityType: ConnectivityType?
        /**
         * The date and time the NAT gateway was created.
         */
        var createTime: Instant?
        /**
         * The date and time the NAT gateway was deleted, if applicable.
         */
        var deleteTime: Instant?
        /**
         * If the NAT gateway could not be created, specifies the error code for the failure.
         * (InsufficientFreeAddressesInSubnet | Gateway.NotAttached |
         * InvalidAllocationID.NotFound | Resource.AlreadyAssociated |
         * InternalError | InvalidSubnetID.NotFound)
         */
        var failureCode: String?
        /**
         * If the NAT gateway could not be created, specifies the error message for the failure, that corresponds to the error code.
         * For InsufficientFreeAddressesInSubnet: "Subnet has insufficient free addresses to create this NAT gateway"
         * For Gateway.NotAttached: "Network vpc-xxxxxxxx has no Internet gateway attached"
         * For InvalidAllocationID.NotFound: "Elastic IP address eipalloc-xxxxxxxx could not be associated with this NAT gateway"
         * For Resource.AlreadyAssociated: "Elastic IP address eipalloc-xxxxxxxx is already associated"
         * For InternalError: "Network interface eni-xxxxxxxx, created and used internally by this NAT gateway is in an invalid state. Please try again."
         * For InvalidSubnetID.NotFound: "The specified subnet subnet-xxxxxxxx does not exist or could not be found."
         */
        var failureMessage: String?
        /**
         * Information about the IP addresses and network interface associated with the NAT gateway.
         */
        var natGatewayAddresses: List<NatGatewayAddress>?
        /**
         * The ID of the NAT gateway.
         */
        var natGatewayId: String?
        /**
         * Reserved. If you need to sustain traffic greater than the <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">documented limits, contact us through
         * the <a href="https://console.aws.amazon.com/support/home?">Support Center.
         */
        var provisionedBandwidth: ProvisionedBandwidth?
        /**
         * The state of the NAT gateway.
         * pending: The NAT gateway is being created and is not ready to process
         * traffic.
         * failed: The NAT gateway could not be created. Check the
         * failureCode and failureMessage fields for the reason.
         * available: The NAT gateway is able to process traffic. This status remains
         * until you delete the NAT gateway, and does not indicate the health of the NAT gateway.
         * deleting: The NAT gateway is in the process of being terminated and may
         * still be processing traffic.
         * deleted: The NAT gateway has been terminated and is no longer processing
         * traffic.
         */
        var state: NatGatewayState?
        /**
         * The ID of the subnet in which the NAT gateway is located.
         */
        var subnetId: String?
        /**
         * The tags for the NAT gateway.
         */
        var tags: List<Tag>?
        /**
         * The ID of the VPC in which the NAT gateway is located.
         */
        var vpcId: String?

        fun build(): NatGateway
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ProvisionedBandwidth] inside the given [block]
         */
        fun provisionedBandwidth(block: ProvisionedBandwidth.DslBuilder.() -> kotlin.Unit) {
            this.provisionedBandwidth = ProvisionedBandwidth.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var connectivityType: ConnectivityType? = null
        override var createTime: Instant? = null
        override var deleteTime: Instant? = null
        override var failureCode: String? = null
        override var failureMessage: String? = null
        override var natGatewayAddresses: List<NatGatewayAddress>? = null
        override var natGatewayId: String? = null
        override var provisionedBandwidth: ProvisionedBandwidth? = null
        override var state: NatGatewayState? = null
        override var subnetId: String? = null
        override var tags: List<Tag>? = null
        override var vpcId: String? = null

        constructor(x: NatGateway) : this() {
            this.connectivityType = x.connectivityType
            this.createTime = x.createTime
            this.deleteTime = x.deleteTime
            this.failureCode = x.failureCode
            this.failureMessage = x.failureMessage
            this.natGatewayAddresses = x.natGatewayAddresses
            this.natGatewayId = x.natGatewayId
            this.provisionedBandwidth = x.provisionedBandwidth
            this.state = x.state
            this.subnetId = x.subnetId
            this.tags = x.tags
            this.vpcId = x.vpcId
        }

        override fun build(): NatGateway = NatGateway(this)
        override fun connectivityType(connectivityType: ConnectivityType): FluentBuilder = apply { this.connectivityType = connectivityType }
        override fun createTime(createTime: Instant): FluentBuilder = apply { this.createTime = createTime }
        override fun deleteTime(deleteTime: Instant): FluentBuilder = apply { this.deleteTime = deleteTime }
        override fun failureCode(failureCode: String): FluentBuilder = apply { this.failureCode = failureCode }
        override fun failureMessage(failureMessage: String): FluentBuilder = apply { this.failureMessage = failureMessage }
        override fun natGatewayAddresses(natGatewayAddresses: List<NatGatewayAddress>): FluentBuilder = apply { this.natGatewayAddresses = natGatewayAddresses }
        override fun natGatewayId(natGatewayId: String): FluentBuilder = apply { this.natGatewayId = natGatewayId }
        override fun provisionedBandwidth(provisionedBandwidth: ProvisionedBandwidth): FluentBuilder = apply { this.provisionedBandwidth = provisionedBandwidth }
        override fun state(state: NatGatewayState): FluentBuilder = apply { this.state = state }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
