// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the IP addresses and network interface associated with a NAT gateway.
 */
class NatGatewayAddress private constructor(builder: BuilderImpl) {
    /**
     * &#91;Public NAT gateway only&#93; The allocation ID of the Elastic IP address that's associated with the NAT gateway.
     */
    val allocationId: String? = builder.allocationId
    /**
     * The ID of the network interface associated with the NAT gateway.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * The private IP address associated with the NAT gateway.
     */
    val privateIp: String? = builder.privateIp
    /**
     * &#91;Public NAT gateway only&#93; The Elastic IP address associated with the NAT gateway.
     */
    val publicIp: String? = builder.publicIp

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): NatGatewayAddress = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("NatGatewayAddress(")
        append("allocationId=$allocationId,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("privateIp=$privateIp,")
        append("publicIp=$publicIp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationId?.hashCode() ?: 0
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (privateIp?.hashCode() ?: 0)
        result = 31 * result + (publicIp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as NatGatewayAddress

        if (allocationId != other.allocationId) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (privateIp != other.privateIp) return false
        if (publicIp != other.publicIp) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): NatGatewayAddress = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): NatGatewayAddress
        /**
         * &#91;Public NAT gateway only&#93; The allocation ID of the Elastic IP address that's associated with the NAT gateway.
         */
        fun allocationId(allocationId: String): FluentBuilder
        /**
         * The ID of the network interface associated with the NAT gateway.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * The private IP address associated with the NAT gateway.
         */
        fun privateIp(privateIp: String): FluentBuilder
        /**
         * &#91;Public NAT gateway only&#93; The Elastic IP address associated with the NAT gateway.
         */
        fun publicIp(publicIp: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * &#91;Public NAT gateway only&#93; The allocation ID of the Elastic IP address that's associated with the NAT gateway.
         */
        var allocationId: String?
        /**
         * The ID of the network interface associated with the NAT gateway.
         */
        var networkInterfaceId: String?
        /**
         * The private IP address associated with the NAT gateway.
         */
        var privateIp: String?
        /**
         * &#91;Public NAT gateway only&#93; The Elastic IP address associated with the NAT gateway.
         */
        var publicIp: String?

        fun build(): NatGatewayAddress
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allocationId: String? = null
        override var networkInterfaceId: String? = null
        override var privateIp: String? = null
        override var publicIp: String? = null

        constructor(x: NatGatewayAddress) : this() {
            this.allocationId = x.allocationId
            this.networkInterfaceId = x.networkInterfaceId
            this.privateIp = x.privateIp
            this.publicIp = x.publicIp
        }

        override fun build(): NatGatewayAddress = NatGatewayAddress(this)
        override fun allocationId(allocationId: String): FluentBuilder = apply { this.allocationId = allocationId }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun privateIp(privateIp: String): FluentBuilder = apply { this.privateIp = privateIp }
        override fun publicIp(publicIp: String): FluentBuilder = apply { this.publicIp = publicIp }
    }
}
