// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a network ACL.
 */
class NetworkAcl private constructor(builder: BuilderImpl) {
    /**
     * Any associations between the network ACL and one or more subnets
     */
    val associations: List<NetworkAclAssociation>? = builder.associations
    /**
     * One or more entries (rules) in the network ACL.
     */
    val entries: List<NetworkAclEntry>? = builder.entries
    /**
     * Indicates whether this is the default network ACL for the VPC.
     */
    val isDefault: Boolean? = builder.isDefault
    /**
     * The ID of the network ACL.
     */
    val networkAclId: String? = builder.networkAclId
    /**
     * The ID of the Amazon Web Services account that owns the network ACL.
     */
    val ownerId: String? = builder.ownerId
    /**
     * Any tags assigned to the network ACL.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the VPC for the network ACL.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): NetworkAcl = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkAcl(")
        append("associations=$associations,")
        append("entries=$entries,")
        append("isDefault=$isDefault,")
        append("networkAclId=$networkAclId,")
        append("ownerId=$ownerId,")
        append("tags=$tags,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associations?.hashCode() ?: 0
        result = 31 * result + (entries?.hashCode() ?: 0)
        result = 31 * result + (isDefault?.hashCode() ?: 0)
        result = 31 * result + (networkAclId?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as NetworkAcl

        if (associations != other.associations) return false
        if (entries != other.entries) return false
        if (isDefault != other.isDefault) return false
        if (networkAclId != other.networkAclId) return false
        if (ownerId != other.ownerId) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): NetworkAcl = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): NetworkAcl
        /**
         * Any associations between the network ACL and one or more subnets
         */
        fun associations(associations: List<NetworkAclAssociation>): FluentBuilder
        /**
         * One or more entries (rules) in the network ACL.
         */
        fun entries(entries: List<NetworkAclEntry>): FluentBuilder
        /**
         * Indicates whether this is the default network ACL for the VPC.
         */
        fun isDefault(isDefault: Boolean): FluentBuilder
        /**
         * The ID of the network ACL.
         */
        fun networkAclId(networkAclId: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the network ACL.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * Any tags assigned to the network ACL.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The ID of the VPC for the network ACL.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Any associations between the network ACL and one or more subnets
         */
        var associations: List<NetworkAclAssociation>?
        /**
         * One or more entries (rules) in the network ACL.
         */
        var entries: List<NetworkAclEntry>?
        /**
         * Indicates whether this is the default network ACL for the VPC.
         */
        var isDefault: Boolean?
        /**
         * The ID of the network ACL.
         */
        var networkAclId: String?
        /**
         * The ID of the Amazon Web Services account that owns the network ACL.
         */
        var ownerId: String?
        /**
         * Any tags assigned to the network ACL.
         */
        var tags: List<Tag>?
        /**
         * The ID of the VPC for the network ACL.
         */
        var vpcId: String?

        fun build(): NetworkAcl
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associations: List<NetworkAclAssociation>? = null
        override var entries: List<NetworkAclEntry>? = null
        override var isDefault: Boolean? = null
        override var networkAclId: String? = null
        override var ownerId: String? = null
        override var tags: List<Tag>? = null
        override var vpcId: String? = null

        constructor(x: NetworkAcl) : this() {
            this.associations = x.associations
            this.entries = x.entries
            this.isDefault = x.isDefault
            this.networkAclId = x.networkAclId
            this.ownerId = x.ownerId
            this.tags = x.tags
            this.vpcId = x.vpcId
        }

        override fun build(): NetworkAcl = NetworkAcl(this)
        override fun associations(associations: List<NetworkAclAssociation>): FluentBuilder = apply { this.associations = associations }
        override fun entries(entries: List<NetworkAclEntry>): FluentBuilder = apply { this.entries = entries }
        override fun isDefault(isDefault: Boolean): FluentBuilder = apply { this.isDefault = isDefault }
        override fun networkAclId(networkAclId: String): FluentBuilder = apply { this.networkAclId = networkAclId }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
