// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an entry in a network ACL.
 */
class NetworkAclEntry private constructor(builder: BuilderImpl) {
    /**
     * The IPv4 network range to allow or deny, in CIDR notation.
     */
    val cidrBlock: String? = builder.cidrBlock
    /**
     * Indicates whether the rule is an egress rule (applied to traffic leaving the subnet).
     */
    val egress: Boolean? = builder.egress
    /**
     * ICMP protocol: The ICMP type and code.
     */
    val icmpTypeCode: IcmpTypeCode? = builder.icmpTypeCode
    /**
     * The IPv6 network range to allow or deny, in CIDR notation.
     */
    val ipv6CidrBlock: String? = builder.ipv6CidrBlock
    /**
     * TCP or UDP protocols: The range of ports the rule applies to.
     */
    val portRange: PortRange? = builder.portRange
    /**
     * The protocol number. A value of "-1" means all protocols.
     */
    val protocol: String? = builder.protocol
    /**
     * Indicates whether to allow or deny the traffic that matches the rule.
     */
    val ruleAction: RuleAction? = builder.ruleAction
    /**
     * The rule number for the entry. ACL entries are processed in ascending order by rule number.
     */
    val ruleNumber: Int? = builder.ruleNumber

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): NetworkAclEntry = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkAclEntry(")
        append("cidrBlock=$cidrBlock,")
        append("egress=$egress,")
        append("icmpTypeCode=$icmpTypeCode,")
        append("ipv6CidrBlock=$ipv6CidrBlock,")
        append("portRange=$portRange,")
        append("protocol=$protocol,")
        append("ruleAction=$ruleAction,")
        append("ruleNumber=$ruleNumber)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrBlock?.hashCode() ?: 0
        result = 31 * result + (egress?.hashCode() ?: 0)
        result = 31 * result + (icmpTypeCode?.hashCode() ?: 0)
        result = 31 * result + (ipv6CidrBlock?.hashCode() ?: 0)
        result = 31 * result + (portRange?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (ruleAction?.hashCode() ?: 0)
        result = 31 * result + (ruleNumber ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as NetworkAclEntry

        if (cidrBlock != other.cidrBlock) return false
        if (egress != other.egress) return false
        if (icmpTypeCode != other.icmpTypeCode) return false
        if (ipv6CidrBlock != other.ipv6CidrBlock) return false
        if (portRange != other.portRange) return false
        if (protocol != other.protocol) return false
        if (ruleAction != other.ruleAction) return false
        if (ruleNumber != other.ruleNumber) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): NetworkAclEntry = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): NetworkAclEntry
        /**
         * The IPv4 network range to allow or deny, in CIDR notation.
         */
        fun cidrBlock(cidrBlock: String): FluentBuilder
        /**
         * Indicates whether the rule is an egress rule (applied to traffic leaving the subnet).
         */
        fun egress(egress: Boolean): FluentBuilder
        /**
         * ICMP protocol: The ICMP type and code.
         */
        fun icmpTypeCode(icmpTypeCode: IcmpTypeCode): FluentBuilder
        /**
         * The IPv6 network range to allow or deny, in CIDR notation.
         */
        fun ipv6CidrBlock(ipv6CidrBlock: String): FluentBuilder
        /**
         * TCP or UDP protocols: The range of ports the rule applies to.
         */
        fun portRange(portRange: PortRange): FluentBuilder
        /**
         * The protocol number. A value of "-1" means all protocols.
         */
        fun protocol(protocol: String): FluentBuilder
        /**
         * Indicates whether to allow or deny the traffic that matches the rule.
         */
        fun ruleAction(ruleAction: RuleAction): FluentBuilder
        /**
         * The rule number for the entry. ACL entries are processed in ascending order by rule number.
         */
        fun ruleNumber(ruleNumber: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The IPv4 network range to allow or deny, in CIDR notation.
         */
        var cidrBlock: String?
        /**
         * Indicates whether the rule is an egress rule (applied to traffic leaving the subnet).
         */
        var egress: Boolean?
        /**
         * ICMP protocol: The ICMP type and code.
         */
        var icmpTypeCode: IcmpTypeCode?
        /**
         * The IPv6 network range to allow or deny, in CIDR notation.
         */
        var ipv6CidrBlock: String?
        /**
         * TCP or UDP protocols: The range of ports the rule applies to.
         */
        var portRange: PortRange?
        /**
         * The protocol number. A value of "-1" means all protocols.
         */
        var protocol: String?
        /**
         * Indicates whether to allow or deny the traffic that matches the rule.
         */
        var ruleAction: RuleAction?
        /**
         * The rule number for the entry. ACL entries are processed in ascending order by rule number.
         */
        var ruleNumber: Int?

        fun build(): NetworkAclEntry
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.IcmpTypeCode] inside the given [block]
         */
        fun icmpTypeCode(block: IcmpTypeCode.DslBuilder.() -> kotlin.Unit) {
            this.icmpTypeCode = IcmpTypeCode.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.PortRange] inside the given [block]
         */
        fun portRange(block: PortRange.DslBuilder.() -> kotlin.Unit) {
            this.portRange = PortRange.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cidrBlock: String? = null
        override var egress: Boolean? = null
        override var icmpTypeCode: IcmpTypeCode? = null
        override var ipv6CidrBlock: String? = null
        override var portRange: PortRange? = null
        override var protocol: String? = null
        override var ruleAction: RuleAction? = null
        override var ruleNumber: Int? = null

        constructor(x: NetworkAclEntry) : this() {
            this.cidrBlock = x.cidrBlock
            this.egress = x.egress
            this.icmpTypeCode = x.icmpTypeCode
            this.ipv6CidrBlock = x.ipv6CidrBlock
            this.portRange = x.portRange
            this.protocol = x.protocol
            this.ruleAction = x.ruleAction
            this.ruleNumber = x.ruleNumber
        }

        override fun build(): NetworkAclEntry = NetworkAclEntry(this)
        override fun cidrBlock(cidrBlock: String): FluentBuilder = apply { this.cidrBlock = cidrBlock }
        override fun egress(egress: Boolean): FluentBuilder = apply { this.egress = egress }
        override fun icmpTypeCode(icmpTypeCode: IcmpTypeCode): FluentBuilder = apply { this.icmpTypeCode = icmpTypeCode }
        override fun ipv6CidrBlock(ipv6CidrBlock: String): FluentBuilder = apply { this.ipv6CidrBlock = ipv6CidrBlock }
        override fun portRange(portRange: PortRange): FluentBuilder = apply { this.portRange = portRange }
        override fun protocol(protocol: String): FluentBuilder = apply { this.protocol = protocol }
        override fun ruleAction(ruleAction: RuleAction): FluentBuilder = apply { this.ruleAction = ruleAction }
        override fun ruleNumber(ruleNumber: Int): FluentBuilder = apply { this.ruleNumber = ruleNumber }
    }
}
