// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the networking features of the instance type.
 */
class NetworkInfo private constructor(builder: BuilderImpl) {
    /**
     * The index of the default network card, starting at 0.
     */
    val defaultNetworkCardIndex: Int? = builder.defaultNetworkCardIndex
    /**
     * Describes the Elastic Fabric Adapters for the instance type.
     */
    val efaInfo: EfaInfo? = builder.efaInfo
    /**
     * Indicates whether Elastic Fabric Adapter (EFA) is supported.
     */
    val efaSupported: Boolean? = builder.efaSupported
    /**
     * Indicates whether Elastic Network Adapter (ENA) is supported.
     */
    val enaSupport: EnaSupport? = builder.enaSupport
    /**
     * Indicates whether the instance type automatically encrypts in-transit traffic between instances.
     */
    val encryptionInTransitSupported: Boolean? = builder.encryptionInTransitSupported
    /**
     * The maximum number of IPv4 addresses per network interface.
     */
    val ipv4AddressesPerInterface: Int? = builder.ipv4AddressesPerInterface
    /**
     * The maximum number of IPv6 addresses per network interface.
     */
    val ipv6AddressesPerInterface: Int? = builder.ipv6AddressesPerInterface
    /**
     * Indicates whether IPv6 is supported.
     */
    val ipv6Supported: Boolean? = builder.ipv6Supported
    /**
     * The maximum number of physical network cards that can be allocated to the instance.
     */
    val maximumNetworkCards: Int? = builder.maximumNetworkCards
    /**
     * The maximum number of network interfaces for the instance type.
     */
    val maximumNetworkInterfaces: Int? = builder.maximumNetworkInterfaces
    /**
     * Describes the network cards for the instance type.
     */
    val networkCards: List<NetworkCardInfo>? = builder.networkCards
    /**
     * The network performance.
     */
    val networkPerformance: String? = builder.networkPerformance

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): NetworkInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkInfo(")
        append("defaultNetworkCardIndex=$defaultNetworkCardIndex,")
        append("efaInfo=$efaInfo,")
        append("efaSupported=$efaSupported,")
        append("enaSupport=$enaSupport,")
        append("encryptionInTransitSupported=$encryptionInTransitSupported,")
        append("ipv4AddressesPerInterface=$ipv4AddressesPerInterface,")
        append("ipv6AddressesPerInterface=$ipv6AddressesPerInterface,")
        append("ipv6Supported=$ipv6Supported,")
        append("maximumNetworkCards=$maximumNetworkCards,")
        append("maximumNetworkInterfaces=$maximumNetworkInterfaces,")
        append("networkCards=$networkCards,")
        append("networkPerformance=$networkPerformance)")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultNetworkCardIndex ?: 0
        result = 31 * result + (efaInfo?.hashCode() ?: 0)
        result = 31 * result + (efaSupported?.hashCode() ?: 0)
        result = 31 * result + (enaSupport?.hashCode() ?: 0)
        result = 31 * result + (encryptionInTransitSupported?.hashCode() ?: 0)
        result = 31 * result + (ipv4AddressesPerInterface ?: 0)
        result = 31 * result + (ipv6AddressesPerInterface ?: 0)
        result = 31 * result + (ipv6Supported?.hashCode() ?: 0)
        result = 31 * result + (maximumNetworkCards ?: 0)
        result = 31 * result + (maximumNetworkInterfaces ?: 0)
        result = 31 * result + (networkCards?.hashCode() ?: 0)
        result = 31 * result + (networkPerformance?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as NetworkInfo

        if (defaultNetworkCardIndex != other.defaultNetworkCardIndex) return false
        if (efaInfo != other.efaInfo) return false
        if (efaSupported != other.efaSupported) return false
        if (enaSupport != other.enaSupport) return false
        if (encryptionInTransitSupported != other.encryptionInTransitSupported) return false
        if (ipv4AddressesPerInterface != other.ipv4AddressesPerInterface) return false
        if (ipv6AddressesPerInterface != other.ipv6AddressesPerInterface) return false
        if (ipv6Supported != other.ipv6Supported) return false
        if (maximumNetworkCards != other.maximumNetworkCards) return false
        if (maximumNetworkInterfaces != other.maximumNetworkInterfaces) return false
        if (networkCards != other.networkCards) return false
        if (networkPerformance != other.networkPerformance) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): NetworkInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): NetworkInfo
        /**
         * The index of the default network card, starting at 0.
         */
        fun defaultNetworkCardIndex(defaultNetworkCardIndex: Int): FluentBuilder
        /**
         * Describes the Elastic Fabric Adapters for the instance type.
         */
        fun efaInfo(efaInfo: EfaInfo): FluentBuilder
        /**
         * Indicates whether Elastic Fabric Adapter (EFA) is supported.
         */
        fun efaSupported(efaSupported: Boolean): FluentBuilder
        /**
         * Indicates whether Elastic Network Adapter (ENA) is supported.
         */
        fun enaSupport(enaSupport: EnaSupport): FluentBuilder
        /**
         * Indicates whether the instance type automatically encrypts in-transit traffic between instances.
         */
        fun encryptionInTransitSupported(encryptionInTransitSupported: Boolean): FluentBuilder
        /**
         * The maximum number of IPv4 addresses per network interface.
         */
        fun ipv4AddressesPerInterface(ipv4AddressesPerInterface: Int): FluentBuilder
        /**
         * The maximum number of IPv6 addresses per network interface.
         */
        fun ipv6AddressesPerInterface(ipv6AddressesPerInterface: Int): FluentBuilder
        /**
         * Indicates whether IPv6 is supported.
         */
        fun ipv6Supported(ipv6Supported: Boolean): FluentBuilder
        /**
         * The maximum number of physical network cards that can be allocated to the instance.
         */
        fun maximumNetworkCards(maximumNetworkCards: Int): FluentBuilder
        /**
         * The maximum number of network interfaces for the instance type.
         */
        fun maximumNetworkInterfaces(maximumNetworkInterfaces: Int): FluentBuilder
        /**
         * Describes the network cards for the instance type.
         */
        fun networkCards(networkCards: List<NetworkCardInfo>): FluentBuilder
        /**
         * The network performance.
         */
        fun networkPerformance(networkPerformance: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The index of the default network card, starting at 0.
         */
        var defaultNetworkCardIndex: Int?
        /**
         * Describes the Elastic Fabric Adapters for the instance type.
         */
        var efaInfo: EfaInfo?
        /**
         * Indicates whether Elastic Fabric Adapter (EFA) is supported.
         */
        var efaSupported: Boolean?
        /**
         * Indicates whether Elastic Network Adapter (ENA) is supported.
         */
        var enaSupport: EnaSupport?
        /**
         * Indicates whether the instance type automatically encrypts in-transit traffic between instances.
         */
        var encryptionInTransitSupported: Boolean?
        /**
         * The maximum number of IPv4 addresses per network interface.
         */
        var ipv4AddressesPerInterface: Int?
        /**
         * The maximum number of IPv6 addresses per network interface.
         */
        var ipv6AddressesPerInterface: Int?
        /**
         * Indicates whether IPv6 is supported.
         */
        var ipv6Supported: Boolean?
        /**
         * The maximum number of physical network cards that can be allocated to the instance.
         */
        var maximumNetworkCards: Int?
        /**
         * The maximum number of network interfaces for the instance type.
         */
        var maximumNetworkInterfaces: Int?
        /**
         * Describes the network cards for the instance type.
         */
        var networkCards: List<NetworkCardInfo>?
        /**
         * The network performance.
         */
        var networkPerformance: String?

        fun build(): NetworkInfo
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.EfaInfo] inside the given [block]
         */
        fun efaInfo(block: EfaInfo.DslBuilder.() -> kotlin.Unit) {
            this.efaInfo = EfaInfo.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var defaultNetworkCardIndex: Int? = null
        override var efaInfo: EfaInfo? = null
        override var efaSupported: Boolean? = null
        override var enaSupport: EnaSupport? = null
        override var encryptionInTransitSupported: Boolean? = null
        override var ipv4AddressesPerInterface: Int? = null
        override var ipv6AddressesPerInterface: Int? = null
        override var ipv6Supported: Boolean? = null
        override var maximumNetworkCards: Int? = null
        override var maximumNetworkInterfaces: Int? = null
        override var networkCards: List<NetworkCardInfo>? = null
        override var networkPerformance: String? = null

        constructor(x: NetworkInfo) : this() {
            this.defaultNetworkCardIndex = x.defaultNetworkCardIndex
            this.efaInfo = x.efaInfo
            this.efaSupported = x.efaSupported
            this.enaSupport = x.enaSupport
            this.encryptionInTransitSupported = x.encryptionInTransitSupported
            this.ipv4AddressesPerInterface = x.ipv4AddressesPerInterface
            this.ipv6AddressesPerInterface = x.ipv6AddressesPerInterface
            this.ipv6Supported = x.ipv6Supported
            this.maximumNetworkCards = x.maximumNetworkCards
            this.maximumNetworkInterfaces = x.maximumNetworkInterfaces
            this.networkCards = x.networkCards
            this.networkPerformance = x.networkPerformance
        }

        override fun build(): NetworkInfo = NetworkInfo(this)
        override fun defaultNetworkCardIndex(defaultNetworkCardIndex: Int): FluentBuilder = apply { this.defaultNetworkCardIndex = defaultNetworkCardIndex }
        override fun efaInfo(efaInfo: EfaInfo): FluentBuilder = apply { this.efaInfo = efaInfo }
        override fun efaSupported(efaSupported: Boolean): FluentBuilder = apply { this.efaSupported = efaSupported }
        override fun enaSupport(enaSupport: EnaSupport): FluentBuilder = apply { this.enaSupport = enaSupport }
        override fun encryptionInTransitSupported(encryptionInTransitSupported: Boolean): FluentBuilder = apply { this.encryptionInTransitSupported = encryptionInTransitSupported }
        override fun ipv4AddressesPerInterface(ipv4AddressesPerInterface: Int): FluentBuilder = apply { this.ipv4AddressesPerInterface = ipv4AddressesPerInterface }
        override fun ipv6AddressesPerInterface(ipv6AddressesPerInterface: Int): FluentBuilder = apply { this.ipv6AddressesPerInterface = ipv6AddressesPerInterface }
        override fun ipv6Supported(ipv6Supported: Boolean): FluentBuilder = apply { this.ipv6Supported = ipv6Supported }
        override fun maximumNetworkCards(maximumNetworkCards: Int): FluentBuilder = apply { this.maximumNetworkCards = maximumNetworkCards }
        override fun maximumNetworkInterfaces(maximumNetworkInterfaces: Int): FluentBuilder = apply { this.maximumNetworkInterfaces = maximumNetworkInterfaces }
        override fun networkCards(networkCards: List<NetworkCardInfo>): FluentBuilder = apply { this.networkCards = networkCards }
        override fun networkPerformance(networkPerformance: String): FluentBuilder = apply { this.networkPerformance = networkPerformance }
    }
}
