// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a network insights analysis.
 */
class NetworkInsightsAnalysis private constructor(builder: BuilderImpl) {
    /**
     * Potential intermediate components.
     */
    val alternatePathHints: List<AlternatePathHint>? = builder.alternatePathHints
    /**
     * The explanations. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability Analyzer explanation codes.
     */
    val explanations: List<Explanation>? = builder.explanations
    /**
     * The Amazon Resource Names (ARN) of the Amazon Web Services resources that the path must traverse.
     */
    val filterInArns: List<String>? = builder.filterInArns
    /**
     * The components in the path from source to destination.
     */
    val forwardPathComponents: List<PathComponent>? = builder.forwardPathComponents
    /**
     * The Amazon Resource Name (ARN) of the network insights analysis.
     */
    val networkInsightsAnalysisArn: String? = builder.networkInsightsAnalysisArn
    /**
     * The ID of the network insights analysis.
     */
    val networkInsightsAnalysisId: String? = builder.networkInsightsAnalysisId
    /**
     * The ID of the path.
     */
    val networkInsightsPathId: String? = builder.networkInsightsPathId
    /**
     * Indicates whether the destination is reachable from the source.
     */
    val networkPathFound: Boolean? = builder.networkPathFound
    /**
     * The components in the path from destination to source.
     */
    val returnPathComponents: List<PathComponent>? = builder.returnPathComponents
    /**
     * The time the analysis started.
     */
    val startDate: Instant? = builder.startDate
    /**
     * The status of the network insights analysis.
     */
    val status: AnalysisStatus? = builder.status
    /**
     * The status message, if the status is failed.
     */
    val statusMessage: String? = builder.statusMessage
    /**
     * The tags.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): NetworkInsightsAnalysis = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkInsightsAnalysis(")
        append("alternatePathHints=$alternatePathHints,")
        append("explanations=$explanations,")
        append("filterInArns=$filterInArns,")
        append("forwardPathComponents=$forwardPathComponents,")
        append("networkInsightsAnalysisArn=$networkInsightsAnalysisArn,")
        append("networkInsightsAnalysisId=$networkInsightsAnalysisId,")
        append("networkInsightsPathId=$networkInsightsPathId,")
        append("networkPathFound=$networkPathFound,")
        append("returnPathComponents=$returnPathComponents,")
        append("startDate=$startDate,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alternatePathHints?.hashCode() ?: 0
        result = 31 * result + (explanations?.hashCode() ?: 0)
        result = 31 * result + (filterInArns?.hashCode() ?: 0)
        result = 31 * result + (forwardPathComponents?.hashCode() ?: 0)
        result = 31 * result + (networkInsightsAnalysisArn?.hashCode() ?: 0)
        result = 31 * result + (networkInsightsAnalysisId?.hashCode() ?: 0)
        result = 31 * result + (networkInsightsPathId?.hashCode() ?: 0)
        result = 31 * result + (networkPathFound?.hashCode() ?: 0)
        result = 31 * result + (returnPathComponents?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as NetworkInsightsAnalysis

        if (alternatePathHints != other.alternatePathHints) return false
        if (explanations != other.explanations) return false
        if (filterInArns != other.filterInArns) return false
        if (forwardPathComponents != other.forwardPathComponents) return false
        if (networkInsightsAnalysisArn != other.networkInsightsAnalysisArn) return false
        if (networkInsightsAnalysisId != other.networkInsightsAnalysisId) return false
        if (networkInsightsPathId != other.networkInsightsPathId) return false
        if (networkPathFound != other.networkPathFound) return false
        if (returnPathComponents != other.returnPathComponents) return false
        if (startDate != other.startDate) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): NetworkInsightsAnalysis = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): NetworkInsightsAnalysis
        /**
         * Potential intermediate components.
         */
        fun alternatePathHints(alternatePathHints: List<AlternatePathHint>): FluentBuilder
        /**
         * The explanations. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability Analyzer explanation codes.
         */
        fun explanations(explanations: List<Explanation>): FluentBuilder
        /**
         * The Amazon Resource Names (ARN) of the Amazon Web Services resources that the path must traverse.
         */
        fun filterInArns(filterInArns: List<String>): FluentBuilder
        /**
         * The components in the path from source to destination.
         */
        fun forwardPathComponents(forwardPathComponents: List<PathComponent>): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the network insights analysis.
         */
        fun networkInsightsAnalysisArn(networkInsightsAnalysisArn: String): FluentBuilder
        /**
         * The ID of the network insights analysis.
         */
        fun networkInsightsAnalysisId(networkInsightsAnalysisId: String): FluentBuilder
        /**
         * The ID of the path.
         */
        fun networkInsightsPathId(networkInsightsPathId: String): FluentBuilder
        /**
         * Indicates whether the destination is reachable from the source.
         */
        fun networkPathFound(networkPathFound: Boolean): FluentBuilder
        /**
         * The components in the path from destination to source.
         */
        fun returnPathComponents(returnPathComponents: List<PathComponent>): FluentBuilder
        /**
         * The time the analysis started.
         */
        fun startDate(startDate: Instant): FluentBuilder
        /**
         * The status of the network insights analysis.
         */
        fun status(status: AnalysisStatus): FluentBuilder
        /**
         * The status message, if the status is failed.
         */
        fun statusMessage(statusMessage: String): FluentBuilder
        /**
         * The tags.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Potential intermediate components.
         */
        var alternatePathHints: List<AlternatePathHint>?
        /**
         * The explanations. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability Analyzer explanation codes.
         */
        var explanations: List<Explanation>?
        /**
         * The Amazon Resource Names (ARN) of the Amazon Web Services resources that the path must traverse.
         */
        var filterInArns: List<String>?
        /**
         * The components in the path from source to destination.
         */
        var forwardPathComponents: List<PathComponent>?
        /**
         * The Amazon Resource Name (ARN) of the network insights analysis.
         */
        var networkInsightsAnalysisArn: String?
        /**
         * The ID of the network insights analysis.
         */
        var networkInsightsAnalysisId: String?
        /**
         * The ID of the path.
         */
        var networkInsightsPathId: String?
        /**
         * Indicates whether the destination is reachable from the source.
         */
        var networkPathFound: Boolean?
        /**
         * The components in the path from destination to source.
         */
        var returnPathComponents: List<PathComponent>?
        /**
         * The time the analysis started.
         */
        var startDate: Instant?
        /**
         * The status of the network insights analysis.
         */
        var status: AnalysisStatus?
        /**
         * The status message, if the status is failed.
         */
        var statusMessage: String?
        /**
         * The tags.
         */
        var tags: List<Tag>?

        fun build(): NetworkInsightsAnalysis
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var alternatePathHints: List<AlternatePathHint>? = null
        override var explanations: List<Explanation>? = null
        override var filterInArns: List<String>? = null
        override var forwardPathComponents: List<PathComponent>? = null
        override var networkInsightsAnalysisArn: String? = null
        override var networkInsightsAnalysisId: String? = null
        override var networkInsightsPathId: String? = null
        override var networkPathFound: Boolean? = null
        override var returnPathComponents: List<PathComponent>? = null
        override var startDate: Instant? = null
        override var status: AnalysisStatus? = null
        override var statusMessage: String? = null
        override var tags: List<Tag>? = null

        constructor(x: NetworkInsightsAnalysis) : this() {
            this.alternatePathHints = x.alternatePathHints
            this.explanations = x.explanations
            this.filterInArns = x.filterInArns
            this.forwardPathComponents = x.forwardPathComponents
            this.networkInsightsAnalysisArn = x.networkInsightsAnalysisArn
            this.networkInsightsAnalysisId = x.networkInsightsAnalysisId
            this.networkInsightsPathId = x.networkInsightsPathId
            this.networkPathFound = x.networkPathFound
            this.returnPathComponents = x.returnPathComponents
            this.startDate = x.startDate
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.tags = x.tags
        }

        override fun build(): NetworkInsightsAnalysis = NetworkInsightsAnalysis(this)
        override fun alternatePathHints(alternatePathHints: List<AlternatePathHint>): FluentBuilder = apply { this.alternatePathHints = alternatePathHints }
        override fun explanations(explanations: List<Explanation>): FluentBuilder = apply { this.explanations = explanations }
        override fun filterInArns(filterInArns: List<String>): FluentBuilder = apply { this.filterInArns = filterInArns }
        override fun forwardPathComponents(forwardPathComponents: List<PathComponent>): FluentBuilder = apply { this.forwardPathComponents = forwardPathComponents }
        override fun networkInsightsAnalysisArn(networkInsightsAnalysisArn: String): FluentBuilder = apply { this.networkInsightsAnalysisArn = networkInsightsAnalysisArn }
        override fun networkInsightsAnalysisId(networkInsightsAnalysisId: String): FluentBuilder = apply { this.networkInsightsAnalysisId = networkInsightsAnalysisId }
        override fun networkInsightsPathId(networkInsightsPathId: String): FluentBuilder = apply { this.networkInsightsPathId = networkInsightsPathId }
        override fun networkPathFound(networkPathFound: Boolean): FluentBuilder = apply { this.networkPathFound = networkPathFound }
        override fun returnPathComponents(returnPathComponents: List<PathComponent>): FluentBuilder = apply { this.returnPathComponents = returnPathComponents }
        override fun startDate(startDate: Instant): FluentBuilder = apply { this.startDate = startDate }
        override fun status(status: AnalysisStatus): FluentBuilder = apply { this.status = status }
        override fun statusMessage(statusMessage: String): FluentBuilder = apply { this.statusMessage = statusMessage }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
