// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a path.
 */
class NetworkInsightsPath private constructor(builder: BuilderImpl) {
    /**
     * The time stamp when the path was created.
     */
    val createdDate: Instant? = builder.createdDate
    /**
     * The Amazon Web Services resource that is the destination of the path.
     */
    val destination: String? = builder.destination
    /**
     * The IP address of the Amazon Web Services resource that is the destination of the path.
     */
    val destinationIp: String? = builder.destinationIp
    /**
     * The destination port.
     */
    val destinationPort: Int? = builder.destinationPort
    /**
     * The Amazon Resource Name (ARN) of the path.
     */
    val networkInsightsPathArn: String? = builder.networkInsightsPathArn
    /**
     * The ID of the path.
     */
    val networkInsightsPathId: String? = builder.networkInsightsPathId
    /**
     * The protocol.
     */
    val protocol: Protocol? = builder.protocol
    /**
     * The Amazon Web Services resource that is the source of the path.
     */
    val source: String? = builder.source
    /**
     * The IP address of the Amazon Web Services resource that is the source of the path.
     */
    val sourceIp: String? = builder.sourceIp
    /**
     * The tags associated with the path.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): NetworkInsightsPath = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkInsightsPath(")
        append("createdDate=$createdDate,")
        append("destination=$destination,")
        append("destinationIp=$destinationIp,")
        append("destinationPort=$destinationPort,")
        append("networkInsightsPathArn=$networkInsightsPathArn,")
        append("networkInsightsPathId=$networkInsightsPathId,")
        append("protocol=$protocol,")
        append("source=$source,")
        append("sourceIp=$sourceIp,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdDate?.hashCode() ?: 0
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (destinationIp?.hashCode() ?: 0)
        result = 31 * result + (destinationPort ?: 0)
        result = 31 * result + (networkInsightsPathArn?.hashCode() ?: 0)
        result = 31 * result + (networkInsightsPathId?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (sourceIp?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as NetworkInsightsPath

        if (createdDate != other.createdDate) return false
        if (destination != other.destination) return false
        if (destinationIp != other.destinationIp) return false
        if (destinationPort != other.destinationPort) return false
        if (networkInsightsPathArn != other.networkInsightsPathArn) return false
        if (networkInsightsPathId != other.networkInsightsPathId) return false
        if (protocol != other.protocol) return false
        if (source != other.source) return false
        if (sourceIp != other.sourceIp) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): NetworkInsightsPath = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): NetworkInsightsPath
        /**
         * The time stamp when the path was created.
         */
        fun createdDate(createdDate: Instant): FluentBuilder
        /**
         * The Amazon Web Services resource that is the destination of the path.
         */
        fun destination(destination: String): FluentBuilder
        /**
         * The IP address of the Amazon Web Services resource that is the destination of the path.
         */
        fun destinationIp(destinationIp: String): FluentBuilder
        /**
         * The destination port.
         */
        fun destinationPort(destinationPort: Int): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the path.
         */
        fun networkInsightsPathArn(networkInsightsPathArn: String): FluentBuilder
        /**
         * The ID of the path.
         */
        fun networkInsightsPathId(networkInsightsPathId: String): FluentBuilder
        /**
         * The protocol.
         */
        fun protocol(protocol: Protocol): FluentBuilder
        /**
         * The Amazon Web Services resource that is the source of the path.
         */
        fun source(source: String): FluentBuilder
        /**
         * The IP address of the Amazon Web Services resource that is the source of the path.
         */
        fun sourceIp(sourceIp: String): FluentBuilder
        /**
         * The tags associated with the path.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The time stamp when the path was created.
         */
        var createdDate: Instant?
        /**
         * The Amazon Web Services resource that is the destination of the path.
         */
        var destination: String?
        /**
         * The IP address of the Amazon Web Services resource that is the destination of the path.
         */
        var destinationIp: String?
        /**
         * The destination port.
         */
        var destinationPort: Int?
        /**
         * The Amazon Resource Name (ARN) of the path.
         */
        var networkInsightsPathArn: String?
        /**
         * The ID of the path.
         */
        var networkInsightsPathId: String?
        /**
         * The protocol.
         */
        var protocol: Protocol?
        /**
         * The Amazon Web Services resource that is the source of the path.
         */
        var source: String?
        /**
         * The IP address of the Amazon Web Services resource that is the source of the path.
         */
        var sourceIp: String?
        /**
         * The tags associated with the path.
         */
        var tags: List<Tag>?

        fun build(): NetworkInsightsPath
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var createdDate: Instant? = null
        override var destination: String? = null
        override var destinationIp: String? = null
        override var destinationPort: Int? = null
        override var networkInsightsPathArn: String? = null
        override var networkInsightsPathId: String? = null
        override var protocol: Protocol? = null
        override var source: String? = null
        override var sourceIp: String? = null
        override var tags: List<Tag>? = null

        constructor(x: NetworkInsightsPath) : this() {
            this.createdDate = x.createdDate
            this.destination = x.destination
            this.destinationIp = x.destinationIp
            this.destinationPort = x.destinationPort
            this.networkInsightsPathArn = x.networkInsightsPathArn
            this.networkInsightsPathId = x.networkInsightsPathId
            this.protocol = x.protocol
            this.source = x.source
            this.sourceIp = x.sourceIp
            this.tags = x.tags
        }

        override fun build(): NetworkInsightsPath = NetworkInsightsPath(this)
        override fun createdDate(createdDate: Instant): FluentBuilder = apply { this.createdDate = createdDate }
        override fun destination(destination: String): FluentBuilder = apply { this.destination = destination }
        override fun destinationIp(destinationIp: String): FluentBuilder = apply { this.destinationIp = destinationIp }
        override fun destinationPort(destinationPort: Int): FluentBuilder = apply { this.destinationPort = destinationPort }
        override fun networkInsightsPathArn(networkInsightsPathArn: String): FluentBuilder = apply { this.networkInsightsPathArn = networkInsightsPathArn }
        override fun networkInsightsPathId(networkInsightsPathId: String): FluentBuilder = apply { this.networkInsightsPathId = networkInsightsPathId }
        override fun protocol(protocol: Protocol): FluentBuilder = apply { this.protocol = protocol }
        override fun source(source: String): FluentBuilder = apply { this.source = source }
        override fun sourceIp(sourceIp: String): FluentBuilder = apply { this.sourceIp = sourceIp }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
