// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a network interface.
 */
class NetworkInterface private constructor(builder: BuilderImpl) {
    /**
     * The association information for an Elastic IP address (IPv4) associated with the network interface.
     */
    val association: NetworkInterfaceAssociation? = builder.association
    /**
     * The network interface attachment.
     */
    val attachment: NetworkInterfaceAttachment? = builder.attachment
    /**
     * The Availability Zone.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * A description.
     */
    val description: String? = builder.description
    /**
     * Any security groups for the network interface.
     */
    val groups: List<GroupIdentifier>? = builder.groups
    /**
     * The type of network interface.
     */
    val interfaceType: NetworkInterfaceType? = builder.interfaceType
    /**
     * The IPv4 prefixes that are assigned to the network interface.
     */
    val ipv4Prefixes: List<Ipv4PrefixSpecification>? = builder.ipv4Prefixes
    /**
     * The IPv6 addresses associated with the network interface.
     */
    val ipv6Addresses: List<NetworkInterfaceIpv6Address>? = builder.ipv6Addresses
    /**
     * The IPv6 prefixes that are assigned to the network interface.
     */
    val ipv6Prefixes: List<Ipv6PrefixSpecification>? = builder.ipv6Prefixes
    /**
     * The MAC address.
     */
    val macAddress: String? = builder.macAddress
    /**
     * The ID of the network interface.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * The Amazon Resource Name (ARN) of the Outpost.
     */
    val outpostArn: String? = builder.outpostArn
    /**
     * The Amazon Web Services account ID of the owner of the network interface.
     */
    val ownerId: String? = builder.ownerId
    /**
     * The private DNS name.
     */
    val privateDnsName: String? = builder.privateDnsName
    /**
     * The IPv4 address of the network interface within the subnet.
     */
    val privateIpAddress: String? = builder.privateIpAddress
    /**
     * The private IPv4 addresses associated with the network interface.
     */
    val privateIpAddresses: List<NetworkInterfacePrivateIpAddress>? = builder.privateIpAddresses
    /**
     * The alias or Amazon Web Services account ID of the principal or service that created the network interface.
     */
    val requesterId: String? = builder.requesterId
    /**
     * Indicates whether the network interface is being managed by Amazon Web Services.
     */
    val requesterManaged: Boolean? = builder.requesterManaged
    /**
     * Indicates whether source/destination checking is enabled.
     */
    val sourceDestCheck: Boolean? = builder.sourceDestCheck
    /**
     * The status of the network interface.
     */
    val status: NetworkInterfaceStatus? = builder.status
    /**
     * The ID of the subnet.
     */
    val subnetId: String? = builder.subnetId
    /**
     * Any tags assigned to the network interface.
     */
    val tagSet: List<Tag>? = builder.tagSet
    /**
     * The ID of the VPC.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): NetworkInterface = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkInterface(")
        append("association=$association,")
        append("attachment=$attachment,")
        append("availabilityZone=$availabilityZone,")
        append("description=$description,")
        append("groups=$groups,")
        append("interfaceType=$interfaceType,")
        append("ipv4Prefixes=$ipv4Prefixes,")
        append("ipv6Addresses=$ipv6Addresses,")
        append("ipv6Prefixes=$ipv6Prefixes,")
        append("macAddress=$macAddress,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("outpostArn=$outpostArn,")
        append("ownerId=$ownerId,")
        append("privateDnsName=$privateDnsName,")
        append("privateIpAddress=$privateIpAddress,")
        append("privateIpAddresses=$privateIpAddresses,")
        append("requesterId=$requesterId,")
        append("requesterManaged=$requesterManaged,")
        append("sourceDestCheck=$sourceDestCheck,")
        append("status=$status,")
        append("subnetId=$subnetId,")
        append("tagSet=$tagSet,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = association?.hashCode() ?: 0
        result = 31 * result + (attachment?.hashCode() ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (groups?.hashCode() ?: 0)
        result = 31 * result + (interfaceType?.hashCode() ?: 0)
        result = 31 * result + (ipv4Prefixes?.hashCode() ?: 0)
        result = 31 * result + (ipv6Addresses?.hashCode() ?: 0)
        result = 31 * result + (ipv6Prefixes?.hashCode() ?: 0)
        result = 31 * result + (macAddress?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (privateDnsName?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddresses?.hashCode() ?: 0)
        result = 31 * result + (requesterId?.hashCode() ?: 0)
        result = 31 * result + (requesterManaged?.hashCode() ?: 0)
        result = 31 * result + (sourceDestCheck?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tagSet?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as NetworkInterface

        if (association != other.association) return false
        if (attachment != other.attachment) return false
        if (availabilityZone != other.availabilityZone) return false
        if (description != other.description) return false
        if (groups != other.groups) return false
        if (interfaceType != other.interfaceType) return false
        if (ipv4Prefixes != other.ipv4Prefixes) return false
        if (ipv6Addresses != other.ipv6Addresses) return false
        if (ipv6Prefixes != other.ipv6Prefixes) return false
        if (macAddress != other.macAddress) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (outpostArn != other.outpostArn) return false
        if (ownerId != other.ownerId) return false
        if (privateDnsName != other.privateDnsName) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (privateIpAddresses != other.privateIpAddresses) return false
        if (requesterId != other.requesterId) return false
        if (requesterManaged != other.requesterManaged) return false
        if (sourceDestCheck != other.sourceDestCheck) return false
        if (status != other.status) return false
        if (subnetId != other.subnetId) return false
        if (tagSet != other.tagSet) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): NetworkInterface = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): NetworkInterface
        /**
         * The association information for an Elastic IP address (IPv4) associated with the network interface.
         */
        fun association(association: NetworkInterfaceAssociation): FluentBuilder
        /**
         * The network interface attachment.
         */
        fun attachment(attachment: NetworkInterfaceAttachment): FluentBuilder
        /**
         * The Availability Zone.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * A description.
         */
        fun description(description: String): FluentBuilder
        /**
         * Any security groups for the network interface.
         */
        fun groups(groups: List<GroupIdentifier>): FluentBuilder
        /**
         * The type of network interface.
         */
        fun interfaceType(interfaceType: NetworkInterfaceType): FluentBuilder
        /**
         * The IPv4 prefixes that are assigned to the network interface.
         */
        fun ipv4Prefixes(ipv4Prefixes: List<Ipv4PrefixSpecification>): FluentBuilder
        /**
         * The IPv6 addresses associated with the network interface.
         */
        fun ipv6Addresses(ipv6Addresses: List<NetworkInterfaceIpv6Address>): FluentBuilder
        /**
         * The IPv6 prefixes that are assigned to the network interface.
         */
        fun ipv6Prefixes(ipv6Prefixes: List<Ipv6PrefixSpecification>): FluentBuilder
        /**
         * The MAC address.
         */
        fun macAddress(macAddress: String): FluentBuilder
        /**
         * The ID of the network interface.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Outpost.
         */
        fun outpostArn(outpostArn: String): FluentBuilder
        /**
         * The Amazon Web Services account ID of the owner of the network interface.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * The private DNS name.
         */
        fun privateDnsName(privateDnsName: String): FluentBuilder
        /**
         * The IPv4 address of the network interface within the subnet.
         */
        fun privateIpAddress(privateIpAddress: String): FluentBuilder
        /**
         * The private IPv4 addresses associated with the network interface.
         */
        fun privateIpAddresses(privateIpAddresses: List<NetworkInterfacePrivateIpAddress>): FluentBuilder
        /**
         * The alias or Amazon Web Services account ID of the principal or service that created the network interface.
         */
        fun requesterId(requesterId: String): FluentBuilder
        /**
         * Indicates whether the network interface is being managed by Amazon Web Services.
         */
        fun requesterManaged(requesterManaged: Boolean): FluentBuilder
        /**
         * Indicates whether source/destination checking is enabled.
         */
        fun sourceDestCheck(sourceDestCheck: Boolean): FluentBuilder
        /**
         * The status of the network interface.
         */
        fun status(status: NetworkInterfaceStatus): FluentBuilder
        /**
         * The ID of the subnet.
         */
        fun subnetId(subnetId: String): FluentBuilder
        /**
         * Any tags assigned to the network interface.
         */
        fun tagSet(tagSet: List<Tag>): FluentBuilder
        /**
         * The ID of the VPC.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The association information for an Elastic IP address (IPv4) associated with the network interface.
         */
        var association: NetworkInterfaceAssociation?
        /**
         * The network interface attachment.
         */
        var attachment: NetworkInterfaceAttachment?
        /**
         * The Availability Zone.
         */
        var availabilityZone: String?
        /**
         * A description.
         */
        var description: String?
        /**
         * Any security groups for the network interface.
         */
        var groups: List<GroupIdentifier>?
        /**
         * The type of network interface.
         */
        var interfaceType: NetworkInterfaceType?
        /**
         * The IPv4 prefixes that are assigned to the network interface.
         */
        var ipv4Prefixes: List<Ipv4PrefixSpecification>?
        /**
         * The IPv6 addresses associated with the network interface.
         */
        var ipv6Addresses: List<NetworkInterfaceIpv6Address>?
        /**
         * The IPv6 prefixes that are assigned to the network interface.
         */
        var ipv6Prefixes: List<Ipv6PrefixSpecification>?
        /**
         * The MAC address.
         */
        var macAddress: String?
        /**
         * The ID of the network interface.
         */
        var networkInterfaceId: String?
        /**
         * The Amazon Resource Name (ARN) of the Outpost.
         */
        var outpostArn: String?
        /**
         * The Amazon Web Services account ID of the owner of the network interface.
         */
        var ownerId: String?
        /**
         * The private DNS name.
         */
        var privateDnsName: String?
        /**
         * The IPv4 address of the network interface within the subnet.
         */
        var privateIpAddress: String?
        /**
         * The private IPv4 addresses associated with the network interface.
         */
        var privateIpAddresses: List<NetworkInterfacePrivateIpAddress>?
        /**
         * The alias or Amazon Web Services account ID of the principal or service that created the network interface.
         */
        var requesterId: String?
        /**
         * Indicates whether the network interface is being managed by Amazon Web Services.
         */
        var requesterManaged: Boolean?
        /**
         * Indicates whether source/destination checking is enabled.
         */
        var sourceDestCheck: Boolean?
        /**
         * The status of the network interface.
         */
        var status: NetworkInterfaceStatus?
        /**
         * The ID of the subnet.
         */
        var subnetId: String?
        /**
         * Any tags assigned to the network interface.
         */
        var tagSet: List<Tag>?
        /**
         * The ID of the VPC.
         */
        var vpcId: String?

        fun build(): NetworkInterface
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAssociation] inside the given [block]
         */
        fun association(block: NetworkInterfaceAssociation.DslBuilder.() -> kotlin.Unit) {
            this.association = NetworkInterfaceAssociation.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAttachment] inside the given [block]
         */
        fun attachment(block: NetworkInterfaceAttachment.DslBuilder.() -> kotlin.Unit) {
            this.attachment = NetworkInterfaceAttachment.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var association: NetworkInterfaceAssociation? = null
        override var attachment: NetworkInterfaceAttachment? = null
        override var availabilityZone: String? = null
        override var description: String? = null
        override var groups: List<GroupIdentifier>? = null
        override var interfaceType: NetworkInterfaceType? = null
        override var ipv4Prefixes: List<Ipv4PrefixSpecification>? = null
        override var ipv6Addresses: List<NetworkInterfaceIpv6Address>? = null
        override var ipv6Prefixes: List<Ipv6PrefixSpecification>? = null
        override var macAddress: String? = null
        override var networkInterfaceId: String? = null
        override var outpostArn: String? = null
        override var ownerId: String? = null
        override var privateDnsName: String? = null
        override var privateIpAddress: String? = null
        override var privateIpAddresses: List<NetworkInterfacePrivateIpAddress>? = null
        override var requesterId: String? = null
        override var requesterManaged: Boolean? = null
        override var sourceDestCheck: Boolean? = null
        override var status: NetworkInterfaceStatus? = null
        override var subnetId: String? = null
        override var tagSet: List<Tag>? = null
        override var vpcId: String? = null

        constructor(x: NetworkInterface) : this() {
            this.association = x.association
            this.attachment = x.attachment
            this.availabilityZone = x.availabilityZone
            this.description = x.description
            this.groups = x.groups
            this.interfaceType = x.interfaceType
            this.ipv4Prefixes = x.ipv4Prefixes
            this.ipv6Addresses = x.ipv6Addresses
            this.ipv6Prefixes = x.ipv6Prefixes
            this.macAddress = x.macAddress
            this.networkInterfaceId = x.networkInterfaceId
            this.outpostArn = x.outpostArn
            this.ownerId = x.ownerId
            this.privateDnsName = x.privateDnsName
            this.privateIpAddress = x.privateIpAddress
            this.privateIpAddresses = x.privateIpAddresses
            this.requesterId = x.requesterId
            this.requesterManaged = x.requesterManaged
            this.sourceDestCheck = x.sourceDestCheck
            this.status = x.status
            this.subnetId = x.subnetId
            this.tagSet = x.tagSet
            this.vpcId = x.vpcId
        }

        override fun build(): NetworkInterface = NetworkInterface(this)
        override fun association(association: NetworkInterfaceAssociation): FluentBuilder = apply { this.association = association }
        override fun attachment(attachment: NetworkInterfaceAttachment): FluentBuilder = apply { this.attachment = attachment }
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun groups(groups: List<GroupIdentifier>): FluentBuilder = apply { this.groups = groups }
        override fun interfaceType(interfaceType: NetworkInterfaceType): FluentBuilder = apply { this.interfaceType = interfaceType }
        override fun ipv4Prefixes(ipv4Prefixes: List<Ipv4PrefixSpecification>): FluentBuilder = apply { this.ipv4Prefixes = ipv4Prefixes }
        override fun ipv6Addresses(ipv6Addresses: List<NetworkInterfaceIpv6Address>): FluentBuilder = apply { this.ipv6Addresses = ipv6Addresses }
        override fun ipv6Prefixes(ipv6Prefixes: List<Ipv6PrefixSpecification>): FluentBuilder = apply { this.ipv6Prefixes = ipv6Prefixes }
        override fun macAddress(macAddress: String): FluentBuilder = apply { this.macAddress = macAddress }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun outpostArn(outpostArn: String): FluentBuilder = apply { this.outpostArn = outpostArn }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun privateDnsName(privateDnsName: String): FluentBuilder = apply { this.privateDnsName = privateDnsName }
        override fun privateIpAddress(privateIpAddress: String): FluentBuilder = apply { this.privateIpAddress = privateIpAddress }
        override fun privateIpAddresses(privateIpAddresses: List<NetworkInterfacePrivateIpAddress>): FluentBuilder = apply { this.privateIpAddresses = privateIpAddresses }
        override fun requesterId(requesterId: String): FluentBuilder = apply { this.requesterId = requesterId }
        override fun requesterManaged(requesterManaged: Boolean): FluentBuilder = apply { this.requesterManaged = requesterManaged }
        override fun sourceDestCheck(sourceDestCheck: Boolean): FluentBuilder = apply { this.sourceDestCheck = sourceDestCheck }
        override fun status(status: NetworkInterfaceStatus): FluentBuilder = apply { this.status = status }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
        override fun tagSet(tagSet: List<Tag>): FluentBuilder = apply { this.tagSet = tagSet }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
