// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes association information for an Elastic IP address (IPv4 only), or a Carrier
 * IP address (for a network interface which resides in a subnet in a Wavelength
 * Zone).
 */
class NetworkInterfaceAssociation private constructor(builder: BuilderImpl) {
    /**
     * The allocation ID.
     */
    val allocationId: String? = builder.allocationId
    /**
     * The association ID.
     */
    val associationId: String? = builder.associationId
    /**
     * The carrier IP address associated with the network interface.
     * This option is only available when the network interface is in a subnet which is associated with a Wavelength Zone.
     */
    val carrierIp: String? = builder.carrierIp
    /**
     * The customer-owned IP address associated with the network interface.
     */
    val customerOwnedIp: String? = builder.customerOwnedIp
    /**
     * The ID of the Elastic IP address owner.
     */
    val ipOwnerId: String? = builder.ipOwnerId
    /**
     * The public DNS name.
     */
    val publicDnsName: String? = builder.publicDnsName
    /**
     * The address of the Elastic IP address bound to the network
     * interface.
     */
    val publicIp: String? = builder.publicIp

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): NetworkInterfaceAssociation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkInterfaceAssociation(")
        append("allocationId=$allocationId,")
        append("associationId=$associationId,")
        append("carrierIp=$carrierIp,")
        append("customerOwnedIp=$customerOwnedIp,")
        append("ipOwnerId=$ipOwnerId,")
        append("publicDnsName=$publicDnsName,")
        append("publicIp=$publicIp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationId?.hashCode() ?: 0
        result = 31 * result + (associationId?.hashCode() ?: 0)
        result = 31 * result + (carrierIp?.hashCode() ?: 0)
        result = 31 * result + (customerOwnedIp?.hashCode() ?: 0)
        result = 31 * result + (ipOwnerId?.hashCode() ?: 0)
        result = 31 * result + (publicDnsName?.hashCode() ?: 0)
        result = 31 * result + (publicIp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as NetworkInterfaceAssociation

        if (allocationId != other.allocationId) return false
        if (associationId != other.associationId) return false
        if (carrierIp != other.carrierIp) return false
        if (customerOwnedIp != other.customerOwnedIp) return false
        if (ipOwnerId != other.ipOwnerId) return false
        if (publicDnsName != other.publicDnsName) return false
        if (publicIp != other.publicIp) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): NetworkInterfaceAssociation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): NetworkInterfaceAssociation
        /**
         * The allocation ID.
         */
        fun allocationId(allocationId: String): FluentBuilder
        /**
         * The association ID.
         */
        fun associationId(associationId: String): FluentBuilder
        /**
         * The carrier IP address associated with the network interface.
         * This option is only available when the network interface is in a subnet which is associated with a Wavelength Zone.
         */
        fun carrierIp(carrierIp: String): FluentBuilder
        /**
         * The customer-owned IP address associated with the network interface.
         */
        fun customerOwnedIp(customerOwnedIp: String): FluentBuilder
        /**
         * The ID of the Elastic IP address owner.
         */
        fun ipOwnerId(ipOwnerId: String): FluentBuilder
        /**
         * The public DNS name.
         */
        fun publicDnsName(publicDnsName: String): FluentBuilder
        /**
         * The address of the Elastic IP address bound to the network
         * interface.
         */
        fun publicIp(publicIp: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The allocation ID.
         */
        var allocationId: String?
        /**
         * The association ID.
         */
        var associationId: String?
        /**
         * The carrier IP address associated with the network interface.
         * This option is only available when the network interface is in a subnet which is associated with a Wavelength Zone.
         */
        var carrierIp: String?
        /**
         * The customer-owned IP address associated with the network interface.
         */
        var customerOwnedIp: String?
        /**
         * The ID of the Elastic IP address owner.
         */
        var ipOwnerId: String?
        /**
         * The public DNS name.
         */
        var publicDnsName: String?
        /**
         * The address of the Elastic IP address bound to the network
         * interface.
         */
        var publicIp: String?

        fun build(): NetworkInterfaceAssociation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allocationId: String? = null
        override var associationId: String? = null
        override var carrierIp: String? = null
        override var customerOwnedIp: String? = null
        override var ipOwnerId: String? = null
        override var publicDnsName: String? = null
        override var publicIp: String? = null

        constructor(x: NetworkInterfaceAssociation) : this() {
            this.allocationId = x.allocationId
            this.associationId = x.associationId
            this.carrierIp = x.carrierIp
            this.customerOwnedIp = x.customerOwnedIp
            this.ipOwnerId = x.ipOwnerId
            this.publicDnsName = x.publicDnsName
            this.publicIp = x.publicIp
        }

        override fun build(): NetworkInterfaceAssociation = NetworkInterfaceAssociation(this)
        override fun allocationId(allocationId: String): FluentBuilder = apply { this.allocationId = allocationId }
        override fun associationId(associationId: String): FluentBuilder = apply { this.associationId = associationId }
        override fun carrierIp(carrierIp: String): FluentBuilder = apply { this.carrierIp = carrierIp }
        override fun customerOwnedIp(customerOwnedIp: String): FluentBuilder = apply { this.customerOwnedIp = customerOwnedIp }
        override fun ipOwnerId(ipOwnerId: String): FluentBuilder = apply { this.ipOwnerId = ipOwnerId }
        override fun publicDnsName(publicDnsName: String): FluentBuilder = apply { this.publicDnsName = publicDnsName }
        override fun publicIp(publicIp: String): FluentBuilder = apply { this.publicIp = publicIp }
    }
}
