// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a network interface attachment.
 */
class NetworkInterfaceAttachment private constructor(builder: BuilderImpl) {
    /**
     * The timestamp indicating when the attachment initiated.
     */
    val attachTime: Instant? = builder.attachTime
    /**
     * The ID of the network interface attachment.
     */
    val attachmentId: String? = builder.attachmentId
    /**
     * Indicates whether the network interface is deleted when the instance is terminated.
     */
    val deleteOnTermination: Boolean? = builder.deleteOnTermination
    /**
     * The device index of the network interface attachment on the instance.
     */
    val deviceIndex: Int? = builder.deviceIndex
    /**
     * The ID of the instance.
     */
    val instanceId: String? = builder.instanceId
    /**
     * The Amazon Web Services account ID of the owner of the instance.
     */
    val instanceOwnerId: String? = builder.instanceOwnerId
    /**
     * The index of the network card.
     */
    val networkCardIndex: Int? = builder.networkCardIndex
    /**
     * The attachment state.
     */
    val status: AttachmentStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): NetworkInterfaceAttachment = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkInterfaceAttachment(")
        append("attachTime=$attachTime,")
        append("attachmentId=$attachmentId,")
        append("deleteOnTermination=$deleteOnTermination,")
        append("deviceIndex=$deviceIndex,")
        append("instanceId=$instanceId,")
        append("instanceOwnerId=$instanceOwnerId,")
        append("networkCardIndex=$networkCardIndex,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachTime?.hashCode() ?: 0
        result = 31 * result + (attachmentId?.hashCode() ?: 0)
        result = 31 * result + (deleteOnTermination?.hashCode() ?: 0)
        result = 31 * result + (deviceIndex ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceOwnerId?.hashCode() ?: 0)
        result = 31 * result + (networkCardIndex ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as NetworkInterfaceAttachment

        if (attachTime != other.attachTime) return false
        if (attachmentId != other.attachmentId) return false
        if (deleteOnTermination != other.deleteOnTermination) return false
        if (deviceIndex != other.deviceIndex) return false
        if (instanceId != other.instanceId) return false
        if (instanceOwnerId != other.instanceOwnerId) return false
        if (networkCardIndex != other.networkCardIndex) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): NetworkInterfaceAttachment = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): NetworkInterfaceAttachment
        /**
         * The timestamp indicating when the attachment initiated.
         */
        fun attachTime(attachTime: Instant): FluentBuilder
        /**
         * The ID of the network interface attachment.
         */
        fun attachmentId(attachmentId: String): FluentBuilder
        /**
         * Indicates whether the network interface is deleted when the instance is terminated.
         */
        fun deleteOnTermination(deleteOnTermination: Boolean): FluentBuilder
        /**
         * The device index of the network interface attachment on the instance.
         */
        fun deviceIndex(deviceIndex: Int): FluentBuilder
        /**
         * The ID of the instance.
         */
        fun instanceId(instanceId: String): FluentBuilder
        /**
         * The Amazon Web Services account ID of the owner of the instance.
         */
        fun instanceOwnerId(instanceOwnerId: String): FluentBuilder
        /**
         * The index of the network card.
         */
        fun networkCardIndex(networkCardIndex: Int): FluentBuilder
        /**
         * The attachment state.
         */
        fun status(status: AttachmentStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The timestamp indicating when the attachment initiated.
         */
        var attachTime: Instant?
        /**
         * The ID of the network interface attachment.
         */
        var attachmentId: String?
        /**
         * Indicates whether the network interface is deleted when the instance is terminated.
         */
        var deleteOnTermination: Boolean?
        /**
         * The device index of the network interface attachment on the instance.
         */
        var deviceIndex: Int?
        /**
         * The ID of the instance.
         */
        var instanceId: String?
        /**
         * The Amazon Web Services account ID of the owner of the instance.
         */
        var instanceOwnerId: String?
        /**
         * The index of the network card.
         */
        var networkCardIndex: Int?
        /**
         * The attachment state.
         */
        var status: AttachmentStatus?

        fun build(): NetworkInterfaceAttachment
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var attachTime: Instant? = null
        override var attachmentId: String? = null
        override var deleteOnTermination: Boolean? = null
        override var deviceIndex: Int? = null
        override var instanceId: String? = null
        override var instanceOwnerId: String? = null
        override var networkCardIndex: Int? = null
        override var status: AttachmentStatus? = null

        constructor(x: NetworkInterfaceAttachment) : this() {
            this.attachTime = x.attachTime
            this.attachmentId = x.attachmentId
            this.deleteOnTermination = x.deleteOnTermination
            this.deviceIndex = x.deviceIndex
            this.instanceId = x.instanceId
            this.instanceOwnerId = x.instanceOwnerId
            this.networkCardIndex = x.networkCardIndex
            this.status = x.status
        }

        override fun build(): NetworkInterfaceAttachment = NetworkInterfaceAttachment(this)
        override fun attachTime(attachTime: Instant): FluentBuilder = apply { this.attachTime = attachTime }
        override fun attachmentId(attachmentId: String): FluentBuilder = apply { this.attachmentId = attachmentId }
        override fun deleteOnTermination(deleteOnTermination: Boolean): FluentBuilder = apply { this.deleteOnTermination = deleteOnTermination }
        override fun deviceIndex(deviceIndex: Int): FluentBuilder = apply { this.deviceIndex = deviceIndex }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
        override fun instanceOwnerId(instanceOwnerId: String): FluentBuilder = apply { this.instanceOwnerId = instanceOwnerId }
        override fun networkCardIndex(networkCardIndex: Int): FluentBuilder = apply { this.networkCardIndex = networkCardIndex }
        override fun status(status: AttachmentStatus): FluentBuilder = apply { this.status = status }
    }
}
