// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a permission for a network interface.
 */
class NetworkInterfacePermission private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Web Services account ID.
     */
    val awsAccountId: String? = builder.awsAccountId
    /**
     * The Amazon Web Service.
     */
    val awsService: String? = builder.awsService
    /**
     * The ID of the network interface.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * The ID of the network interface permission.
     */
    val networkInterfacePermissionId: String? = builder.networkInterfacePermissionId
    /**
     * The type of permission.
     */
    val permission: InterfacePermissionType? = builder.permission
    /**
     * Information about the state of the permission.
     */
    val permissionState: NetworkInterfacePermissionState? = builder.permissionState

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): NetworkInterfacePermission = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkInterfacePermission(")
        append("awsAccountId=$awsAccountId,")
        append("awsService=$awsService,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("networkInterfacePermissionId=$networkInterfacePermissionId,")
        append("permission=$permission,")
        append("permissionState=$permissionState)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (awsService?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (networkInterfacePermissionId?.hashCode() ?: 0)
        result = 31 * result + (permission?.hashCode() ?: 0)
        result = 31 * result + (permissionState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as NetworkInterfacePermission

        if (awsAccountId != other.awsAccountId) return false
        if (awsService != other.awsService) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (networkInterfacePermissionId != other.networkInterfacePermissionId) return false
        if (permission != other.permission) return false
        if (permissionState != other.permissionState) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): NetworkInterfacePermission = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): NetworkInterfacePermission
        /**
         * The Amazon Web Services account ID.
         */
        fun awsAccountId(awsAccountId: String): FluentBuilder
        /**
         * The Amazon Web Service.
         */
        fun awsService(awsService: String): FluentBuilder
        /**
         * The ID of the network interface.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * The ID of the network interface permission.
         */
        fun networkInterfacePermissionId(networkInterfacePermissionId: String): FluentBuilder
        /**
         * The type of permission.
         */
        fun permission(permission: InterfacePermissionType): FluentBuilder
        /**
         * Information about the state of the permission.
         */
        fun permissionState(permissionState: NetworkInterfacePermissionState): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Web Services account ID.
         */
        var awsAccountId: String?
        /**
         * The Amazon Web Service.
         */
        var awsService: String?
        /**
         * The ID of the network interface.
         */
        var networkInterfaceId: String?
        /**
         * The ID of the network interface permission.
         */
        var networkInterfacePermissionId: String?
        /**
         * The type of permission.
         */
        var permission: InterfacePermissionType?
        /**
         * Information about the state of the permission.
         */
        var permissionState: NetworkInterfacePermissionState?

        fun build(): NetworkInterfacePermission
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.NetworkInterfacePermissionState] inside the given [block]
         */
        fun permissionState(block: NetworkInterfacePermissionState.DslBuilder.() -> kotlin.Unit) {
            this.permissionState = NetworkInterfacePermissionState.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var awsAccountId: String? = null
        override var awsService: String? = null
        override var networkInterfaceId: String? = null
        override var networkInterfacePermissionId: String? = null
        override var permission: InterfacePermissionType? = null
        override var permissionState: NetworkInterfacePermissionState? = null

        constructor(x: NetworkInterfacePermission) : this() {
            this.awsAccountId = x.awsAccountId
            this.awsService = x.awsService
            this.networkInterfaceId = x.networkInterfaceId
            this.networkInterfacePermissionId = x.networkInterfacePermissionId
            this.permission = x.permission
            this.permissionState = x.permissionState
        }

        override fun build(): NetworkInterfacePermission = NetworkInterfacePermission(this)
        override fun awsAccountId(awsAccountId: String): FluentBuilder = apply { this.awsAccountId = awsAccountId }
        override fun awsService(awsService: String): FluentBuilder = apply { this.awsService = awsService }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun networkInterfacePermissionId(networkInterfacePermissionId: String): FluentBuilder = apply { this.networkInterfacePermissionId = networkInterfacePermissionId }
        override fun permission(permission: InterfacePermissionType): FluentBuilder = apply { this.permission = permission }
        override fun permissionState(permissionState: NetworkInterfacePermissionState): FluentBuilder = apply { this.permissionState = permissionState }
    }
}
