// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the private IPv4 address of a network interface.
 */
class NetworkInterfacePrivateIpAddress private constructor(builder: BuilderImpl) {
    /**
     * The association information for an Elastic IP address (IPv4) associated with the network interface.
     */
    val association: NetworkInterfaceAssociation? = builder.association
    /**
     * Indicates whether this IPv4 address is the primary private IPv4 address of the network interface.
     */
    val primary: Boolean? = builder.primary
    /**
     * The private DNS name.
     */
    val privateDnsName: String? = builder.privateDnsName
    /**
     * The private IPv4 address.
     */
    val privateIpAddress: String? = builder.privateIpAddress

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): NetworkInterfacePrivateIpAddress = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkInterfacePrivateIpAddress(")
        append("association=$association,")
        append("primary=$primary,")
        append("privateDnsName=$privateDnsName,")
        append("privateIpAddress=$privateIpAddress)")
    }

    override fun hashCode(): kotlin.Int {
        var result = association?.hashCode() ?: 0
        result = 31 * result + (primary?.hashCode() ?: 0)
        result = 31 * result + (privateDnsName?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as NetworkInterfacePrivateIpAddress

        if (association != other.association) return false
        if (primary != other.primary) return false
        if (privateDnsName != other.privateDnsName) return false
        if (privateIpAddress != other.privateIpAddress) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): NetworkInterfacePrivateIpAddress = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): NetworkInterfacePrivateIpAddress
        /**
         * The association information for an Elastic IP address (IPv4) associated with the network interface.
         */
        fun association(association: NetworkInterfaceAssociation): FluentBuilder
        /**
         * Indicates whether this IPv4 address is the primary private IPv4 address of the network interface.
         */
        fun primary(primary: Boolean): FluentBuilder
        /**
         * The private DNS name.
         */
        fun privateDnsName(privateDnsName: String): FluentBuilder
        /**
         * The private IPv4 address.
         */
        fun privateIpAddress(privateIpAddress: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The association information for an Elastic IP address (IPv4) associated with the network interface.
         */
        var association: NetworkInterfaceAssociation?
        /**
         * Indicates whether this IPv4 address is the primary private IPv4 address of the network interface.
         */
        var primary: Boolean?
        /**
         * The private DNS name.
         */
        var privateDnsName: String?
        /**
         * The private IPv4 address.
         */
        var privateIpAddress: String?

        fun build(): NetworkInterfacePrivateIpAddress
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAssociation] inside the given [block]
         */
        fun association(block: NetworkInterfaceAssociation.DslBuilder.() -> kotlin.Unit) {
            this.association = NetworkInterfaceAssociation.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var association: NetworkInterfaceAssociation? = null
        override var primary: Boolean? = null
        override var privateDnsName: String? = null
        override var privateIpAddress: String? = null

        constructor(x: NetworkInterfacePrivateIpAddress) : this() {
            this.association = x.association
            this.primary = x.primary
            this.privateDnsName = x.privateDnsName
            this.privateIpAddress = x.privateIpAddress
        }

        override fun build(): NetworkInterfacePrivateIpAddress = NetworkInterfacePrivateIpAddress(this)
        override fun association(association: NetworkInterfaceAssociation): FluentBuilder = apply { this.association = association }
        override fun primary(primary: Boolean): FluentBuilder = apply { this.primary = primary }
        override fun privateDnsName(privateDnsName: String): FluentBuilder = apply { this.privateDnsName = privateDnsName }
        override fun privateIpAddress(privateIpAddress: String): FluentBuilder = apply { this.privateIpAddress = privateIpAddress }
    }
}
