// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the data that identifies an Amazon FPGA image (AFI) on the PCI bus.
 */
class PciId private constructor(builder: BuilderImpl) {
    /**
     * The ID of the device.
     */
    val deviceId: String? = builder.deviceId
    /**
     * The ID of the subsystem.
     */
    val subsystemId: String? = builder.subsystemId
    /**
     * The ID of the vendor for the subsystem.
     */
    val subsystemVendorId: String? = builder.subsystemVendorId
    /**
     * The ID of the vendor.
     */
    val vendorId: String? = builder.vendorId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PciId = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PciId(")
        append("deviceId=$deviceId,")
        append("subsystemId=$subsystemId,")
        append("subsystemVendorId=$subsystemVendorId,")
        append("vendorId=$vendorId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deviceId?.hashCode() ?: 0
        result = 31 * result + (subsystemId?.hashCode() ?: 0)
        result = 31 * result + (subsystemVendorId?.hashCode() ?: 0)
        result = 31 * result + (vendorId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PciId

        if (deviceId != other.deviceId) return false
        if (subsystemId != other.subsystemId) return false
        if (subsystemVendorId != other.subsystemVendorId) return false
        if (vendorId != other.vendorId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PciId = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PciId
        /**
         * The ID of the device.
         */
        fun deviceId(deviceId: String): FluentBuilder
        /**
         * The ID of the subsystem.
         */
        fun subsystemId(subsystemId: String): FluentBuilder
        /**
         * The ID of the vendor for the subsystem.
         */
        fun subsystemVendorId(subsystemVendorId: String): FluentBuilder
        /**
         * The ID of the vendor.
         */
        fun vendorId(vendorId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the device.
         */
        var deviceId: String?
        /**
         * The ID of the subsystem.
         */
        var subsystemId: String?
        /**
         * The ID of the vendor for the subsystem.
         */
        var subsystemVendorId: String?
        /**
         * The ID of the vendor.
         */
        var vendorId: String?

        fun build(): PciId
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deviceId: String? = null
        override var subsystemId: String? = null
        override var subsystemVendorId: String? = null
        override var vendorId: String? = null

        constructor(x: PciId) : this() {
            this.deviceId = x.deviceId
            this.subsystemId = x.subsystemId
            this.subsystemVendorId = x.subsystemVendorId
            this.vendorId = x.vendorId
        }

        override fun build(): PciId = PciId(this)
        override fun deviceId(deviceId: String): FluentBuilder = apply { this.deviceId = deviceId }
        override fun subsystemId(subsystemId: String): FluentBuilder = apply { this.subsystemId = subsystemId }
        override fun subsystemVendorId(subsystemVendorId: String): FluentBuilder = apply { this.subsystemVendorId = subsystemVendorId }
        override fun vendorId(vendorId: String): FluentBuilder = apply { this.vendorId = vendorId }
    }
}
