// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * The VPC peering connection options.
 */
class PeeringConnectionOptionsRequest private constructor(builder: BuilderImpl) {
    /**
     * If true, enables a local VPC to resolve public DNS hostnames to private IP addresses when queried from instances in the peer VPC.
     */
    val allowDnsResolutionFromRemoteVpc: Boolean? = builder.allowDnsResolutionFromRemoteVpc
    /**
     * If true, enables outbound communication from an EC2-Classic instance that's linked to
     * a local VPC using ClassicLink to instances in a peer VPC.
     */
    val allowEgressFromLocalClassicLinkToRemoteVpc: Boolean? = builder.allowEgressFromLocalClassicLinkToRemoteVpc
    /**
     * If true, enables outbound communication from instances in a local VPC to an
     * EC2-Classic instance that's linked to a peer VPC using ClassicLink.
     */
    val allowEgressFromLocalVpcToRemoteClassicLink: Boolean? = builder.allowEgressFromLocalVpcToRemoteClassicLink

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PeeringConnectionOptionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PeeringConnectionOptionsRequest(")
        append("allowDnsResolutionFromRemoteVpc=$allowDnsResolutionFromRemoteVpc,")
        append("allowEgressFromLocalClassicLinkToRemoteVpc=$allowEgressFromLocalClassicLinkToRemoteVpc,")
        append("allowEgressFromLocalVpcToRemoteClassicLink=$allowEgressFromLocalVpcToRemoteClassicLink)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowDnsResolutionFromRemoteVpc?.hashCode() ?: 0
        result = 31 * result + (allowEgressFromLocalClassicLinkToRemoteVpc?.hashCode() ?: 0)
        result = 31 * result + (allowEgressFromLocalVpcToRemoteClassicLink?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PeeringConnectionOptionsRequest

        if (allowDnsResolutionFromRemoteVpc != other.allowDnsResolutionFromRemoteVpc) return false
        if (allowEgressFromLocalClassicLinkToRemoteVpc != other.allowEgressFromLocalClassicLinkToRemoteVpc) return false
        if (allowEgressFromLocalVpcToRemoteClassicLink != other.allowEgressFromLocalVpcToRemoteClassicLink) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PeeringConnectionOptionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PeeringConnectionOptionsRequest
        /**
         * If true, enables a local VPC to resolve public DNS hostnames to private IP addresses when queried from instances in the peer VPC.
         */
        fun allowDnsResolutionFromRemoteVpc(allowDnsResolutionFromRemoteVpc: Boolean): FluentBuilder
        /**
         * If true, enables outbound communication from an EC2-Classic instance that's linked to
         * a local VPC using ClassicLink to instances in a peer VPC.
         */
        fun allowEgressFromLocalClassicLinkToRemoteVpc(allowEgressFromLocalClassicLinkToRemoteVpc: Boolean): FluentBuilder
        /**
         * If true, enables outbound communication from instances in a local VPC to an
         * EC2-Classic instance that's linked to a peer VPC using ClassicLink.
         */
        fun allowEgressFromLocalVpcToRemoteClassicLink(allowEgressFromLocalVpcToRemoteClassicLink: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * If true, enables a local VPC to resolve public DNS hostnames to private IP addresses when queried from instances in the peer VPC.
         */
        var allowDnsResolutionFromRemoteVpc: Boolean?
        /**
         * If true, enables outbound communication from an EC2-Classic instance that's linked to
         * a local VPC using ClassicLink to instances in a peer VPC.
         */
        var allowEgressFromLocalClassicLinkToRemoteVpc: Boolean?
        /**
         * If true, enables outbound communication from instances in a local VPC to an
         * EC2-Classic instance that's linked to a peer VPC using ClassicLink.
         */
        var allowEgressFromLocalVpcToRemoteClassicLink: Boolean?

        fun build(): PeeringConnectionOptionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allowDnsResolutionFromRemoteVpc: Boolean? = null
        override var allowEgressFromLocalClassicLinkToRemoteVpc: Boolean? = null
        override var allowEgressFromLocalVpcToRemoteClassicLink: Boolean? = null

        constructor(x: PeeringConnectionOptionsRequest) : this() {
            this.allowDnsResolutionFromRemoteVpc = x.allowDnsResolutionFromRemoteVpc
            this.allowEgressFromLocalClassicLinkToRemoteVpc = x.allowEgressFromLocalClassicLinkToRemoteVpc
            this.allowEgressFromLocalVpcToRemoteClassicLink = x.allowEgressFromLocalVpcToRemoteClassicLink
        }

        override fun build(): PeeringConnectionOptionsRequest = PeeringConnectionOptionsRequest(this)
        override fun allowDnsResolutionFromRemoteVpc(allowDnsResolutionFromRemoteVpc: Boolean): FluentBuilder = apply { this.allowDnsResolutionFromRemoteVpc = allowDnsResolutionFromRemoteVpc }
        override fun allowEgressFromLocalClassicLinkToRemoteVpc(allowEgressFromLocalClassicLinkToRemoteVpc: Boolean): FluentBuilder = apply { this.allowEgressFromLocalClassicLinkToRemoteVpc = allowEgressFromLocalClassicLinkToRemoteVpc }
        override fun allowEgressFromLocalVpcToRemoteClassicLink(allowEgressFromLocalVpcToRemoteClassicLink: Boolean): FluentBuilder = apply { this.allowEgressFromLocalVpcToRemoteClassicLink = allowEgressFromLocalVpcToRemoteClassicLink }
    }
}
