// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the placement of an instance.
 */
class Placement private constructor(builder: BuilderImpl) {
    /**
     * The affinity setting for the instance on the Dedicated Host. This parameter is not
     * supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance command.
     * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
     */
    val affinity: String? = builder.affinity
    /**
     * The Availability Zone of the instance.
     * If not specified, an Availability Zone will be automatically chosen for you based on
     * the load balancing criteria for the Region.
     * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The name of the placement group the instance is in.
     */
    val groupName: String? = builder.groupName
    /**
     * The ID of the Dedicated Host on which the instance resides. This parameter is not
     * supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance command.
     * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
     */
    val hostId: String? = builder.hostId
    /**
     * The ARN of the host resource group in which to launch the instances. If you specify
     * a host resource group ARN, omit the Tenancy
     * parameter or set it to host.
     * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
     */
    val hostResourceGroupArn: String? = builder.hostResourceGroupArn
    /**
     * The number of the partition the instance is in. Valid only if the placement group
     * strategy is set to partition.
     * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
     */
    val partitionNumber: Int? = builder.partitionNumber
    /**
     * Reserved for future use.
     * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
     */
    val spreadDomain: String? = builder.spreadDomain
    /**
     * The tenancy of the instance (if the instance is running in a VPC). An instance with a
     * tenancy of dedicated runs on single-tenant hardware. The host
     * tenancy is not supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance command.
     * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
     * T3 instances that use the unlimited CPU credit option do not support host tenancy.
     */
    val tenancy: Tenancy? = builder.tenancy

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Placement = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Placement(")
        append("affinity=$affinity,")
        append("availabilityZone=$availabilityZone,")
        append("groupName=$groupName,")
        append("hostId=$hostId,")
        append("hostResourceGroupArn=$hostResourceGroupArn,")
        append("partitionNumber=$partitionNumber,")
        append("spreadDomain=$spreadDomain,")
        append("tenancy=$tenancy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = affinity?.hashCode() ?: 0
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (hostId?.hashCode() ?: 0)
        result = 31 * result + (hostResourceGroupArn?.hashCode() ?: 0)
        result = 31 * result + (partitionNumber ?: 0)
        result = 31 * result + (spreadDomain?.hashCode() ?: 0)
        result = 31 * result + (tenancy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Placement

        if (affinity != other.affinity) return false
        if (availabilityZone != other.availabilityZone) return false
        if (groupName != other.groupName) return false
        if (hostId != other.hostId) return false
        if (hostResourceGroupArn != other.hostResourceGroupArn) return false
        if (partitionNumber != other.partitionNumber) return false
        if (spreadDomain != other.spreadDomain) return false
        if (tenancy != other.tenancy) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Placement = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Placement
        /**
         * The affinity setting for the instance on the Dedicated Host. This parameter is not
         * supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance command.
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
         */
        fun affinity(affinity: String): FluentBuilder
        /**
         * The Availability Zone of the instance.
         * If not specified, an Availability Zone will be automatically chosen for you based on
         * the load balancing criteria for the Region.
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The name of the placement group the instance is in.
         */
        fun groupName(groupName: String): FluentBuilder
        /**
         * The ID of the Dedicated Host on which the instance resides. This parameter is not
         * supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance command.
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
         */
        fun hostId(hostId: String): FluentBuilder
        /**
         * The ARN of the host resource group in which to launch the instances. If you specify
         * a host resource group ARN, omit the Tenancy
         * parameter or set it to host.
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
         */
        fun hostResourceGroupArn(hostResourceGroupArn: String): FluentBuilder
        /**
         * The number of the partition the instance is in. Valid only if the placement group
         * strategy is set to partition.
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
         */
        fun partitionNumber(partitionNumber: Int): FluentBuilder
        /**
         * Reserved for future use.
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
         */
        fun spreadDomain(spreadDomain: String): FluentBuilder
        /**
         * The tenancy of the instance (if the instance is running in a VPC). An instance with a
         * tenancy of dedicated runs on single-tenant hardware. The host
         * tenancy is not supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance command.
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
         * T3 instances that use the unlimited CPU credit option do not support host tenancy.
         */
        fun tenancy(tenancy: Tenancy): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The affinity setting for the instance on the Dedicated Host. This parameter is not
         * supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance command.
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
         */
        var affinity: String?
        /**
         * The Availability Zone of the instance.
         * If not specified, an Availability Zone will be automatically chosen for you based on
         * the load balancing criteria for the Region.
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
         */
        var availabilityZone: String?
        /**
         * The name of the placement group the instance is in.
         */
        var groupName: String?
        /**
         * The ID of the Dedicated Host on which the instance resides. This parameter is not
         * supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance command.
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
         */
        var hostId: String?
        /**
         * The ARN of the host resource group in which to launch the instances. If you specify
         * a host resource group ARN, omit the Tenancy
         * parameter or set it to host.
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
         */
        var hostResourceGroupArn: String?
        /**
         * The number of the partition the instance is in. Valid only if the placement group
         * strategy is set to partition.
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
         */
        var partitionNumber: Int?
        /**
         * Reserved for future use.
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
         */
        var spreadDomain: String?
        /**
         * The tenancy of the instance (if the instance is running in a VPC). An instance with a
         * tenancy of dedicated runs on single-tenant hardware. The host
         * tenancy is not supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance command.
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet.
         * T3 instances that use the unlimited CPU credit option do not support host tenancy.
         */
        var tenancy: Tenancy?

        fun build(): Placement
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var affinity: String? = null
        override var availabilityZone: String? = null
        override var groupName: String? = null
        override var hostId: String? = null
        override var hostResourceGroupArn: String? = null
        override var partitionNumber: Int? = null
        override var spreadDomain: String? = null
        override var tenancy: Tenancy? = null

        constructor(x: Placement) : this() {
            this.affinity = x.affinity
            this.availabilityZone = x.availabilityZone
            this.groupName = x.groupName
            this.hostId = x.hostId
            this.hostResourceGroupArn = x.hostResourceGroupArn
            this.partitionNumber = x.partitionNumber
            this.spreadDomain = x.spreadDomain
            this.tenancy = x.tenancy
        }

        override fun build(): Placement = Placement(this)
        override fun affinity(affinity: String): FluentBuilder = apply { this.affinity = affinity }
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun groupName(groupName: String): FluentBuilder = apply { this.groupName = groupName }
        override fun hostId(hostId: String): FluentBuilder = apply { this.hostId = hostId }
        override fun hostResourceGroupArn(hostResourceGroupArn: String): FluentBuilder = apply { this.hostResourceGroupArn = hostResourceGroupArn }
        override fun partitionNumber(partitionNumber: Int): FluentBuilder = apply { this.partitionNumber = partitionNumber }
        override fun spreadDomain(spreadDomain: String): FluentBuilder = apply { this.spreadDomain = spreadDomain }
        override fun tenancy(tenancy: Tenancy): FluentBuilder = apply { this.tenancy = tenancy }
    }
}
