// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a placement group.
 */
class PlacementGroup private constructor(builder: BuilderImpl) {
    /**
     * The ID of the placement group.
     */
    val groupId: String? = builder.groupId
    /**
     * The name of the placement group.
     */
    val groupName: String? = builder.groupName
    /**
     * The number of partitions. Valid only if strategy is
     * set to partition.
     */
    val partitionCount: Int? = builder.partitionCount
    /**
     * The state of the placement group.
     */
    val state: PlacementGroupState? = builder.state
    /**
     * The placement strategy.
     */
    val strategy: PlacementStrategy? = builder.strategy
    /**
     * Any tags applied to the placement group.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PlacementGroup = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PlacementGroup(")
        append("groupId=$groupId,")
        append("groupName=$groupName,")
        append("partitionCount=$partitionCount,")
        append("state=$state,")
        append("strategy=$strategy,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupId?.hashCode() ?: 0
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (partitionCount ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (strategy?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PlacementGroup

        if (groupId != other.groupId) return false
        if (groupName != other.groupName) return false
        if (partitionCount != other.partitionCount) return false
        if (state != other.state) return false
        if (strategy != other.strategy) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PlacementGroup = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PlacementGroup
        /**
         * The ID of the placement group.
         */
        fun groupId(groupId: String): FluentBuilder
        /**
         * The name of the placement group.
         */
        fun groupName(groupName: String): FluentBuilder
        /**
         * The number of partitions. Valid only if strategy is
         * set to partition.
         */
        fun partitionCount(partitionCount: Int): FluentBuilder
        /**
         * The state of the placement group.
         */
        fun state(state: PlacementGroupState): FluentBuilder
        /**
         * The placement strategy.
         */
        fun strategy(strategy: PlacementStrategy): FluentBuilder
        /**
         * Any tags applied to the placement group.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the placement group.
         */
        var groupId: String?
        /**
         * The name of the placement group.
         */
        var groupName: String?
        /**
         * The number of partitions. Valid only if strategy is
         * set to partition.
         */
        var partitionCount: Int?
        /**
         * The state of the placement group.
         */
        var state: PlacementGroupState?
        /**
         * The placement strategy.
         */
        var strategy: PlacementStrategy?
        /**
         * Any tags applied to the placement group.
         */
        var tags: List<Tag>?

        fun build(): PlacementGroup
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var groupId: String? = null
        override var groupName: String? = null
        override var partitionCount: Int? = null
        override var state: PlacementGroupState? = null
        override var strategy: PlacementStrategy? = null
        override var tags: List<Tag>? = null

        constructor(x: PlacementGroup) : this() {
            this.groupId = x.groupId
            this.groupName = x.groupName
            this.partitionCount = x.partitionCount
            this.state = x.state
            this.strategy = x.strategy
            this.tags = x.tags
        }

        override fun build(): PlacementGroup = PlacementGroup(this)
        override fun groupId(groupId: String): FluentBuilder = apply { this.groupId = groupId }
        override fun groupName(groupName: String): FluentBuilder = apply { this.groupName = groupName }
        override fun partitionCount(partitionCount: Int): FluentBuilder = apply { this.partitionCount = partitionCount }
        override fun state(state: PlacementGroupState): FluentBuilder = apply { this.state = state }
        override fun strategy(strategy: PlacementStrategy): FluentBuilder = apply { this.strategy = strategy }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
