// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the price for a Reserved Instance.
 */
class PriceSchedule private constructor(builder: BuilderImpl) {
    /**
     * The current price schedule, as determined by the term remaining for the Reserved Instance in the listing.
     * A specific price schedule is always in effect, but only one price schedule can be active at any time. Take, for example, a Reserved Instance listing that has five months remaining in its term. When you specify price schedules for five months and two months, this means that schedule 1, covering the first three months of the remaining term, will be active during months 5, 4, and 3. Then schedule 2, covering the last two months of the term, will be active for months 2 and 1.
     */
    val active: Boolean? = builder.active
    /**
     * The currency for transacting the Reserved Instance resale.
     * At this time, the only supported currency is USD.
     */
    val currencyCode: CurrencyCodeValues? = builder.currencyCode
    /**
     * The fixed price for the term.
     */
    val price: Double? = builder.price
    /**
     * The number of months remaining in the reservation. For example, 2 is the second to the last month before the capacity reservation expires.
     */
    val term: Long? = builder.term

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PriceSchedule = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PriceSchedule(")
        append("active=$active,")
        append("currencyCode=$currencyCode,")
        append("price=$price,")
        append("term=$term)")
    }

    override fun hashCode(): kotlin.Int {
        var result = active?.hashCode() ?: 0
        result = 31 * result + (currencyCode?.hashCode() ?: 0)
        result = 31 * result + (price?.hashCode() ?: 0)
        result = 31 * result + (term?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PriceSchedule

        if (active != other.active) return false
        if (currencyCode != other.currencyCode) return false
        if (price != other.price) return false
        if (term != other.term) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PriceSchedule = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PriceSchedule
        /**
         * The current price schedule, as determined by the term remaining for the Reserved Instance in the listing.
         * A specific price schedule is always in effect, but only one price schedule can be active at any time. Take, for example, a Reserved Instance listing that has five months remaining in its term. When you specify price schedules for five months and two months, this means that schedule 1, covering the first three months of the remaining term, will be active during months 5, 4, and 3. Then schedule 2, covering the last two months of the term, will be active for months 2 and 1.
         */
        fun active(active: Boolean): FluentBuilder
        /**
         * The currency for transacting the Reserved Instance resale.
         * At this time, the only supported currency is USD.
         */
        fun currencyCode(currencyCode: CurrencyCodeValues): FluentBuilder
        /**
         * The fixed price for the term.
         */
        fun price(price: Double): FluentBuilder
        /**
         * The number of months remaining in the reservation. For example, 2 is the second to the last month before the capacity reservation expires.
         */
        fun term(term: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The current price schedule, as determined by the term remaining for the Reserved Instance in the listing.
         * A specific price schedule is always in effect, but only one price schedule can be active at any time. Take, for example, a Reserved Instance listing that has five months remaining in its term. When you specify price schedules for five months and two months, this means that schedule 1, covering the first three months of the remaining term, will be active during months 5, 4, and 3. Then schedule 2, covering the last two months of the term, will be active for months 2 and 1.
         */
        var active: Boolean?
        /**
         * The currency for transacting the Reserved Instance resale.
         * At this time, the only supported currency is USD.
         */
        var currencyCode: CurrencyCodeValues?
        /**
         * The fixed price for the term.
         */
        var price: Double?
        /**
         * The number of months remaining in the reservation. For example, 2 is the second to the last month before the capacity reservation expires.
         */
        var term: Long?

        fun build(): PriceSchedule
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var active: Boolean? = null
        override var currencyCode: CurrencyCodeValues? = null
        override var price: Double? = null
        override var term: Long? = null

        constructor(x: PriceSchedule) : this() {
            this.active = x.active
            this.currencyCode = x.currencyCode
            this.price = x.price
            this.term = x.term
        }

        override fun build(): PriceSchedule = PriceSchedule(this)
        override fun active(active: Boolean): FluentBuilder = apply { this.active = active }
        override fun currencyCode(currencyCode: CurrencyCodeValues): FluentBuilder = apply { this.currencyCode = currencyCode }
        override fun price(price: Double): FluentBuilder = apply { this.price = price }
        override fun term(term: Long): FluentBuilder = apply { this.term = term }
    }
}
