// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Information about the private DNS name for the service endpoint. For more information
 * about these parameters, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/ndpoint-services-dns-validation.html">VPC Endpoint Service
 * Private DNS Name Verification in the
 * Amazon Virtual Private Cloud User Guide.
 */
class PrivateDnsNameConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The name of the record subdomain the service provider needs to create. The service provider adds the value text to the name.
     */
    val name: String? = builder.name
    /**
     * The verification state of the VPC endpoint service.
     * >Consumers
     * of the endpoint service can use the private name only when the state is
     * verified.
     */
    val state: DnsNameState? = builder.state
    /**
     * The endpoint service verification type, for example TXT.
     */
    val type: String? = builder.type
    /**
     * The value the service provider adds to the private DNS name domain record before verification.
     */
    val value: String? = builder.value

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PrivateDnsNameConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PrivateDnsNameConfiguration(")
        append("name=$name,")
        append("state=$state,")
        append("type=$type,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PrivateDnsNameConfiguration

        if (name != other.name) return false
        if (state != other.state) return false
        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PrivateDnsNameConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PrivateDnsNameConfiguration
        /**
         * The name of the record subdomain the service provider needs to create. The service provider adds the value text to the name.
         */
        fun name(name: String): FluentBuilder
        /**
         * The verification state of the VPC endpoint service.
         * >Consumers
         * of the endpoint service can use the private name only when the state is
         * verified.
         */
        fun state(state: DnsNameState): FluentBuilder
        /**
         * The endpoint service verification type, for example TXT.
         */
        fun type(type: String): FluentBuilder
        /**
         * The value the service provider adds to the private DNS name domain record before verification.
         */
        fun value(value: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the record subdomain the service provider needs to create. The service provider adds the value text to the name.
         */
        var name: String?
        /**
         * The verification state of the VPC endpoint service.
         * >Consumers
         * of the endpoint service can use the private name only when the state is
         * verified.
         */
        var state: DnsNameState?
        /**
         * The endpoint service verification type, for example TXT.
         */
        var type: String?
        /**
         * The value the service provider adds to the private DNS name domain record before verification.
         */
        var value: String?

        fun build(): PrivateDnsNameConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var name: String? = null
        override var state: DnsNameState? = null
        override var type: String? = null
        override var value: String? = null

        constructor(x: PrivateDnsNameConfiguration) : this() {
            this.name = x.name
            this.state = x.state
            this.type = x.type
            this.value = x.value
        }

        override fun build(): PrivateDnsNameConfiguration = PrivateDnsNameConfiguration(this)
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun state(state: DnsNameState): FluentBuilder = apply { this.state = state }
        override fun type(type: String): FluentBuilder = apply { this.type = type }
        override fun value(value: String): FluentBuilder = apply { this.value = value }
    }
}
