// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an IPv4 address pool.
 */
class PublicIpv4Pool private constructor(builder: BuilderImpl) {
    /**
     * A description of the address pool.
     */
    val description: String? = builder.description
    /**
     * The name of the location from which the address pool is advertised.
     * A network border group is a unique set of Availability Zones or Local Zones
     * from where Amazon Web Services advertises public IP addresses.
     */
    val networkBorderGroup: String? = builder.networkBorderGroup
    /**
     * The address ranges.
     */
    val poolAddressRanges: List<PublicIpv4PoolRange>? = builder.poolAddressRanges
    /**
     * The ID of the address pool.
     */
    val poolId: String? = builder.poolId
    /**
     * Any tags for the address pool.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The total number of addresses.
     */
    val totalAddressCount: Int? = builder.totalAddressCount
    /**
     * The total number of available addresses.
     */
    val totalAvailableAddressCount: Int? = builder.totalAvailableAddressCount

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PublicIpv4Pool = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PublicIpv4Pool(")
        append("description=$description,")
        append("networkBorderGroup=$networkBorderGroup,")
        append("poolAddressRanges=$poolAddressRanges,")
        append("poolId=$poolId,")
        append("tags=$tags,")
        append("totalAddressCount=$totalAddressCount,")
        append("totalAvailableAddressCount=$totalAvailableAddressCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (networkBorderGroup?.hashCode() ?: 0)
        result = 31 * result + (poolAddressRanges?.hashCode() ?: 0)
        result = 31 * result + (poolId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (totalAddressCount ?: 0)
        result = 31 * result + (totalAvailableAddressCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PublicIpv4Pool

        if (description != other.description) return false
        if (networkBorderGroup != other.networkBorderGroup) return false
        if (poolAddressRanges != other.poolAddressRanges) return false
        if (poolId != other.poolId) return false
        if (tags != other.tags) return false
        if (totalAddressCount != other.totalAddressCount) return false
        if (totalAvailableAddressCount != other.totalAvailableAddressCount) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PublicIpv4Pool = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PublicIpv4Pool
        /**
         * A description of the address pool.
         */
        fun description(description: String): FluentBuilder
        /**
         * The name of the location from which the address pool is advertised.
         * A network border group is a unique set of Availability Zones or Local Zones
         * from where Amazon Web Services advertises public IP addresses.
         */
        fun networkBorderGroup(networkBorderGroup: String): FluentBuilder
        /**
         * The address ranges.
         */
        fun poolAddressRanges(poolAddressRanges: List<PublicIpv4PoolRange>): FluentBuilder
        /**
         * The ID of the address pool.
         */
        fun poolId(poolId: String): FluentBuilder
        /**
         * Any tags for the address pool.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The total number of addresses.
         */
        fun totalAddressCount(totalAddressCount: Int): FluentBuilder
        /**
         * The total number of available addresses.
         */
        fun totalAvailableAddressCount(totalAvailableAddressCount: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A description of the address pool.
         */
        var description: String?
        /**
         * The name of the location from which the address pool is advertised.
         * A network border group is a unique set of Availability Zones or Local Zones
         * from where Amazon Web Services advertises public IP addresses.
         */
        var networkBorderGroup: String?
        /**
         * The address ranges.
         */
        var poolAddressRanges: List<PublicIpv4PoolRange>?
        /**
         * The ID of the address pool.
         */
        var poolId: String?
        /**
         * Any tags for the address pool.
         */
        var tags: List<Tag>?
        /**
         * The total number of addresses.
         */
        var totalAddressCount: Int?
        /**
         * The total number of available addresses.
         */
        var totalAvailableAddressCount: Int?

        fun build(): PublicIpv4Pool
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var networkBorderGroup: String? = null
        override var poolAddressRanges: List<PublicIpv4PoolRange>? = null
        override var poolId: String? = null
        override var tags: List<Tag>? = null
        override var totalAddressCount: Int? = null
        override var totalAvailableAddressCount: Int? = null

        constructor(x: PublicIpv4Pool) : this() {
            this.description = x.description
            this.networkBorderGroup = x.networkBorderGroup
            this.poolAddressRanges = x.poolAddressRanges
            this.poolId = x.poolId
            this.tags = x.tags
            this.totalAddressCount = x.totalAddressCount
            this.totalAvailableAddressCount = x.totalAvailableAddressCount
        }

        override fun build(): PublicIpv4Pool = PublicIpv4Pool(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun networkBorderGroup(networkBorderGroup: String): FluentBuilder = apply { this.networkBorderGroup = networkBorderGroup }
        override fun poolAddressRanges(poolAddressRanges: List<PublicIpv4PoolRange>): FluentBuilder = apply { this.poolAddressRanges = poolAddressRanges }
        override fun poolId(poolId: String): FluentBuilder = apply { this.poolId = poolId }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun totalAddressCount(totalAddressCount: Int): FluentBuilder = apply { this.totalAddressCount = totalAddressCount }
        override fun totalAvailableAddressCount(totalAvailableAddressCount: Int): FluentBuilder = apply { this.totalAvailableAddressCount = totalAvailableAddressCount }
    }
}
