// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an address range of an IPv4 address pool.
 */
class PublicIpv4PoolRange private constructor(builder: BuilderImpl) {
    /**
     * The number of addresses in the range.
     */
    val addressCount: Int? = builder.addressCount
    /**
     * The number of available addresses in the range.
     */
    val availableAddressCount: Int? = builder.availableAddressCount
    /**
     * The first IP address in the range.
     */
    val firstAddress: String? = builder.firstAddress
    /**
     * The last IP address in the range.
     */
    val lastAddress: String? = builder.lastAddress

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PublicIpv4PoolRange = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PublicIpv4PoolRange(")
        append("addressCount=$addressCount,")
        append("availableAddressCount=$availableAddressCount,")
        append("firstAddress=$firstAddress,")
        append("lastAddress=$lastAddress)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressCount ?: 0
        result = 31 * result + (availableAddressCount ?: 0)
        result = 31 * result + (firstAddress?.hashCode() ?: 0)
        result = 31 * result + (lastAddress?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PublicIpv4PoolRange

        if (addressCount != other.addressCount) return false
        if (availableAddressCount != other.availableAddressCount) return false
        if (firstAddress != other.firstAddress) return false
        if (lastAddress != other.lastAddress) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PublicIpv4PoolRange = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PublicIpv4PoolRange
        /**
         * The number of addresses in the range.
         */
        fun addressCount(addressCount: Int): FluentBuilder
        /**
         * The number of available addresses in the range.
         */
        fun availableAddressCount(availableAddressCount: Int): FluentBuilder
        /**
         * The first IP address in the range.
         */
        fun firstAddress(firstAddress: String): FluentBuilder
        /**
         * The last IP address in the range.
         */
        fun lastAddress(lastAddress: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of addresses in the range.
         */
        var addressCount: Int?
        /**
         * The number of available addresses in the range.
         */
        var availableAddressCount: Int?
        /**
         * The first IP address in the range.
         */
        var firstAddress: String?
        /**
         * The last IP address in the range.
         */
        var lastAddress: String?

        fun build(): PublicIpv4PoolRange
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var addressCount: Int? = null
        override var availableAddressCount: Int? = null
        override var firstAddress: String? = null
        override var lastAddress: String? = null

        constructor(x: PublicIpv4PoolRange) : this() {
            this.addressCount = x.addressCount
            this.availableAddressCount = x.availableAddressCount
            this.firstAddress = x.firstAddress
            this.lastAddress = x.lastAddress
        }

        override fun build(): PublicIpv4PoolRange = PublicIpv4PoolRange(this)
        override fun addressCount(addressCount: Int): FluentBuilder = apply { this.addressCount = addressCount }
        override fun availableAddressCount(availableAddressCount: Int): FluentBuilder = apply { this.availableAddressCount = availableAddressCount }
        override fun firstAddress(firstAddress: String): FluentBuilder = apply { this.firstAddress = firstAddress }
        override fun lastAddress(lastAddress: String): FluentBuilder = apply { this.lastAddress = lastAddress }
    }
}
