// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the result of the purchase.
 */
class Purchase private constructor(builder: BuilderImpl) {
    /**
     * The currency in which the UpfrontPrice and HourlyPrice
     * amounts are specified. At this time, the only supported currency is
     * USD.
     */
    val currencyCode: CurrencyCodeValues? = builder.currencyCode
    /**
     * The duration of the reservation's term in seconds.
     */
    val duration: Int? = builder.duration
    /**
     * The IDs of the Dedicated Hosts associated with the reservation.
     */
    val hostIdSet: List<String>? = builder.hostIdSet
    /**
     * The ID of the reservation.
     */
    val hostReservationId: String? = builder.hostReservationId
    /**
     * The hourly price of the reservation per hour.
     */
    val hourlyPrice: String? = builder.hourlyPrice
    /**
     * The instance family on the Dedicated Host that the reservation can be associated
     * with.
     */
    val instanceFamily: String? = builder.instanceFamily
    /**
     * The payment option for the reservation.
     */
    val paymentOption: PaymentOption? = builder.paymentOption
    /**
     * The upfront price of the reservation.
     */
    val upfrontPrice: String? = builder.upfrontPrice

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Purchase = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Purchase(")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("hostIdSet=$hostIdSet,")
        append("hostReservationId=$hostReservationId,")
        append("hourlyPrice=$hourlyPrice,")
        append("instanceFamily=$instanceFamily,")
        append("paymentOption=$paymentOption,")
        append("upfrontPrice=$upfrontPrice)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (duration ?: 0)
        result = 31 * result + (hostIdSet?.hashCode() ?: 0)
        result = 31 * result + (hostReservationId?.hashCode() ?: 0)
        result = 31 * result + (hourlyPrice?.hashCode() ?: 0)
        result = 31 * result + (instanceFamily?.hashCode() ?: 0)
        result = 31 * result + (paymentOption?.hashCode() ?: 0)
        result = 31 * result + (upfrontPrice?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Purchase

        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (hostIdSet != other.hostIdSet) return false
        if (hostReservationId != other.hostReservationId) return false
        if (hourlyPrice != other.hourlyPrice) return false
        if (instanceFamily != other.instanceFamily) return false
        if (paymentOption != other.paymentOption) return false
        if (upfrontPrice != other.upfrontPrice) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Purchase = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Purchase
        /**
         * The currency in which the UpfrontPrice and HourlyPrice
         * amounts are specified. At this time, the only supported currency is
         * USD.
         */
        fun currencyCode(currencyCode: CurrencyCodeValues): FluentBuilder
        /**
         * The duration of the reservation's term in seconds.
         */
        fun duration(duration: Int): FluentBuilder
        /**
         * The IDs of the Dedicated Hosts associated with the reservation.
         */
        fun hostIdSet(hostIdSet: List<String>): FluentBuilder
        /**
         * The ID of the reservation.
         */
        fun hostReservationId(hostReservationId: String): FluentBuilder
        /**
         * The hourly price of the reservation per hour.
         */
        fun hourlyPrice(hourlyPrice: String): FluentBuilder
        /**
         * The instance family on the Dedicated Host that the reservation can be associated
         * with.
         */
        fun instanceFamily(instanceFamily: String): FluentBuilder
        /**
         * The payment option for the reservation.
         */
        fun paymentOption(paymentOption: PaymentOption): FluentBuilder
        /**
         * The upfront price of the reservation.
         */
        fun upfrontPrice(upfrontPrice: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The currency in which the UpfrontPrice and HourlyPrice
         * amounts are specified. At this time, the only supported currency is
         * USD.
         */
        var currencyCode: CurrencyCodeValues?
        /**
         * The duration of the reservation's term in seconds.
         */
        var duration: Int?
        /**
         * The IDs of the Dedicated Hosts associated with the reservation.
         */
        var hostIdSet: List<String>?
        /**
         * The ID of the reservation.
         */
        var hostReservationId: String?
        /**
         * The hourly price of the reservation per hour.
         */
        var hourlyPrice: String?
        /**
         * The instance family on the Dedicated Host that the reservation can be associated
         * with.
         */
        var instanceFamily: String?
        /**
         * The payment option for the reservation.
         */
        var paymentOption: PaymentOption?
        /**
         * The upfront price of the reservation.
         */
        var upfrontPrice: String?

        fun build(): Purchase
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var currencyCode: CurrencyCodeValues? = null
        override var duration: Int? = null
        override var hostIdSet: List<String>? = null
        override var hostReservationId: String? = null
        override var hourlyPrice: String? = null
        override var instanceFamily: String? = null
        override var paymentOption: PaymentOption? = null
        override var upfrontPrice: String? = null

        constructor(x: Purchase) : this() {
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.hostIdSet = x.hostIdSet
            this.hostReservationId = x.hostReservationId
            this.hourlyPrice = x.hourlyPrice
            this.instanceFamily = x.instanceFamily
            this.paymentOption = x.paymentOption
            this.upfrontPrice = x.upfrontPrice
        }

        override fun build(): Purchase = Purchase(this)
        override fun currencyCode(currencyCode: CurrencyCodeValues): FluentBuilder = apply { this.currencyCode = currencyCode }
        override fun duration(duration: Int): FluentBuilder = apply { this.duration = duration }
        override fun hostIdSet(hostIdSet: List<String>): FluentBuilder = apply { this.hostIdSet = hostIdSet }
        override fun hostReservationId(hostReservationId: String): FluentBuilder = apply { this.hostReservationId = hostReservationId }
        override fun hourlyPrice(hourlyPrice: String): FluentBuilder = apply { this.hourlyPrice = hourlyPrice }
        override fun instanceFamily(instanceFamily: String): FluentBuilder = apply { this.instanceFamily = instanceFamily }
        override fun paymentOption(paymentOption: PaymentOption): FluentBuilder = apply { this.paymentOption = paymentOption }
        override fun upfrontPrice(upfrontPrice: String): FluentBuilder = apply { this.upfrontPrice = upfrontPrice }
    }
}
