// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class PurchaseHostReservationRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The currency in which the totalUpfrontPrice, LimitPrice,
     * and totalHourlyPrice amounts are specified. At this time, the only
     * supported currency is USD.
     */
    val currencyCode: CurrencyCodeValues? = builder.currencyCode
    /**
     * The IDs of the Dedicated Hosts with which the reservation will be associated.
     */
    val hostIdSet: List<String>? = builder.hostIdSet
    /**
     * The specified limit is checked against the total upfront cost of the reservation
     * (calculated as the offering's upfront cost multiplied by the host count). If the total
     * upfront cost is greater than the specified price limit, the request fails. This is used
     * to ensure that the purchase does not exceed the expected upfront cost of the purchase.
     * At this time, the only supported currency is USD. For example, to indicate
     * a limit price of USD 100, specify 100.00.
     */
    val limitPrice: String? = builder.limitPrice
    /**
     * The ID of the offering.
     */
    val offeringId: String? = builder.offeringId
    /**
     * The tags to apply to the Dedicated Host Reservation during purchase.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PurchaseHostReservationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PurchaseHostReservationRequest(")
        append("clientToken=$clientToken,")
        append("currencyCode=$currencyCode,")
        append("hostIdSet=$hostIdSet,")
        append("limitPrice=$limitPrice,")
        append("offeringId=$offeringId,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (currencyCode?.hashCode() ?: 0)
        result = 31 * result + (hostIdSet?.hashCode() ?: 0)
        result = 31 * result + (limitPrice?.hashCode() ?: 0)
        result = 31 * result + (offeringId?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PurchaseHostReservationRequest

        if (clientToken != other.clientToken) return false
        if (currencyCode != other.currencyCode) return false
        if (hostIdSet != other.hostIdSet) return false
        if (limitPrice != other.limitPrice) return false
        if (offeringId != other.offeringId) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PurchaseHostReservationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PurchaseHostReservationRequest
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The currency in which the totalUpfrontPrice, LimitPrice,
         * and totalHourlyPrice amounts are specified. At this time, the only
         * supported currency is USD.
         */
        fun currencyCode(currencyCode: CurrencyCodeValues): FluentBuilder
        /**
         * The IDs of the Dedicated Hosts with which the reservation will be associated.
         */
        fun hostIdSet(hostIdSet: List<String>): FluentBuilder
        /**
         * The specified limit is checked against the total upfront cost of the reservation
         * (calculated as the offering's upfront cost multiplied by the host count). If the total
         * upfront cost is greater than the specified price limit, the request fails. This is used
         * to ensure that the purchase does not exceed the expected upfront cost of the purchase.
         * At this time, the only supported currency is USD. For example, to indicate
         * a limit price of USD 100, specify 100.00.
         */
        fun limitPrice(limitPrice: String): FluentBuilder
        /**
         * The ID of the offering.
         */
        fun offeringId(offeringId: String): FluentBuilder
        /**
         * The tags to apply to the Dedicated Host Reservation during purchase.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        var clientToken: String?
        /**
         * The currency in which the totalUpfrontPrice, LimitPrice,
         * and totalHourlyPrice amounts are specified. At this time, the only
         * supported currency is USD.
         */
        var currencyCode: CurrencyCodeValues?
        /**
         * The IDs of the Dedicated Hosts with which the reservation will be associated.
         */
        var hostIdSet: List<String>?
        /**
         * The specified limit is checked against the total upfront cost of the reservation
         * (calculated as the offering's upfront cost multiplied by the host count). If the total
         * upfront cost is greater than the specified price limit, the request fails. This is used
         * to ensure that the purchase does not exceed the expected upfront cost of the purchase.
         * At this time, the only supported currency is USD. For example, to indicate
         * a limit price of USD 100, specify 100.00.
         */
        var limitPrice: String?
        /**
         * The ID of the offering.
         */
        var offeringId: String?
        /**
         * The tags to apply to the Dedicated Host Reservation during purchase.
         */
        var tagSpecifications: List<TagSpecification>?

        fun build(): PurchaseHostReservationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var currencyCode: CurrencyCodeValues? = null
        override var hostIdSet: List<String>? = null
        override var limitPrice: String? = null
        override var offeringId: String? = null
        override var tagSpecifications: List<TagSpecification>? = null

        constructor(x: PurchaseHostReservationRequest) : this() {
            this.clientToken = x.clientToken
            this.currencyCode = x.currencyCode
            this.hostIdSet = x.hostIdSet
            this.limitPrice = x.limitPrice
            this.offeringId = x.offeringId
            this.tagSpecifications = x.tagSpecifications
        }

        override fun build(): PurchaseHostReservationRequest = PurchaseHostReservationRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun currencyCode(currencyCode: CurrencyCodeValues): FluentBuilder = apply { this.currencyCode = currencyCode }
        override fun hostIdSet(hostIdSet: List<String>): FluentBuilder = apply { this.hostIdSet = hostIdSet }
        override fun limitPrice(limitPrice: String): FluentBuilder = apply { this.limitPrice = limitPrice }
        override fun offeringId(offeringId: String): FluentBuilder = apply { this.offeringId = offeringId }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
    }
}
