// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the parameters for PurchaseReservedInstancesOffering.
 */
class PurchaseReservedInstancesOfferingRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The number of Reserved Instances to purchase.
     */
    val instanceCount: Int? = builder.instanceCount
    /**
     * Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the Reserved Instances are not purchased at unexpected prices.
     */
    val limitPrice: ReservedInstanceLimitPrice? = builder.limitPrice
    /**
     * The time at which to purchase the Reserved Instance, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
     */
    val purchaseTime: Instant? = builder.purchaseTime
    /**
     * The ID of the Reserved Instance offering to purchase.
     */
    val reservedInstancesOfferingId: String? = builder.reservedInstancesOfferingId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PurchaseReservedInstancesOfferingRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PurchaseReservedInstancesOfferingRequest(")
        append("dryRun=$dryRun,")
        append("instanceCount=$instanceCount,")
        append("limitPrice=$limitPrice,")
        append("purchaseTime=$purchaseTime,")
        append("reservedInstancesOfferingId=$reservedInstancesOfferingId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (limitPrice?.hashCode() ?: 0)
        result = 31 * result + (purchaseTime?.hashCode() ?: 0)
        result = 31 * result + (reservedInstancesOfferingId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PurchaseReservedInstancesOfferingRequest

        if (dryRun != other.dryRun) return false
        if (instanceCount != other.instanceCount) return false
        if (limitPrice != other.limitPrice) return false
        if (purchaseTime != other.purchaseTime) return false
        if (reservedInstancesOfferingId != other.reservedInstancesOfferingId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PurchaseReservedInstancesOfferingRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PurchaseReservedInstancesOfferingRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The number of Reserved Instances to purchase.
         */
        fun instanceCount(instanceCount: Int): FluentBuilder
        /**
         * Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the Reserved Instances are not purchased at unexpected prices.
         */
        fun limitPrice(limitPrice: ReservedInstanceLimitPrice): FluentBuilder
        /**
         * The time at which to purchase the Reserved Instance, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
         */
        fun purchaseTime(purchaseTime: Instant): FluentBuilder
        /**
         * The ID of the Reserved Instance offering to purchase.
         */
        fun reservedInstancesOfferingId(reservedInstancesOfferingId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The number of Reserved Instances to purchase.
         */
        var instanceCount: Int?
        /**
         * Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the Reserved Instances are not purchased at unexpected prices.
         */
        var limitPrice: ReservedInstanceLimitPrice?
        /**
         * The time at which to purchase the Reserved Instance, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
         */
        var purchaseTime: Instant?
        /**
         * The ID of the Reserved Instance offering to purchase.
         */
        var reservedInstancesOfferingId: String?

        fun build(): PurchaseReservedInstancesOfferingRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ReservedInstanceLimitPrice] inside the given [block]
         */
        fun limitPrice(block: ReservedInstanceLimitPrice.DslBuilder.() -> kotlin.Unit) {
            this.limitPrice = ReservedInstanceLimitPrice.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var instanceCount: Int? = null
        override var limitPrice: ReservedInstanceLimitPrice? = null
        override var purchaseTime: Instant? = null
        override var reservedInstancesOfferingId: String? = null

        constructor(x: PurchaseReservedInstancesOfferingRequest) : this() {
            this.dryRun = x.dryRun
            this.instanceCount = x.instanceCount
            this.limitPrice = x.limitPrice
            this.purchaseTime = x.purchaseTime
            this.reservedInstancesOfferingId = x.reservedInstancesOfferingId
        }

        override fun build(): PurchaseReservedInstancesOfferingRequest = PurchaseReservedInstancesOfferingRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun instanceCount(instanceCount: Int): FluentBuilder = apply { this.instanceCount = instanceCount }
        override fun limitPrice(limitPrice: ReservedInstanceLimitPrice): FluentBuilder = apply { this.limitPrice = limitPrice }
        override fun purchaseTime(purchaseTime: Instant): FluentBuilder = apply { this.purchaseTime = purchaseTime }
        override fun reservedInstancesOfferingId(reservedInstancesOfferingId: String): FluentBuilder = apply { this.reservedInstancesOfferingId = reservedInstancesOfferingId }
    }
}
