// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for PurchaseScheduledInstances.
 */
class PurchaseScheduledInstancesRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier that ensures the idempotency of the request.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The purchase requests.
     */
    val purchaseRequests: List<PurchaseRequest>? = builder.purchaseRequests

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PurchaseScheduledInstancesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PurchaseScheduledInstancesRequest(")
        append("clientToken=$clientToken,")
        append("dryRun=$dryRun,")
        append("purchaseRequests=$purchaseRequests)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (purchaseRequests?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PurchaseScheduledInstancesRequest

        if (clientToken != other.clientToken) return false
        if (dryRun != other.dryRun) return false
        if (purchaseRequests != other.purchaseRequests) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PurchaseScheduledInstancesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PurchaseScheduledInstancesRequest
        /**
         * Unique, case-sensitive identifier that ensures the idempotency of the request.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The purchase requests.
         */
        fun purchaseRequests(purchaseRequests: List<PurchaseRequest>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier that ensures the idempotency of the request.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        var clientToken: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The purchase requests.
         */
        var purchaseRequests: List<PurchaseRequest>?

        fun build(): PurchaseScheduledInstancesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var dryRun: Boolean? = null
        override var purchaseRequests: List<PurchaseRequest>? = null

        constructor(x: PurchaseScheduledInstancesRequest) : this() {
            this.clientToken = x.clientToken
            this.dryRun = x.dryRun
            this.purchaseRequests = x.purchaseRequests
        }

        override fun build(): PurchaseScheduledInstancesRequest = PurchaseScheduledInstancesRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun purchaseRequests(purchaseRequests: List<PurchaseRequest>): FluentBuilder = apply { this.purchaseRequests = purchaseRequests }
    }
}
