// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the security group that is referenced in the security group rule.
 */
class ReferencedSecurityGroup private constructor(builder: BuilderImpl) {
    /**
     * The ID of the security group.
     */
    val groupId: String? = builder.groupId
    /**
     * The status of a VPC peering connection, if applicable.
     */
    val peeringStatus: String? = builder.peeringStatus
    /**
     * The Amazon Web Services account ID.
     */
    val userId: String? = builder.userId
    /**
     * The ID of the VPC.
     */
    val vpcId: String? = builder.vpcId
    /**
     * The ID of the VPC peering connection.
     */
    val vpcPeeringConnectionId: String? = builder.vpcPeeringConnectionId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ReferencedSecurityGroup = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ReferencedSecurityGroup(")
        append("groupId=$groupId,")
        append("peeringStatus=$peeringStatus,")
        append("userId=$userId,")
        append("vpcId=$vpcId,")
        append("vpcPeeringConnectionId=$vpcPeeringConnectionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupId?.hashCode() ?: 0
        result = 31 * result + (peeringStatus?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        result = 31 * result + (vpcPeeringConnectionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ReferencedSecurityGroup

        if (groupId != other.groupId) return false
        if (peeringStatus != other.peeringStatus) return false
        if (userId != other.userId) return false
        if (vpcId != other.vpcId) return false
        if (vpcPeeringConnectionId != other.vpcPeeringConnectionId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ReferencedSecurityGroup = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ReferencedSecurityGroup
        /**
         * The ID of the security group.
         */
        fun groupId(groupId: String): FluentBuilder
        /**
         * The status of a VPC peering connection, if applicable.
         */
        fun peeringStatus(peeringStatus: String): FluentBuilder
        /**
         * The Amazon Web Services account ID.
         */
        fun userId(userId: String): FluentBuilder
        /**
         * The ID of the VPC.
         */
        fun vpcId(vpcId: String): FluentBuilder
        /**
         * The ID of the VPC peering connection.
         */
        fun vpcPeeringConnectionId(vpcPeeringConnectionId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the security group.
         */
        var groupId: String?
        /**
         * The status of a VPC peering connection, if applicable.
         */
        var peeringStatus: String?
        /**
         * The Amazon Web Services account ID.
         */
        var userId: String?
        /**
         * The ID of the VPC.
         */
        var vpcId: String?
        /**
         * The ID of the VPC peering connection.
         */
        var vpcPeeringConnectionId: String?

        fun build(): ReferencedSecurityGroup
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var groupId: String? = null
        override var peeringStatus: String? = null
        override var userId: String? = null
        override var vpcId: String? = null
        override var vpcPeeringConnectionId: String? = null

        constructor(x: ReferencedSecurityGroup) : this() {
            this.groupId = x.groupId
            this.peeringStatus = x.peeringStatus
            this.userId = x.userId
            this.vpcId = x.vpcId
            this.vpcPeeringConnectionId = x.vpcPeeringConnectionId
        }

        override fun build(): ReferencedSecurityGroup = ReferencedSecurityGroup(this)
        override fun groupId(groupId: String): FluentBuilder = apply { this.groupId = groupId }
        override fun peeringStatus(peeringStatus: String): FluentBuilder = apply { this.peeringStatus = peeringStatus }
        override fun userId(userId: String): FluentBuilder = apply { this.userId = userId }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
        override fun vpcPeeringConnectionId(vpcPeeringConnectionId: String): FluentBuilder = apply { this.vpcPeeringConnectionId = vpcPeeringConnectionId }
    }
}
